/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Task;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.impl.BitsetIntVarImpl;
import org.chocosolver.solver.variables.impl.BoolVarEagerLit;
import org.chocosolver.solver.variables.impl.BoolVarImpl;
import org.chocosolver.solver.variables.impl.DirectedGraphVarImpl;
import org.chocosolver.solver.variables.impl.DirectedNodeInducedGraphVarImpl;
import org.chocosolver.solver.variables.impl.FixedBoolVarImpl;
import org.chocosolver.solver.variables.impl.FixedIntVarImpl;
import org.chocosolver.solver.variables.impl.FixedRealVarImpl;
import org.chocosolver.solver.variables.impl.IntVarEagerLit;
import org.chocosolver.solver.variables.impl.IntVarLazyLit;
import org.chocosolver.solver.variables.impl.IntervalIntVarImpl;
import org.chocosolver.solver.variables.impl.RealVarImpl;
import org.chocosolver.solver.variables.impl.SetVarImpl;
import org.chocosolver.solver.variables.impl.UndirectedGraphVarImpl;
import org.chocosolver.solver.variables.impl.UndirectedNodeInducedGraphVarImpl;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;
import org.chocosolver.util.tools.VariableUtils;

public interface IVariableFactory
extends ISelf<Model> {
    public static final String CSTE_NAME = "cste -- ";
    public static final String DEFAULT_PREFIX = "TMP_";

    default public BoolVar boolVar(boolean value) {
        return this.boolVar(CSTE_NAME + (value ? 1 : 0), value);
    }

    default public BoolVar boolVar(String name, boolean value) {
        int intVal;
        int n = intVal = value ? 1 : 0;
        if (name.equals(CSTE_NAME + intVal) && ((Model)this.ref()).getCachedConstants().containsKey(intVal)) {
            return (BoolVar)((Model)this.ref()).getCachedConstants().get(intVal);
        }
        AbstractVariable cste = ((Model)this.ref()).getSolver().isLCG() ? new BoolVarEagerLit(name, (Model)this.ref(), intVal, intVal) : new FixedBoolVarImpl(name, intVal, (Model)this.ref());
        if (name.equals(CSTE_NAME + intVal)) {
            ((Model)this.ref()).getCachedConstants().put(intVal, (IntVar)((Object)cste));
        }
        return cste;
    }

    default public BoolVar boolVar() {
        return this.boolVar(this.generateName("BV_"));
    }

    default public BoolVar boolVar(String name) {
        AbstractVariable bvar = ((Model)this.ref()).getSolver().isLCG() ? new BoolVarEagerLit(name, (Model)this.ref(), 0, 1) : new BoolVarImpl(name, (Model)this.ref());
        return bvar;
    }

    default public BoolVar[] boolVarArray(int size) {
        return this.boolVarArray(this.generateName("BV_"), size);
    }

    default public BoolVar[] boolVarArray(String name, int size) {
        BoolVar[] vars = new BoolVar[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.boolVar(name + "[" + i + "]");
        }
        return vars;
    }

    default public BoolVar[][] boolVarMatrix(int dim1, int dim2) {
        return this.boolVarMatrix(this.generateName("BV_"), dim1, dim2);
    }

    default public BoolVar[][] boolVarMatrix(String name, int dim1, int dim2) {
        BoolVar[][] vars = new BoolVar[dim1][];
        for (int i = 0; i < dim1; ++i) {
            vars[i] = this.boolVarArray(name + "[" + i + "]", dim2);
        }
        return vars;
    }

    default public IntVar intVar(int value) {
        return this.intVar(CSTE_NAME + value, value);
    }

    default public IntVar intVar(int[] values) {
        return this.intVar(this.generateName("IV_"), values);
    }

    default public IntVar intVar(int lb, int ub) {
        if (lb == ub) {
            return this.intVar(lb);
        }
        return this.intVar(this.generateName("IV_"), lb, ub);
    }

    default public IntVar intVar(int lb, int ub, boolean boundedDomain) {
        if (lb == ub) {
            return this.intVar(lb);
        }
        return this.intVar(this.generateName("IV_"), lb, ub, boundedDomain);
    }

    default public IntVar intVar(String name, int value) {
        this.checkIntDomainRange(name, value, value);
        if (value == 0 || value == 1) {
            return this.boolVar(name, value == 1);
        }
        if (name.equals(CSTE_NAME + value) && ((Model)this.ref()).getCachedConstants().containsKey(value)) {
            return ((Model)this.ref()).getCachedConstants().get(value);
        }
        AbstractVariable cste = new FixedIntVarImpl(name, value, (Model)this.ref());
        if (((Model)this.ref()).getSolver().isLCG()) {
            cste = new IntVarEagerLit((IntVar)((Object)cste));
        }
        if (name.equals(CSTE_NAME + value)) {
            ((Model)this.ref()).getCachedConstants().put(value, (IntVar)((Object)cste));
        }
        return cste;
    }

    default public IntVar intVar(String name, int lb, int ub, boolean boundedDomain) {
        this.checkIntDomainRange(name, lb, ub);
        if (lb == ub) {
            return this.intVar(name, lb);
        }
        if (lb == 0 && ub == 1) {
            return this.boolVar(name);
        }
        if (boundedDomain) {
            AbstractVariable v = new IntervalIntVarImpl(name, lb, ub, (Model)this.ref());
            if (((Model)this.ref()).getSolver().isLCG()) {
                v = new IntVarLazyLit((IntVar)((Object)v));
            }
            return v;
        }
        AbstractVariable v = new BitsetIntVarImpl(name, lb, ub, (Model)this.ref());
        if (((Model)this.ref()).getSolver().isLCG()) {
            v = new IntVarEagerLit((IntVar)((Object)v));
        }
        return v;
    }

    default public IntVar intVar(String name, int lb, int ub) {
        boolean bounded = ub - lb + 1 >= ((Model)this.ref()).getSettings().getMaxDomSizeForEnumerated();
        return this.intVar(name, lb, ub, bounded);
    }

    default public IntVar intVar(String name, int[] values) {
        values = ArrayUtils.mergeAndSortIfNot((int[])values.clone());
        this.checkIntDomainRange(name, values[0], values[values.length - 1]);
        if (values.length == 1) {
            return this.intVar(name, values[0]);
        }
        if (values.length == 2 && values[0] == 0 && values[1] == 1) {
            return this.boolVar(name);
        }
        AbstractVariable v = new BitsetIntVarImpl(name, values, (Model)this.ref());
        if (((Model)this.ref()).getSettings().isLCG()) {
            v = new IntVarEagerLit((IntVar)((Object)v));
        }
        return v;
    }

    default public IntVar intVar(IntVar from) {
        String name = this.generateName("IV_");
        if (from.hasEnumeratedDomain()) {
            int[] values = from.stream().toArray();
            return this.intVar(name, values);
        }
        int lb = from.getLB();
        int ub = from.getUB();
        return this.intVar(name, lb, ub);
    }

    default public IntVar intVar(String name, IntVar from) {
        if (from.hasEnumeratedDomain()) {
            int[] values = from.stream().toArray();
            return this.intVar(name, values);
        }
        int lb = from.getLB();
        int ub = from.getUB();
        return this.intVar(name, lb, ub);
    }

    default public IntVar[] intVarArray(int size, int[] values) {
        return this.intVarArray(this.generateName("IV_"), size, values);
    }

    default public IntVar[] intVarArray(int size, int lb, int ub) {
        return this.intVarArray(this.generateName("IV_"), size, lb, ub);
    }

    default public IntVar[] intVarArray(int size, int lb, int ub, boolean boundedDomain) {
        return this.intVarArray(this.generateName("IV_"), size, lb, ub, boundedDomain);
    }

    default public IntVar[] intVarArray(String name, int size, int lb, int ub, boolean boundedDomain) {
        IntVar[] vars = new IntVar[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.intVar(name + "[" + i + "]", lb, ub, boundedDomain);
        }
        return vars;
    }

    default public IntVar[] intVarArray(String name, int size, int lb, int ub) {
        IntVar[] vars = new IntVar[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.intVar(name + "[" + i + "]", lb, ub);
        }
        return vars;
    }

    default public IntVar[] intVarArray(String name, int size, int[] values) {
        IntVar[] vars = new IntVar[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.intVar(name + "[" + i + "]", values);
        }
        return vars;
    }

    default public IntVar[][] intVarMatrix(int dim1, int dim2, int[] values) {
        return this.intVarMatrix(this.generateName("IV_"), dim1, dim2, values);
    }

    default public IntVar[][] intVarMatrix(int dim1, int dim2, int lb, int ub) {
        return this.intVarMatrix(this.generateName("IV_"), dim1, dim2, lb, ub);
    }

    default public IntVar[][] intVarMatrix(int dim1, int dim2, int lb, int ub, boolean boundedDomain) {
        return this.intVarMatrix(this.generateName("IV_"), dim1, dim2, lb, ub, boundedDomain);
    }

    default public IntVar[][] intVarMatrix(String name, int dim1, int dim2, int lb, int ub, boolean boundedDomain) {
        IntVar[][] vars = new IntVar[dim1][dim2];
        for (int i = 0; i < dim1; ++i) {
            vars[i] = this.intVarArray(name + "[" + i + "]", dim2, lb, ub, boundedDomain);
        }
        return vars;
    }

    default public IntVar[][] intVarMatrix(String name, int dim1, int dim2, int lb, int ub) {
        IntVar[][] vars = new IntVar[dim1][dim2];
        for (int i = 0; i < dim1; ++i) {
            vars[i] = this.intVarArray(name + "[" + i + "]", dim2, lb, ub);
        }
        return vars;
    }

    default public IntVar[][] intVarMatrix(String name, int dim1, int dim2, int[] values) {
        IntVar[][] vars = new IntVar[dim1][dim2];
        for (int i = 0; i < dim1; ++i) {
            vars[i] = this.intVarArray(name + "[" + i + "]", dim2, values);
        }
        return vars;
    }

    default public Task taskVar(IntVar s, int d) {
        return new Task(s, d);
    }

    default public Task taskVar(IntVar s, IntVar d) {
        if (d.isInstantiated()) {
            return new Task(s, d, ((Model)this.ref()).offset(s, d.getValue()));
        }
        int[] bounds = VariableUtils.boundsForAddition(s, d);
        IntVar end = ((Model)this.ref()).intVar(bounds[0], bounds[1]);
        return new Task(s, d, end);
    }

    default public Task taskVar(IntVar s, int d, IntVar e) {
        return new Task(s, d, e);
    }

    default public Task taskVar(IntVar s, IntVar d, IntVar e) {
        return new Task(s, d, e);
    }

    default public Task[] taskVarArray(IntVar[] s, IntVar[] p, IntVar[] e) {
        if (s.length != p.length || s.length != e.length) {
            throw new SolverException("Wrong arrays size");
        }
        Task[] tasks = new Task[s.length];
        for (int i = 0; i < s.length; ++i) {
            tasks[i] = this.taskVar(s[i], p[i], e[i]);
        }
        return tasks;
    }

    default public Task[][] taskVarMatrix(IntVar[][] s, IntVar[][] p, IntVar[][] e) {
        if (s.length != p.length || s.length != e.length) {
            throw new SolverException("Wrong arrays size");
        }
        Task[][] tasks = new Task[s.length][];
        for (int i = 0; i < s.length; ++i) {
            tasks[i] = this.taskVarArray(s[i], p[i], e[i]);
        }
        return tasks;
    }

    default public RealVar realVar(double value) {
        return this.realVar(CSTE_NAME + value, value);
    }

    default public RealVar realVar(String name, double value) {
        return new FixedRealVarImpl(name, value, (Model)this.ref());
    }

    default public RealVar realVar(double value, double precision) {
        return this.realVar(CSTE_NAME + value, value, value, precision);
    }

    default public RealVar realVar(double lb, double ub, double precision) {
        return this.realVar(this.generateName("RV_"), lb, ub, precision);
    }

    default public RealVar realVar(String name, double lb, double ub, double precision) {
        this.checkRealDomainRange(name, lb, ub);
        return new RealVarImpl(name, lb, ub, precision, (Model)this.ref());
    }

    default public RealVar[] realVarArray(int size, double lb, double ub, double precision) {
        return this.realVarArray(this.generateName("RV_"), size, lb, ub, precision);
    }

    default public RealVar[] realVarArray(String name, int size, double lb, double ub, double precision) {
        RealVar[] vars = new RealVar[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.realVar(name + "[" + i + "]", lb, ub, precision);
        }
        return vars;
    }

    default public RealVar[][] realVarMatrix(int dim1, int dim2, double lb, double ub, double precision) {
        return this.realVarMatrix(this.generateName("RV_"), dim1, dim2, lb, ub, precision);
    }

    default public RealVar[][] realVarMatrix(String name, int dim1, int dim2, double lb, double ub, double precision) {
        RealVar[][] vars = new RealVar[dim1][];
        for (int i = 0; i < dim1; ++i) {
            vars[i] = this.realVarArray(name + "[" + i + "]", dim2, lb, ub, precision);
        }
        return vars;
    }

    default public SetVar setVar(int[] lb, int[] ub) {
        return this.setVar(this.generateName("RV_"), lb, ub);
    }

    default public SetVar setVar(int ... value) {
        StringBuilder name = new StringBuilder("cste -- {");
        for (int i = 0; i < value.length; ++i) {
            name.append(value[i]).append(i < value.length - 1 ? ", " : "");
        }
        name.append("}");
        return this.setVar(name.toString(), value);
    }

    default public SetVar setVar(String name, int[] lb, int[] ub) {
        return new SetVarImpl(name, lb, SetType.BITSET, ub, SetType.BITSET, (Model)this.ref());
    }

    default public SetVar setVar(String name, int ... value) {
        if (value == null) {
            value = new int[]{};
        }
        return new SetVarImpl(name, value, (Model)this.ref());
    }

    default public SetVar[] setVarArray(int size, int[] lb, int[] ub) {
        return this.setVarArray(this.generateName("SV_"), size, lb, ub);
    }

    default public SetVar[] setVarArray(String name, int size, int[] lb, int[] ub) {
        SetVar[] vars = new SetVar[size];
        for (int i = 0; i < size; ++i) {
            vars[i] = this.setVar(name + "[" + i + "]", lb, ub);
        }
        return vars;
    }

    default public SetVar[][] setVarMatrix(int dim1, int dim2, int[] lb, int[] ub) {
        return this.setVarMatrix(this.generateName("SV_"), dim1, dim2, lb, ub);
    }

    default public SetVar[][] setVarMatrix(String name, int dim1, int dim2, int[] lb, int[] ub) {
        SetVar[][] vars = new SetVar[dim1][dim2];
        for (int i = 0; i < dim1; ++i) {
            vars[i] = this.setVarArray(name + "[" + i + "]", dim2, lb, ub);
        }
        return vars;
    }

    default public UndirectedGraphVar graphVar(String name, UndirectedGraph LB, UndirectedGraph UB) {
        return new UndirectedGraphVarImpl(name, (Model)this.ref(), LB, UB);
    }

    default public UndirectedNodeInducedGraphVarImpl nodeInducedGraphVar(String name, UndirectedGraph LB, UndirectedGraph UB) {
        return new UndirectedNodeInducedGraphVarImpl(name, (Model)this.ref(), LB, UB);
    }

    default public DirectedGraphVar digraphVar(String name, DirectedGraph LB, DirectedGraph UB) {
        return new DirectedGraphVarImpl(name, (Model)this.ref(), LB, UB);
    }

    default public DirectedNodeInducedGraphVarImpl nodeInducedDigraphVar(String name, DirectedGraph LB, DirectedGraph UB) {
        return new DirectedNodeInducedGraphVarImpl(name, (Model)this.ref(), LB, UB);
    }

    default public void checkIntDomainRange(String NAME, int MIN, int MAX) {
        if (MIN <= Integer.MIN_VALUE || MAX >= Integer.MAX_VALUE) {
            throw new SolverException(NAME + ": consider reducing the bounds to avoid unexpected results");
        }
        if (MAX < MIN) {
            throw new SolverException(NAME + ": wrong domain definition, lower bound > upper bound");
        }
        if ((long)MAX - (long)MIN > Integer.MAX_VALUE) {
            throw new SolverException(NAME + ": too large domain, consider reducing the bounds to avoid unexpected results");
        }
    }

    default public void checkRealDomainRange(String NAME, double MIN, double MAX) {
        if (MAX < MIN) {
            throw new SolverException(NAME + ": wrong domain definition, lower bound > upper bound");
        }
    }

    default public BoolVar[] toBoolVar(IntVar ... ivars) {
        BoolVar[] bvars = new BoolVar[ivars.length];
        for (int i = ivars.length - 1; i >= 0; --i) {
            bvars[i] = (BoolVar)ivars[i];
        }
        return bvars;
    }

    default public String generateName() {
        return this.generateName(DEFAULT_PREFIX);
    }

    default public String generateName(String prefix) {
        return prefix + ((Model)this.ref()).nextNameId();
    }
}

