/*
 * Scagnostics
 *
 * Leland Wilkinson and Anushka Anand (University of Illinois at Chicago)
 * This program accompanies the following paper:
 
 * Wilkinson L., Anand, A., and Grossman, R. (2006). High-Dimensional visual analytics: 
 *   Interactive exploration guided by pairwise views of point distributions. 
 *   IEEE Transactions on Visualization and Computer Graphics, November/December 2006 (Vol. 12, No. 6) pp. 1363-1372.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose without fee is hereby granted, provided that this entire notice
 * is included in all copies of any software which is or includes a copy
 * or modification of this software.
 * Supporting documentation must also include a citation of
 * the abovementioned article.
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY.  IN PARTICULAR, THE AUTHORS MAKE NO
 * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
 * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */
package scagnostics;

public class BinnedData {
    private int[] x = null;
    private int[] y = null;
    private int[] counts = null;

    private static final double RESOLUTION = 1000;

    public BinnedData(double[] x, double[] y, int[] counts) {
        this.x = integerizeData(x);
        this.y = integerizeData(y);
        this.counts = counts;
    }

    private int[] integerizeData(double[] x) {
        int n = x.length;
        int[] xd = new int[n];
        for (int i = 0; i < n; i++) {
            xd[i] = (int) (RESOLUTION * x[i]);
        }
        return xd;
    }

    protected int[] getXData() {
        return x;
    }

    protected int[] getYData() {
        return y;
    }

    protected int[] getCounts() {
        return counts;
    }
}