/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1;

import eu.kliegr.ac1.BaseConfig;
import eu.kliegr.ac1.data.AttributeType;
import eu.kliegr.ac1.rule.PruneType;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Logger;

public class PruneConfig
extends BaseConfig {
    private static final Logger LOGGER = Logger.getLogger(PruneConfig.class.getName());
    private String rulesPath = "/home/tomas/NetBeansProjects/AC1/resources/Iris1_iris_1_0.5.xml";
    private String pruneRuleSortComparator = "CBARuleComparator";
    private PruneType pruningType = PruneType.wholeRule;
    private final Comparator ruleComparator;

    public PruneConfig(String path) throws FileNotFoundException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(path));
        Properties prop = new Properties();
        prop.loadFromXML(input);
        this.rulesPath = prop.getProperty("RulesPath");
        this.dataPath = prop.getProperty("TrainDataPath");
        this.setOutputPath(prop.getProperty("OutputPath"));
        this.pruneRuleSortComparator = prop.getProperty("PruneRuleSortComparator");
        this.ruleComparator = (Comparator)Class.forName("eu.kliegr.ac1.rule." + this.pruneRuleSortComparator).newInstance();
        this.pruningType = PruneType.valueOf(prop.getProperty("PruningType"));
        this.csvSeparator = prop.getProperty("DataTypes").contains(";") ? ";" : ",";
        this.attType = this.parseAttributeTypes(prop.getProperty("DataTypes").split(this.csvSeparator));
        this.targetAttribute = prop.getProperty("TargetAttribute");
        this.IDcolumnName = prop.getProperty("IDcolumnName");
    }

    public Comparator getRuleComparator() {
        return this.ruleComparator;
    }

    public String getRulesPath() {
        return this.rulesPath;
    }

    public ArrayList<AttributeType> attributeTypes() {
        return this.attType;
    }

    public String getOutputSummaryPath() {
        return this.getOutputPath("summary");
    }

    public PruneType getPruningType() {
        return this.pruningType;
    }
}

