/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.stml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.Util;
import org.xmlcml.stml.AbstractSTMTool;
import org.xmlcml.stml.STMLArray;
import org.xmlcml.stml.STMLAttribute;
import org.xmlcml.stml.STMLScalar;
import org.xmlcml.stml.attribute.AttributeFactory;
import org.xmlcml.stml.attribute.DelimiterAttribute;
import org.xmlcml.stml.attribute.DictRefAttribute;
import org.xmlcml.stml.attribute.DoubleSTAttribute;
import org.xmlcml.stml.attribute.IdAttribute;
import org.xmlcml.stml.attribute.IntSTAttribute;
import org.xmlcml.stml.attribute.StringSTAttribute;
import org.xmlcml.stml.attribute.UnitsAttribute;
import org.xmlcml.xml.XMLConstants;
import org.xmlcml.xml.XMLUtil;

public class STMLElement
extends Element
implements XMLConstants {
    private static final Logger LOG = Logger.getLogger(STMLElement.class);
    static final String ID = "id";
    private AbstractSTMTool tool;
    DoubleSTAttribute _att_constanttosi = null;
    StringSTAttribute _att_datatype = null;
    DelimiterAttribute _att_delimiter = null;
    DictRefAttribute _att_dictref = null;
    IdAttribute _att_id = null;
    IntSTAttribute _att_size = null;
    UnitsAttribute _att_units = null;
    protected static AttributeFactory attributeFactory = AttributeFactory.attributeFactory;

    protected STMLElement() {
        super("element");
        this.init();
    }

    public STMLElement(String name) {
        super(name, "http://www.xml-cml.org/schema");
        this.init();
    }

    public static STMLElement readAndCreateSTML(Element element) {
        STMLElement newElement = null;
        String tag = element.getLocalName();
        if (tag == null || tag.equals("")) {
            throw new RuntimeException("no tag");
        }
        if (tag.equals("array")) {
            newElement = new STMLArray();
        } else if (tag.equals("scalar")) {
            newElement = new STMLScalar();
        } else {
            System.err.println("unsupported cml element: " + tag);
        }
        if (newElement != null) {
            XMLUtil.copyAttributesFromTo(element, newElement);
            STMLElement.createSubclassedChildren(element, newElement);
        }
        return newElement;
    }

    public static STMLElement readAndCreateSTML(File file) {
        Element element = XMLUtil.parseQuietlyToDocument(file).getRootElement();
        return element == null ? null : STMLElement.readAndCreateSTML(element);
    }

    public static STMLElement readAndCreateSTML(InputStream is) {
        Element element = XMLUtil.parseQuietlyToDocument(is).getRootElement();
        return element == null ? null : STMLElement.readAndCreateSTML(element);
    }

    protected static void createSubclassedChildren(Element oldElement, STMLElement newElement) {
        if (oldElement != null) {
            for (int i = 0; i < oldElement.getChildCount(); ++i) {
                Node node = oldElement.getChild(i);
                Object newNode = null;
                if (node instanceof Text) {
                    String value = node.getValue();
                    newNode = new Text(value);
                } else if (node instanceof Comment) {
                    newNode = new Comment(node.getValue());
                } else if (node instanceof ProcessingInstruction) {
                    newNode = new ProcessingInstruction((ProcessingInstruction)node);
                } else if (node instanceof Element) {
                    newNode = STMLElement.readAndCreateSTML((Element)node);
                } else {
                    throw new RuntimeException("Cannot create new node: " + node.getClass());
                }
                newElement.appendChild((Node)newNode);
            }
        }
    }

    private void init() {
    }

    public STMLElement(STMLElement element) {
        this(element.getLocalName());
        this.copyAttributesFrom(element);
        this.copyChildrenFrom(element);
    }

    public Element copy() {
        return new STMLElement(this);
    }

    public void copyAttributesFrom(Element element) {
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            Attribute att = element.getAttribute(i);
            Attribute newAtt = att.copy();
            this.addAttribute(newAtt);
        }
    }

    public void copyChildrenFrom(Element element) {
        for (int i = 0; i < element.getChildCount(); ++i) {
            Node childNode = element.getChild(i);
            Node newNode = childNode.copy();
            this.appendChild(newNode);
        }
    }

    public static void copyChildrenFromTo(Element element, Element to) {
        for (int i = 0; i < element.getChildCount(); ++i) {
            Node childNode = element.getChild(i);
            Node newNode = childNode.copy();
            to.appendChild(newNode);
        }
    }

    public void replaceChild(Node oldNode, Node newNode) {
        int pos = this.indexOf(oldNode);
        if (pos == -1) {
            throw new RuntimeException("Cannot replace non-child");
        }
        newNode.detach();
        this.removeChild(oldNode);
        this.insertChild(newNode, pos);
    }

    public void insertChild(Node newNode, int pos) {
        newNode.detach();
        super.insertChild(newNode, pos);
    }

    public void detach() {
        ParentNode parent = this.getParent();
        if (parent != null) {
            if (parent instanceof Document) {
                parent.replaceChild((Node)this, (Node)new Element("dummy"));
            } else {
                parent.removeChild((Node)this);
            }
        }
    }

    public void setLocalName(String localName) {
        String lName = this.getLocalName();
        if (lName == null) {
            super.setLocalName(localName);
        }
    }

    protected void unknownAttributeName(String name) {
        throw new RuntimeException("Unknown STML attribute " + name + " on " + this.getLocalName());
    }

    protected String getSTMLAttributeValue(String name) {
        STMLAttribute a = (STMLAttribute)this.getAttribute(name);
        return a == null ? null : (String)a.getSTMLValue();
    }

    public void removeAttribute(String attName) {
        Attribute att = this.getAttribute(attName);
        if (att != null) {
            this.removeAttribute(att);
        }
    }

    public static void copyAttributesFromTo(Element from, Element to) {
        for (int i = 0; i < from.getAttributeCount(); ++i) {
            Attribute att = from.getAttribute(i);
            STMLAttribute newAtt = att instanceof STMLAttribute ? new STMLAttribute((STMLAttribute)att) : new Attribute(att);
            to.addAttribute((Attribute)newAtt);
        }
    }

    public static void deleteAttribute(Element element, String attName) {
        Attribute att = element.getAttribute(attName);
        if (att != null) {
            att.detach();
        }
    }

    public void debug(String message) {
        Util.println("<<<<<<" + message + "<<<<<<");
        this.debug();
        Util.println(">>>>>>" + message + ">>>>>>");
    }

    public void debug() {
        try {
            this.debug(System.out, 2);
        }
        catch (IOException e) {
            Util.BUG(e);
        }
    }

    public void debug(int indent) {
        try {
            this.debug(System.out, indent);
        }
        catch (IOException e) {
            Util.BUG(e);
        }
    }

    public void debug(OutputStream os, int indent) throws IOException {
        Document document;
        ParentNode parent = this.getParent();
        if (parent instanceof Document) {
            document = (Document)parent;
        } else {
            STMLElement copyElem = new STMLElement(this);
            document = new Document((Element)copyElem);
        }
        Serializer serializer = new Serializer(os);
        serializer.setIndent(indent);
        serializer.write(document);
    }

    public String getStringContent() {
        Node child = this.getChildCount() == 0 ? null : this.getChild(0);
        String s = child == null || !(child instanceof Text) ? null : child.getValue();
        return s;
    }

    public void setStringContent(String value) {
        Text newText = new Text(value);
        if (this.getChildCount() == 0) {
            this.appendChild((Node)newText);
        } else {
            Node child = this.getChild(0);
            if (child instanceof Text) {
                this.replaceChild(child, (Node)newText);
            }
        }
    }

    public void writeHTML(Writer w) throws IOException {
        w.write("<span class='" + this.getLocalName() + "'>");
        w.write(this.getLocalName());
        w.write("</span>");
    }

    public void serialize(OutputStream os, int indent) throws IOException {
        Document doc = new Document((Element)((STMLElement)this.copy()));
        Serializer serializer = new Serializer(os);
        serializer.write(doc);
    }

    public void setSTMLXAttribute(String attName, String attValue) {
        if (attValue == null) {
            Attribute attribute = this.getAttribute(attName, "http://www.xml-cml.org/schema/cmlx");
            if (attribute != null) {
                this.removeAttribute(attribute);
            }
        } else {
            STMLElement.addSTMLXAttribute(this, attName, attValue);
        }
    }

    public static void addSTMLXAttribute(Element element, String attName, String attValue) {
        Attribute attribute = STMLElement.makeSTMLXAttribute(attName, attValue);
        element.addAttribute(attribute);
        element.addNamespaceDeclaration("cmlx", "http://www.xml-cml.org/schema/cmlx");
    }

    public static Attribute makeSTMLXAttribute(String attName, String value) {
        return new Attribute("cmlx:" + attName, "http://www.xml-cml.org/schema/cmlx", value);
    }

    public String getSTMLXAttribute(String attName) {
        String value = null;
        Attribute attribute = this.getAttribute(attName, "http://www.xml-cml.org/schema/cmlx");
        if (attribute != null) {
            value = attribute.getValue();
        }
        return value;
    }

    public void appendChild(Node child) {
        child.detach();
        int childCount = this.getChildCount();
        this.insertChild(child, childCount);
    }

    public AbstractSTMTool getTool() {
        return this.tool;
    }

    public void setTool(AbstractSTMTool tool) {
        this.tool = tool;
    }

    public void setDataType(String type) {
    }

    public String getNamespaceURIForPrefix(String prefix) {
        ParentNode parent;
        String namespace = null;
        STMLElement current = this;
        while ((namespace = current.getNamespaceURI(prefix)) == null && (parent = current.getParent()) != null && !(parent instanceof Document)) {
            current = (Element)parent;
        }
        return namespace;
    }

    public String getDataType() {
        StringSTAttribute att = (StringSTAttribute)this.getDataTypeAttribute();
        if (att == null) {
            return null;
        }
        return att.getString();
    }

    public STMLAttribute getDataTypeAttribute() {
        return (STMLAttribute)this.getAttribute("dataType");
    }

    public String getDelimiter() {
        DelimiterAttribute att = (DelimiterAttribute)this.getDelimiterAttribute();
        if (att == null) {
            return null;
        }
        return att.getString();
    }

    public STMLAttribute getDelimiterAttribute() {
        return (STMLAttribute)this.getAttribute("delimiter");
    }

    public String getDictRef() {
        DictRefAttribute att = (DictRefAttribute)this.getDictRefAttribute();
        if (att == null) {
            return null;
        }
        return att.getString();
    }

    public void setDictRef(String value) throws RuntimeException {
        DictRefAttribute att = null;
        this._att_dictref = (DictRefAttribute)attributeFactory.getAttribute("dictRef", "scalar");
        att = new DictRefAttribute((Attribute)this._att_dictref);
        this.addRemove(att, value);
    }

    public STMLAttribute getDictRefAttribute() {
        return (STMLAttribute)this.getAttribute("dictRef");
    }

    protected void addRemove(STMLAttribute att, String value) {
        if (value == null || value.equals("")) {
            this.removeAttribute(att.getLocalName());
        } else if (att != null) {
            att.setSTMLValue(value);
            super.addAttribute((Attribute)att);
        }
    }

    public double getConstantToSI() {
        DoubleSTAttribute att = (DoubleSTAttribute)this.getConstantToSIAttribute();
        if (att == null) {
            return Double.NaN;
        }
        return att.getDouble();
    }

    public STMLAttribute getConstantToSIAttribute() {
        return (STMLAttribute)this.getAttribute("constantToSI");
    }

    public String getConvention() {
        StringSTAttribute att = (StringSTAttribute)this.getConventionAttribute();
        if (att == null) {
            return null;
        }
        return att.getString();
    }

    public STMLAttribute getConventionAttribute() {
        return (STMLAttribute)this.getAttribute("convention");
    }

    public String getId() {
        IdAttribute att = (IdAttribute)this.getIdAttribute();
        if (att == null) {
            return null;
        }
        return att.getString();
    }

    public STMLAttribute getIdAttribute() {
        return (STMLAttribute)this.getAttribute(ID);
    }

    public String getUnits() {
        UnitsAttribute att = (UnitsAttribute)this.getUnitsAttribute();
        if (att == null) {
            return null;
        }
        return att.getString();
    }

    public STMLAttribute getUnitsAttribute() {
        return (STMLAttribute)this.getAttribute("units");
    }

    public int getSize() {
        IntSTAttribute att = (IntSTAttribute)this.getSizeAttribute();
        if (att == null) {
            throw new RuntimeException("int attribute is unset: size");
        }
        return att.getInt();
    }

    public STMLAttribute getSizeAttribute() {
        return (STMLAttribute)this.getAttribute("size");
    }

    public void setDelimiter(String value) throws RuntimeException {
        DelimiterAttribute att = null;
        if (this._att_delimiter == null) {
            this._att_delimiter = (DelimiterAttribute)attributeFactory.getAttribute("delimiter", "array");
            if (this._att_delimiter == null) {
                throw new RuntimeException("BUG: cannot process attributeGroupName : delimiter probably incompatible attributeGroupName and attributeName");
            }
        }
        att = new DelimiterAttribute((Attribute)this._att_delimiter);
        this.addRemove(att, value);
    }

    public void setSize(int value) throws RuntimeException {
        if (this._att_size == null) {
            this._att_size = (IntSTAttribute)attributeFactory.getAttribute("size", "array");
            if (this._att_size == null) {
                throw new RuntimeException("BUG: cannot process attributeGroupName : size probably incompatible attributeGroupName and attributeName ");
            }
        }
        IntSTAttribute att = new IntSTAttribute(this._att_size);
        super.addAttribute((Attribute)att);
        att.setSTMLValue(value);
    }

    public void setSize(String value) throws RuntimeException {
        IntSTAttribute att = null;
        if (this._att_size == null) {
            this._att_size = (IntSTAttribute)attributeFactory.getAttribute("size", "array");
            if (this._att_size == null) {
                throw new RuntimeException("BUG: cannot process attributeGroupName : size probably incompatible attributeGroupName and attributeName");
            }
        }
        att = new IntSTAttribute(this._att_size);
        this.addRemove(att, value);
    }

    public void setXMLContent(String value) throws RuntimeException {
        this.removeChildren();
        this.appendChild(value);
    }

    public String getXMLContent() {
        String content = this.getValue();
        return content;
    }
}

