/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.AbstractGenerator;
import org.xmlcml.cml.base.CMLType;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.base.SchemaManager;

public class TypeGenerator
extends AbstractGenerator {
    private static Logger LOG = Logger.getLogger(TypeGenerator.class);
    Map<String, CMLType> map;

    public TypeGenerator(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.init();
    }

    private void init() {
        this.map = new HashMap<String, CMLType>();
        this.nameList = new ArrayList();
    }

    void addXSDTypes() {
        CMLType type = new CMLType();
        type.setName("xsd:string");
        type.setJavaType("xsd:string");
        this.map.put("xsd:string", type);
        type = new CMLType();
        type.setName("xsd:QName");
        type.setJavaType("xsd:string");
        type.setPattern("[A-Za-z_][A-Za-z0-9_-\\.]*:[A-Za-z_][A-Za-z0-9_-\\.]*");
        this.map.put("xsd:QName", type);
        type = new CMLType();
        type.setName("xsd:anyURI");
        type.setJavaType("xsd:string");
        type.setPattern("http://.*");
        this.map.put("xsd:anyURI", type);
        type = new CMLType();
        type.setName("xsd:double");
        type.setJavaType("xsd:double");
        this.map.put("xsd:double", type);
        type = new CMLType();
        type.setName("xsd:float");
        type.setJavaType("xsd:double");
        this.map.put("xsd:float", type);
        type = new CMLType();
        type.setName("xsd:integer");
        type.setJavaType("xsd:integer");
        this.map.put("xsd:integer", type);
        type = new CMLType();
        type.setName("xsd:nonNegativeInteger");
        type.setJavaType("xsd:integer");
        type.setMinInclusive(0);
        this.map.put("xsd:nonNegativeInteger", type);
        type = new CMLType();
        type.setName("xsd:positiveInteger");
        type.setJavaType("xsd:integer");
        type.setMinInclusive(1);
        this.map.put("xsd:positiveInteger", type);
        type = new CMLType();
        type.setName("xsd:boolean");
        type.setJavaType("xsd:boolean");
        this.map.put("xsd:boolean", type);
        type = new CMLType();
        type.setName("xsd:positiveInteger");
        type.setJavaType("xsd:integer");
        type.setMinInclusive(1);
        this.map.put("xsd:positiveInteger", type);
    }

    private boolean processJavaTypes() {
        boolean change = false;
        for (String name : this.nameList) {
            String base;
            CMLType type = this.map.get(name);
            String javaType = type.getJavaType();
            if (javaType != null || (base = type.getBase()) == null) continue;
            CMLType baseType = this.map.get(base);
            if (baseType == null) {
                throw new RuntimeException("cannot find base type: " + base);
            }
            String baseJavaType = baseType.getJavaType();
            if (baseJavaType == null) continue;
            type.setJavaType(baseJavaType);
            change = true;
        }
        return change;
    }

    private boolean checkJavaTypes() {
        boolean ok = true;
        for (String name : this.nameList) {
            CMLType type = this.map.get(name);
            String javaType = type.getJavaType();
            String base = type.getBase();
            if (javaType != null || base == null) continue;
            ok = false;
            System.err.println("no javaType for " + base);
        }
        return ok;
    }

    public Map<String, CMLType> getMap() {
        return this.map;
    }

    public void setMap(Map<String, CMLType> map) {
        this.map = map;
    }

    public void readAssembleAndIndexSchema(String indir) throws Exception {
        this.readAndAssembleSchemaComponents(indir);
        this.indexSchema();
    }

    public void indexSchema() {
        List<Node> simpleTypes = CMLUtil.getQueryNodes((Node)this.schema, "./xsd:simpleType", XPATH_XSD);
        this.addXSDTypes();
        for (Node node : simpleTypes) {
            Element simpleTypeElement = (Element)node;
            String name = simpleTypeElement.getAttributeValue("name");
            if (name == null) {
                System.err.println("No name attribute on simpleType");
                CMLUtil.debug(simpleTypeElement, "TYPEGEN");
                continue;
            }
            try {
                CMLType type = new CMLType(simpleTypeElement);
                this.map.put(name, type);
                this.nameList.add(name);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot create " + name + "..." + e));
            }
        }
        boolean change = true;
        while (change && (change = this.processJavaTypes())) {
        }
        if (!this.checkJavaTypes()) {
            throw new RuntimeException("unresolved javaTypes");
        }
        for (String name : this.nameList) {
            CMLType type = this.map.get(name);
            type.createMinMaxAndEnumerations();
        }
    }
}

