/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;

public class AtomicProperties {
    private static AtomicProperties ap = null;
    private final Map<String, Double> htMass = new Hashtable<String, Double>();
    private final Map<String, Double> htVdWVolume = new Hashtable<String, Double>();
    private final Map<String, Double> htElectronegativity = new Hashtable<String, Double>();
    private final Map<String, Double> htPolarizability = new Hashtable<String, Double>();

    private AtomicProperties() throws IOException {
        String Line;
        String configFile = "org/openscience/cdk/config/data/whim_weights.txt";
        InputStream ins = this.getClass().getClassLoader().getResourceAsStream(configFile);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ins));
        String header = bufferedReader.readLine();
        if (header == null) {
            throw new IOException("Expected header, but reached end of input");
        }
        while ((Line = bufferedReader.readLine()) != null) {
            String[] components = Line.split("\t");
            String symbol = components[0];
            this.htMass.put(symbol, Double.parseDouble(components[1]));
            this.htVdWVolume.put(symbol, Double.parseDouble(components[2]));
            this.htElectronegativity.put(symbol, Double.parseDouble(components[3]));
            this.htPolarizability.put(symbol, Double.parseDouble(components[4]));
        }
        bufferedReader.close();
    }

    public double getVdWVolume(String symbol) {
        return this.htVdWVolume.get(symbol);
    }

    public double getNormalizedVdWVolume(String symbol) {
        return this.getVdWVolume(symbol) / this.getVdWVolume("C");
    }

    public double getElectronegativity(String symbol) {
        return this.htElectronegativity.get(symbol);
    }

    public double getNormalizedElectronegativity(String symbol) {
        return this.getElectronegativity(symbol) / this.getElectronegativity("C");
    }

    public double getPolarizability(String symbol) {
        return this.htPolarizability.get(symbol);
    }

    public double getNormalizedPolarizability(String symbol) {
        return this.getPolarizability(symbol) / this.getPolarizability("C");
    }

    public double getMass(String symbol) {
        return this.htMass.get(symbol);
    }

    public double getNormalizedMass(String symbol) {
        return this.getMass(symbol) / this.getMass("C");
    }

    public static AtomicProperties getInstance() throws IOException {
        if (ap == null) {
            ap = new AtomicProperties();
        }
        return ap;
    }
}

