/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.attribute;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import org.xmlcml.cml.base.StringSTAttribute;

public class CountExpressionAttributeAdapter
extends StringSTAttribute {
    public CountExpressionAttributeAdapter(Attribute att) throws RuntimeException {
        super(att);
    }

    @Override
    public void setCMLValue(String value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null CountExpressionAttribute value");
        }
        if (!value.trim().equals("")) {
            super.setCMLValue(value);
        }
    }

    public int calculateCountExpression() {
        int count = 1;
        String countEx = this.getValue();
        if (countEx != null) {
            if (countEx.startsWith("gaussian")) {
                int[] counts = this.parseCount(countEx = countEx.substring("gaussian".length()));
                if (counts.length != 2 || counts[0] <= 3 || counts[1] < 1 || counts[0] / counts[1] < 3) {
                    throw new RuntimeException("Bad gaussian: " + countEx);
                }
                throw new RuntimeException("gaussian NYI");
            }
            if (countEx.startsWith("range")) {
                int[] counts = this.parseCount(countEx = countEx.substring("range".length()));
                if (counts.length != 2 || counts[0] < 0 || counts[0] >= counts[1]) {
                    throw new RuntimeException("Bad range: " + countEx);
                }
                double mid2 = (double)(counts[1] + counts[0]) / 2.0;
                double delta2 = (double)(counts[1] - counts[0]) / 2.0;
                double dd = mid2 + delta2 * (0.5 - Math.random());
                count = (int)Math.round(dd);
            } else if (countEx.startsWith("*")) {
                int[] counts = this.parseCount(countEx = countEx.substring("*".length()));
                if (counts.length != 1) {
                    throw new RuntimeException("Bad range: " + countEx);
                }
                count = counts[0];
            } else {
                throw new RuntimeException("Bad count expression: " + countEx);
            }
        }
        return count;
    }

    private int[] parseCount(String countEx) {
        if (!countEx.startsWith("(") || !countEx.endsWith(")")) {
            throw new RuntimeException("Bad range: requires (d,d): " + countEx);
        }
        countEx = countEx.substring(1, countEx.length() - 1).trim();
        String[] countStrings = countEx.split(",");
        int[] counts = new int[countStrings.length];
        for (int i = 0; i < countStrings.length; ++i) {
            try {
                counts[i] = Integer.parseInt(countStrings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Bad integer in countExpression :" + countStrings[i]);
            }
        }
        return counts;
    }

    public int[] getRange() {
        String countExpression = this.getValue();
        String regex = "(?<=range\\()\\d+,\\d+(?=\\))";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(countExpression);
        if (matcher.find()) {
            String match = matcher.group();
            String[] values = match.split(",");
            if (values.length != 2) {
                throw new RuntimeException();
            }
            int[] range = new int[]{Integer.parseInt(values[0]), Integer.parseInt(values[1])};
            return range;
        }
        return null;
    }
}

