/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.attribute;

import nu.xom.Attribute;
import org.xmlcml.cml.base.StringSTAttribute;
import org.xmlcml.euclid.Util;

public class DelimiterAttribute
extends StringSTAttribute {
    public static final String NAME = "delimiter";
    private String splitter = null;
    private String concat = null;

    public DelimiterAttribute() {
        super(NAME);
    }

    public DelimiterAttribute(String value) {
        super(NAME);
        this.setCMLValue(value);
    }

    public DelimiterAttribute(Attribute att) throws RuntimeException {
        super(att);
        this.setCMLValue(att.getValue());
    }

    @Override
    public void setCMLValue(String value) throws RuntimeException {
        if (value == null) {
            value = " ";
        }
        if ((value = value.trim()).equals("")) {
            value = " ";
        } else if (value.length() > 1) {
            throw new RuntimeException("Non-whitespace delimiter must only be single character");
        }
        super.setCMLValue(value);
        if (value.equals(" ")) {
            this.setSplitter("\\s+");
            this.setConcat(" ");
        } else {
            this.setSplitter(DelimiterAttribute.getEscapedDelimiter(value));
            this.setConcat(value);
        }
    }

    public String getConcat() {
        return this.concat;
    }

    public void setConcat(String concat) {
        this.concat = concat;
    }

    public String getSplitter() {
        return this.splitter;
    }

    public void setSplitter(String splitter) {
        this.splitter = splitter;
    }

    private static String getEscapedDelimiter(String delim) {
        String delim1 = delim;
        if (delim.length() == 1 && (delim.equals("|") || delim.equals("?") || delim.equals("*") || delim.equals("."))) {
            delim1 = "\\" + delim;
        }
        return delim1;
    }

    public String[] getSplitContent(String content) {
        String[] ss = new String[]{};
        if ((content = content.trim()).length() > 0) {
            if (!this.isWhitespace()) {
                if (content.startsWith(this.concat)) {
                    content = content.substring(1);
                }
                if (content.endsWith(this.concat)) {
                    content = content.substring(0, content.length() - this.concat.length());
                }
            }
            ss = content.split(this.splitter);
        }
        return ss;
    }

    public void checkDelimiter(String s) throws RuntimeException {
        if (s.split(this.splitter).length > 1) {
            throw new RuntimeException("cannot delimit {" + s + "} with {" + this.concat + "}");
        }
    }

    public String getDelimitedXMLContent(String s) {
        if (s == null) {
            s = "";
        }
        if (!s.equals("") && !this.isWhitespace()) {
            if (!s.startsWith(this.concat)) {
                s = this.concat + s;
            }
            if (!s.endsWith(this.concat)) {
                s = s + this.concat;
            }
        }
        return s;
    }

    public String appendXMLContent(String s, String snew) {
        s = this.getDelimitedXMLContent(s);
        s = !this.isWhitespace() ? (s.length() == 0 ? this.concat + snew + this.concat : s + snew + this.concat) : s + this.concat + snew;
        return s;
    }

    private boolean isWhitespace() {
        return "\\s+".equals(this.splitter);
    }

    public String getDelimitedXMLContent(String[] ss) {
        for (String s : ss) {
            this.checkDelimiter(s);
        }
        String s = Util.concatenate((String[])ss, (String)this.concat);
        if (!this.isWhitespace()) {
            s = this.concat + s + this.concat;
        }
        return s;
    }

    public String getDelimitedXMLContent(boolean[] bb) {
        for (boolean b : bb) {
            this.checkDelimiter("" + b);
        }
        String s = Util.concatenate((boolean[])bb, (String)this.concat);
        if (!this.isWhitespace()) {
            s = this.concat + s + this.concat;
        }
        return s;
    }

    public String getDelimitedXMLContent(double[] dd) {
        for (double d : dd) {
            this.checkDelimiter("" + d);
        }
        String s = Util.concatenate((double[])dd, (String)this.concat);
        if (!this.isWhitespace()) {
            s = this.concat + s + this.concat;
        }
        return s;
    }

    public String getDelimitedXMLContent(int[] ii) {
        for (int i : ii) {
            this.checkDelimiter("" + i);
        }
        String s = Util.concatenate((int[])ii, (String)this.concat);
        if (!this.isWhitespace()) {
            s = this.concat + s + this.concat;
        }
        return s;
    }

    public void debug(String s) {
        Util.println((String)("-------- " + s + " -------"));
        Util.println((String)(this + " .. " + this.getValue() + " .. " + this.splitter + " .. " + this.concat));
    }

    public static enum Action {
        RESET,
        PRESERVE;

    }
}

