/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.ArrayBase;
import org.xmlcml.euclid.DoubleIterator;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.IntArray;
import org.xmlcml.euclid.IntSet;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.RealRange;
import org.xmlcml.euclid.Univariate;
import org.xmlcml.euclid.Util;

public class RealArray
extends ArrayBase
implements Iterable<Double> {
    static final Logger LOG = Logger.getLogger(RealArray.class);
    private int maxelem = 10000;
    private int nelem;
    private double[] array;
    private int bufsize = 5;
    private DecimalFormat format = null;
    private static final int CUTOFF = 16;
    private static final int XXCUTOFF = 16;

    public RealArray() {
        this.nelem = 0;
        this.bufsize = 5;
        this.array = new double[this.bufsize];
    }

    private boolean checkSize(int n) {
        if (n < 0) {
            n = 0;
            return false;
        }
        this.nelem = n;
        if (this.nelem > this.maxelem) {
            this.maxelem = this.nelem;
        }
        if (this.bufsize < this.nelem) {
            this.bufsize = this.nelem;
        }
        return true;
    }

    private void makeSpace(int newCount) {
        if (this.bufsize < 5) {
            this.bufsize = 5;
        }
        if (newCount >= this.bufsize || this.array.length < newCount) {
            while (newCount >= this.bufsize) {
                this.bufsize *= 2;
            }
            double[] array1 = new double[this.bufsize];
            System.arraycopy(this.array, 0, array1, 0, this.nelem);
            this.array = array1;
        }
    }

    public RealArray(int n) {
        this(n, 0.0);
    }

    public RealArray(int n, double elem1, double delta) {
        if (!this.checkSize(n)) {
            return;
        }
        this.array = new double[n];
        this.bufsize = n;
        double ff = elem1;
        for (int i = 0; i < n; ++i) {
            this.array[i] = ff;
            ff += delta;
        }
    }

    public RealArray(int n, double elem1) {
        if (!this.checkSize(n)) {
            return;
        }
        this.array = new double[n];
        this.bufsize = n;
        for (int i = 0; i < n; ++i) {
            this.array[i] = elem1;
        }
    }

    public RealArray(int n, double[] arr) throws EuclidRuntimeException {
        if (!this.checkSize(n)) {
            throw new EuclidRuntimeException("Cannot have negative array length");
        }
        if (n > arr.length) {
            throw new EuclidRuntimeException("Array size too small");
        }
        this.array = new double[n];
        this.bufsize = n;
        System.arraycopy(arr, 0, this.array, 0, n);
    }

    public RealArray(double[] arr) {
        this.setElements(arr);
    }

    public RealArray(IntArray ia) {
        if (!this.checkSize(ia.size())) {
            return;
        }
        this.array = new double[this.nelem];
        this.bufsize = this.nelem;
        for (int i = 0; i < this.nelem; ++i) {
            this.array[i] = ia.elementAt(i);
        }
    }

    public RealArray(RealArray m, int low, int high) throws EuclidRuntimeException {
        if (low < 0 || low > high || high >= m.size()) {
            throw new EuclidRuntimeException("index out of range " + low + "/" + high);
        }
        this.nelem = high - low + 1;
        this.checkSize(this.nelem);
        this.array = new double[this.nelem];
        this.bufsize = this.nelem;
        System.arraycopy(m.array, low, this.array, 0, this.nelem);
    }

    public RealArray(RealArray ref, IntArray sub) throws EuclidRuntimeException {
        this(sub.size());
        for (int i = 0; i < sub.size(); ++i) {
            int j = sub.elementAt(i);
            if (j < 0 || j >= ref.size()) {
                throw new EuclidRuntimeException("index out of range " + j);
            }
            this.setElementAt(i, ref.elementAt(j));
        }
    }

    public static RealArray getSymmetricalArray(double mid, int nsteps, double halfrange) {
        if (nsteps < 3 || nsteps % 2 != 1) {
            throw new EuclidRuntimeException("Number of steps must be positive odd number; was: " + nsteps);
        }
        int nhalfsteps = (nsteps - 1) / 2;
        double step = halfrange / (double)nhalfsteps;
        RealArray realArray = new RealArray(nsteps, mid - halfrange, step);
        return realArray;
    }

    public Object clone() {
        RealArray temp = new RealArray(this.nelem);
        temp.nelem = this.nelem;
        temp.maxelem = this.maxelem;
        System.arraycopy(this.array, 0, temp.array, 0, this.nelem);
        temp.bufsize = this.nelem;
        return temp;
    }

    public RealArray(RealArray m) {
        this.shallowCopy(m);
        System.arraycopy(m.array, 0, this.array, 0, this.nelem);
    }

    public RealArray(int nn, String shape, double maxval) {
        if (shape.toUpperCase().equals("TRIANGLE")) {
            this.nelem = nn * 2 - 1;
            if (!this.checkSize(this.nelem)) {
                return;
            }
            this.array = new double[this.nelem];
            double delta = maxval / (double)nn;
            for (int i = 0; i < nn; ++i) {
                this.array[i] = (double)(i + 1) * delta;
                this.array[this.nelem - i - 1] = this.array[i];
            }
        } else if (shape.toUpperCase().equals("ZIGZAG")) {
            this.nelem = nn * 4 - 1;
            if (!this.checkSize(this.nelem)) {
                return;
            }
            this.array = new double[this.nelem];
            double delta = maxval / (double)nn;
            for (int i = 0; i < nn; ++i) {
                this.array[i] = (double)(i + 1) * delta;
                this.array[2 * nn - i - 2] = this.array[i];
                this.array[2 * nn + i] = -this.array[i];
                this.array[this.nelem - i - 1] = -this.array[i];
            }
            this.array[2 * nn - 1] = 0.0;
        }
    }

    public RealArray(String[] strings) throws EuclidRuntimeException {
        this(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            try {
                this.array[i] = Real.parseDouble(strings[i]);
                continue;
            }
            catch (Exception e) {
                throw new EuclidRuntimeException("Bad array element at (" + i + ") :" + strings[i] + ":");
            }
        }
    }

    public static RealArray createRealArray(List<String> stringList) {
        RealArray realArray = null;
        if (stringList != null && stringList.size() > 0) {
            try {
                realArray = new RealArray(stringList.toArray(new String[0]));
            }
            catch (EuclidRuntimeException euclidRuntimeException) {
                // empty catch block
            }
        }
        return realArray;
    }

    public RealArray(String string) throws NumberFormatException {
        this(string.split("\\s+"));
    }

    public void setFormat(DecimalFormat f) {
        this.format = f;
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public void replaceNaN(double d) {
        for (int i = 0; i < this.nelem; ++i) {
            if (!Double.isNaN(this.array[i])) continue;
            this.array[i] = d;
        }
    }

    private void contractArray() {
        double[] array1 = new double[this.nelem];
        System.arraycopy(this.array, 0, array1, 0, this.nelem);
        this.array = array1;
    }

    void shallowCopy(RealArray m) {
        this.nelem = m.nelem;
        this.bufsize = m.bufsize;
        this.maxelem = m.maxelem;
        this.array = m.array;
    }

    public static RealArray getFilter(int halfWidth, Filter function) {
        int i;
        if (!(function.equals((Object)Filter.GAUSSIAN) || function.equals((Object)Filter.GAUSSIAN_FIRST_DERIVATIVE) || function.equals((Object)Filter.GAUSSIAN_SECOND_DERIVATIVE))) {
            return null;
        }
        if (halfWidth < 1) {
            halfWidth = 1;
        }
        double[] xar = new double[2 * halfWidth + 1];
        double limit = 7.0;
        double sum = 0.0;
        double x = 0.0;
        double y = 1.0;
        double dHalf = limit * 0.693 * 0.693 / (double)halfWidth;
        for (i = 0; i <= halfWidth; ++i) {
            if (function.equals((Object)Filter.GAUSSIAN)) {
                y = Math.exp(-x * x);
            }
            if (function.equals((Object)Filter.GAUSSIAN_FIRST_DERIVATIVE)) {
                y = -2.0 * x * Math.exp(-x * x);
            }
            if (function.equals((Object)Filter.GAUSSIAN_SECOND_DERIVATIVE)) {
                y = (4.0 * (x * x) - 2.0) * Math.exp(-x * x);
            }
            xar[halfWidth + i] = function.equals((Object)Filter.GAUSSIAN_FIRST_DERIVATIVE) ? -y : y;
            xar[halfWidth - i] = y;
            sum += i == 0 ? y : 2.0 * y;
            x += dHalf;
        }
        if (function.equals((Object)Filter.GAUSSIAN)) {
            i = 0;
            while (i < 2 * halfWidth + 1) {
                int n = i++;
                xar[n] = xar[n] / sum;
            }
        }
        RealArray r = new RealArray(xar);
        return r;
    }

    public RealArray getNormalDistribution(double sigma) {
        int nsteps = this.size();
        double norm = 1.0 / (sigma * Math.sqrt(Math.PI * 2));
        double scale = 1.0 / (2.0 * sigma * sigma);
        RealArray normal = new RealArray(this.size());
        double[] array = this.getArray();
        double mean = (array[0] + array[nsteps - 1]) / 2.0;
        for (int i = 0; i < nsteps; ++i) {
            double delta = array[i] - mean;
            normal.array[i] = norm * Math.exp(-delta * delta * scale);
        }
        return normal;
    }

    public double getRandomVariate(RealArray distribution, RealArray cumulativeDistribution) {
        if (cumulativeDistribution.size() == 0) {
            RealArray cumul = distribution.cumulativeSum();
            cumulativeDistribution.setElements(cumul.getArray());
        }
        double[] cArray = cumulativeDistribution.getArray();
        double range = cArray[cArray.length - 1] - cArray[0];
        double probe = cArray[0] + Math.random() * range;
        return this.lineSearch(probe, cumulativeDistribution);
    }

    public double lineSearch(double probe, RealArray distribution) {
        if (this.size() <= 1) {
            throw new EuclidRuntimeException("unfilled arrays in line search");
        }
        if (this.size() != distribution.size()) {
            throw new EuclidRuntimeException("unequal arrays in line search");
        }
        double[] distArray = distribution.getArray();
        int top = distArray.length - 1;
        int bottom = 0;
        boolean change = true;
        while (change && top - bottom > 1) {
            change = false;
            int mid = (top + bottom) / 2;
            if (distArray[mid] < probe) {
                bottom = mid;
                change = true;
                continue;
            }
            if (!(distArray[mid] > probe)) continue;
            top = mid;
            change = true;
        }
        double ratio = (probe - distArray[bottom]) / (distArray[top] - distArray[bottom]);
        double step = this.array[1] - this.array[0];
        return this.array[bottom] + step * ratio;
    }

    public double elementAt(int elem) throws ArrayIndexOutOfBoundsException {
        return this.array[elem];
    }

    public double get(int elem) throws ArrayIndexOutOfBoundsException {
        return this.array[elem];
    }

    public int size() {
        return this.nelem;
    }

    public double[] getArray() {
        if (this.nelem != this.array.length) {
            this.contractArray();
        }
        return this.array;
    }

    public void clearArray() {
        for (int i = 0; i < this.size(); ++i) {
            this.array[i] = 0.0;
        }
    }

    public double[] getReverseArray() {
        int count = this.size();
        double[] temp = new double[count];
        for (int i = 0; i < this.size(); ++i) {
            temp[i] = this.array[--count];
        }
        return temp;
    }

    private void checkConformable(RealArray m) throws EuclidRuntimeException {
        if (this.nelem != m.nelem) {
            throw new EuclidRuntimeException();
        }
    }

    public boolean isEqualTo(RealArray f) {
        return this.equals(f, Real.getEpsilon());
    }

    public boolean equals(RealArray f, double epsilon) {
        boolean equal = false;
        try {
            this.checkConformable(f);
            equal = true;
            for (int i = 0; i < this.nelem; ++i) {
                if (Real.isEqual(this.array[i], f.array[i], epsilon)) continue;
                equal = false;
                break;
            }
        }
        catch (Exception e) {
            equal = false;
        }
        return equal;
    }

    public RealArray plus(RealArray f) throws EuclidRuntimeException {
        this.checkConformable(f);
        RealArray m = (RealArray)this.clone();
        for (int i = 0; i < this.nelem; ++i) {
            m.array[i] = f.array[i] + this.array[i];
        }
        return m;
    }

    public void plusEquals(RealArray f) throws EuclidRuntimeException {
        this.checkConformable(f);
        for (int i = this.nelem - 1; i >= 0; --i) {
            int n = i;
            this.array[n] = this.array[n] + f.array[i];
        }
    }

    public RealArray subtract(RealArray f) throws EuclidRuntimeException {
        this.checkConformable(f);
        RealArray m = (RealArray)this.clone();
        for (int i = 0; i < this.nelem; ++i) {
            m.array[i] = this.array[i] - f.array[i];
        }
        return m;
    }

    public void subtractEquals(RealArray f) throws EuclidRuntimeException {
        this.checkConformable(f);
        for (int i = this.nelem - 1; i >= 0; --i) {
            int n = i;
            this.array[n] = this.array[n] - f.array[i];
        }
    }

    public void negative() {
        for (int i = 0; i < this.size(); ++i) {
            this.array[i] = -this.array[i];
        }
    }

    public RealArray addScalar(double f) {
        RealArray m = (RealArray)this.clone();
        int i = 0;
        while (i < this.nelem) {
            int n = i++;
            m.array[n] = m.array[n] + f;
        }
        return m;
    }

    public RealArray multiplyBy(double f) {
        RealArray m = (RealArray)this.clone();
        int i = 0;
        while (i < this.nelem) {
            int n = i++;
            m.array[n] = m.array[n] * f;
        }
        return m;
    }

    public RealArray plus(double f) {
        RealArray m = (RealArray)this.clone();
        int i = 0;
        while (i < this.nelem) {
            int n = i++;
            m.array[n] = m.array[n] + f;
        }
        return m;
    }

    public void setElementAt(int elem, double f) throws ArrayIndexOutOfBoundsException {
        this.array[elem] = f;
    }

    public RealArray getSubArray(int start, int end) {
        int nel = end - start + 1;
        RealArray f = new RealArray(nel, 0.0);
        System.arraycopy(this.array, start, f.array, 0, nel);
        return f;
    }

    public void setElements(int start, double[] a) {
        if (start < 0 || start + a.length > this.nelem) {
            throw new ArrayIndexOutOfBoundsException("was " + start + " in 0-" + a.length);
        }
        System.arraycopy(a, 0, this.array, start, a.length);
    }

    public void setElements(double[] a) {
        this.nelem = a.length;
        this.array = new double[this.nelem];
        this.bufsize = this.nelem;
        System.arraycopy(a, 0, this.array, 0, this.nelem);
    }

    public boolean isClear() {
        for (int i = 0; i < this.nelem; ++i) {
            if (Real.isZero(this.array[i], Real.getEpsilon())) continue;
            return false;
        }
        return true;
    }

    public void setAllElements(double f) {
        Real.initArray(this.nelem, this.array, f);
    }

    public double sumAllElements() {
        double sum = 0.0;
        for (int i = 0; i < this.nelem; ++i) {
            sum += this.array[i];
        }
        return sum;
    }

    public double sumProductOfAllElements(RealArray yarr) {
        if (yarr == null || yarr.size() != this.nelem) {
            throw new RuntimeException("arrays must be of equal length");
        }
        double sum = 0.0;
        for (int i = 0; i < this.nelem; ++i) {
            sum += this.array[i] * yarr.elementAt(i);
        }
        return sum;
    }

    public double absSumAllElements() {
        double sum = 0.0;
        for (int i = 0; i < this.nelem; ++i) {
            sum += Math.abs(this.array[i]);
        }
        return sum;
    }

    public double innerProduct() {
        return this.dotProduct(this);
    }

    public double dotProduct(RealArray f) throws EuclidRuntimeException {
        this.checkConformable(f);
        double sum = 0.0;
        for (int i = 0; i < this.nelem; ++i) {
            sum += this.array[i] * f.array[i];
        }
        return sum;
    }

    public double euclideanLength() {
        return Math.sqrt(this.innerProduct());
    }

    public double rms() throws EuclidRuntimeException {
        if (this.nelem == 0) {
            throw new EuclidRuntimeException("must have at least one point");
        }
        return this.euclideanLength() / Math.sqrt(this.nelem);
    }

    public RealArray unitVector() throws EuclidRuntimeException {
        double l = this.euclideanLength();
        if (Real.isZero(l, Real.getEpsilon())) {
            throw new EuclidRuntimeException("zero length vector");
        }
        double scale = 1.0 / l;
        RealArray f = new RealArray(this.nelem);
        f = this.multiplyBy(scale);
        return f;
    }

    public RealArray cumulativeSum() {
        RealArray temp = new RealArray(this.nelem);
        double sum = 0.0;
        for (int i = 0; i < this.nelem; ++i) {
            temp.array[i] = sum += this.array[i];
        }
        return temp;
    }

    public RealArray applyFilter(RealArray filter) {
        int k;
        int l;
        int j;
        if (this.nelem == 0 || filter == null || filter.nelem <= 1) {
            return this;
        }
        int nfilter = filter.size();
        int midfilter = (nfilter - 1) / 2;
        RealArray temp = new RealArray(this.nelem);
        double wt = 0.0;
        double sum = 0.0;
        for (j = 0; j < midfilter; ++j) {
            wt = 0.0;
            sum = 0.0;
            l = 0;
            for (k = midfilter - j; k < nfilter; ++k) {
                wt += Math.abs(filter.array[k]);
                sum += filter.array[k] * this.array[l++];
            }
            temp.array[j] = sum / wt;
        }
        wt = filter.absSumAllElements();
        for (j = midfilter; j < this.nelem - midfilter; ++j) {
            sum = 0.0;
            l = j - midfilter;
            for (k = 0; k < nfilter; ++k) {
                sum += filter.array[k] * this.array[l++];
            }
            temp.array[j] = sum / wt;
        }
        for (j = this.nelem - midfilter; j < this.nelem; ++j) {
            wt = 0.0;
            sum = 0.0;
            l = j - midfilter;
            for (k = 0; k < midfilter + this.nelem - j; ++k) {
                wt += Math.abs(filter.array[k]);
                sum += filter.array[k] * this.array[l++];
            }
            temp.array[j] = sum / wt;
        }
        return temp;
    }

    public RealArray trim(ArrayBase.Trim flag, double limit) {
        RealArray temp = new RealArray(this.nelem);
        for (int i = 0; i < this.nelem; ++i) {
            double v = this.array[i];
            if (flag == ArrayBase.Trim.BELOW && v < limit || flag == ArrayBase.Trim.ABOVE && v > limit) {
                v = limit;
            }
            temp.array[i] = v;
        }
        return temp;
    }

    public int indexOfLargestElement() {
        if (this.nelem == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int index = -1;
        double value = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.nelem; ++i) {
            if (!(this.array[i] > value)) continue;
            value = this.array[i];
            index = i;
        }
        return index;
    }

    public int indexOfSmallestElement() {
        if (this.nelem == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int index = -1;
        double value = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.nelem; ++i) {
            if (!(this.array[i] < value)) continue;
            value = this.array[i];
            index = i;
        }
        return index;
    }

    public double largestElement() throws ArrayIndexOutOfBoundsException {
        return this.array[this.indexOfLargestElement()];
    }

    public double getMax() throws ArrayIndexOutOfBoundsException {
        return this.array[this.indexOfLargestElement()];
    }

    public double smallestElement() throws ArrayIndexOutOfBoundsException {
        return this.array[this.indexOfSmallestElement()];
    }

    public double getMin() throws ArrayIndexOutOfBoundsException {
        return this.array[this.indexOfSmallestElement()];
    }

    public Double getMean() {
        Double mean = null;
        if (this.nelem > 0) {
            mean = 0.0;
            for (int i = 0; i < this.nelem; ++i) {
                mean = mean + this.array[i];
            }
            mean = mean / (double)this.nelem;
        }
        return mean;
    }

    public RealRange getRange() throws ArrayIndexOutOfBoundsException {
        if (this.nelem == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        RealRange r = new RealRange();
        for (int i = 0; i < this.nelem; ++i) {
            r.add(this.array[i]);
        }
        return r;
    }

    public void deleteElement(int elem) throws ArrayIndexOutOfBoundsException {
        if (elem < 0 || elem >= this.nelem) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.nelem;
        if (this.bufsize > this.nelem * 2) {
            this.bufsize /= 2;
        }
        double[] temp = new double[this.bufsize];
        System.arraycopy(this.array, 0, temp, 0, elem);
        System.arraycopy(this.array, elem + 1, temp, elem, this.nelem - elem);
        this.array = temp;
    }

    public void deleteElements(int low, int high) throws ArrayIndexOutOfBoundsException {
        if (low < 0 || low > high || high >= this.nelem) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int ndeleted = high - low + 1;
        double[] temp = new double[this.nelem - ndeleted];
        System.arraycopy(this.array, 0, temp, 0, low);
        System.arraycopy(this.array, high + 1, temp, low, this.nelem - low - ndeleted);
        this.array = temp;
        this.nelem -= ndeleted;
        this.bufsize = this.nelem;
        double[] array = new double[this.nelem];
        System.arraycopy(temp, 0, array, 0, this.nelem);
    }

    public void insertElementAt(int elem, double f) throws ArrayIndexOutOfBoundsException {
        if (elem < 0 || elem > this.nelem) {
            throw new ArrayIndexOutOfBoundsException();
        }
        double[] array1 = new double[this.nelem + 1];
        System.arraycopy(this.array, 0, array1, 0, elem);
        array1[elem] = f;
        System.arraycopy(this.array, elem, array1, elem + 1, this.nelem - elem);
        ++this.nelem;
        this.array = array1;
    }

    public void insertArray(int elem, RealArray f) throws ArrayIndexOutOfBoundsException {
        int n = f.size();
        if (elem < 0 || elem >= this.nelem || n < 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.nelem += n;
        double[] array1 = new double[this.nelem];
        System.arraycopy(this.array, 0, array1, 0, elem);
        System.arraycopy(f.getArray(), 0, array1, elem, n);
        System.arraycopy(this.array, elem, array1, n + elem, this.nelem - elem - n);
        this.array = array1;
    }

    public void addElement(double f) {
        this.makeSpace(this.nelem + 1);
        this.array[this.nelem++] = f;
    }

    public void addArray(RealArray f) {
        LOG.trace((Object)("COPY0 " + this.array.length + "//" + this.nelem + "/" + f.nelem + "/" + this.array.length));
        this.makeSpace(this.nelem + f.nelem);
        LOG.trace((Object)("COPY1 " + this.array.length + "//" + this.nelem + "/" + f.nelem + "/" + this.array.length));
        System.arraycopy(f.array, 0, this.array, this.nelem, f.nelem);
        this.nelem += f.nelem;
    }

    public RealArray getReorderedArray(IntSet idx) throws EuclidRuntimeException {
        RealArray temp = new RealArray(this.nelem);
        for (int i = 0; i < this.nelem; ++i) {
            int index = idx.elementAt(i);
            if (index > this.nelem) {
                throw new EuclidRuntimeException("index out of range " + index);
            }
            temp.array[i] = this.array[index];
        }
        return temp;
    }

    public static void round(double[] dd, int ndec) {
        for (int i = 0; i < dd.length; ++i) {
            dd[i] = Real.normalize(dd[i], ndec);
        }
    }

    public IntSet inRange(RealRange r) {
        int n = this.size();
        IntSet temp = new IntSet();
        for (int i = 0; i < n; ++i) {
            if (!r.isValid() || !r.includes(this.array[i])) continue;
            temp.addElement(i);
        }
        return temp;
    }

    public IntSet outOfRange(RealRange r) {
        int n = this.size();
        IntSet temp = new IntSet();
        for (int i = 0; i < n; ++i) {
            if (!r.isValid() || r.includes(this.array[i])) continue;
            temp.addElement(i);
        }
        return temp;
    }

    public String[] getStringValues() {
        String[] temp = new String[this.nelem];
        for (int i = 0; i < this.nelem; ++i) {
            temp[i] = Double.toString(this.array[i]);
        }
        return temp;
    }

    public String getStringArray() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.nelem; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(this.array[i]);
        }
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("(");
        for (int i = 0; i < this.nelem; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(this.array[i]);
        }
        s.append(")");
        return s.toString();
    }

    public static double[] deleteElements(double[] f, int low, int hi) {
        int ndel;
        if (hi >= f.length) {
            hi = f.length - 1;
        }
        if (low < 0) {
            low = 0;
        }
        if ((ndel = hi - low + 1) <= 0) {
            return f;
        }
        double[] temp = new double[f.length - ndel];
        System.arraycopy(f, 0, temp, 0, low);
        System.arraycopy(f, hi + 1, temp, low, f.length - hi - 1);
        return temp;
    }

    public double findFirstLocalMaximumafter(int start, double cutoff) {
        double index = Double.NaN;
        boolean hitmin = false;
        boolean hitmax = false;
        double sigyx = 0.0;
        double sigy = 0.0;
        for (int i = start; i < this.nelem; ++i) {
            double d = this.array[i];
            if (!hitmin && !hitmax) {
                if (!(d < cutoff)) continue;
                hitmin = true;
                continue;
            }
            if (hitmin && !hitmax) {
                if (!(d > cutoff)) continue;
                hitmax = true;
                hitmin = false;
                continue;
            }
            if (!hitmax) continue;
            if (d < cutoff) {
                hitmin = true;
                break;
            }
            sigyx += d * (double)i;
            sigy += d;
        }
        if (hitmin && hitmax) {
            index = sigyx / sigy;
        }
        return index;
    }

    public double getBaseLine() {
        double baseOffset;
        Univariate univariate = new Univariate(this);
        int binCount = 100;
        univariate.setBinCount(binCount);
        double step = this.getRange().getRange() / (double)binCount;
        double min = this.getMin();
        int[] bins = univariate.getHistogramCounts();
        int ibMax = -1;
        int binMax = -1;
        for (int i = 0; i < bins.length; ++i) {
            if (bins[i] <= binMax) continue;
            binMax = bins[i];
            ibMax = i;
        }
        int iMin = -1;
        for (int i = ibMax; i >= 0; --i) {
            if (bins[i] >= binMax / 2) continue;
            iMin = i;
            break;
        }
        iMin = iMin > 0 ? iMin : 0;
        int iMax = -1;
        for (int i = ibMax; i < binCount; ++i) {
            if (bins[i] >= binMax / 2) continue;
            iMax = i;
            break;
        }
        int n = iMax = iMax > 0 ? iMax : binCount - 1;
        if (iMin == ibMax || ibMax == binCount - 1) {
            baseOffset = 0.0;
        } else {
            double weight = 0.0;
            double sum = 0.0;
            for (int i = iMin; i <= iMax; ++i) {
                double w = bins[i];
                weight += w;
                sum += w * (double)i;
            }
            double deltaB = sum / weight;
            baseOffset = step * deltaB + min;
        }
        return baseOffset;
    }

    public RealArray format(int places) {
        for (int i = 0; i < this.nelem; ++i) {
            this.array[i] = Util.format(this.array[i], places);
        }
        return this;
    }

    private void xfswap(double[] x, int a, int b) {
        double tmp = x[a];
        x[a] = x[b];
        x[b] = tmp;
    }

    private void inssort(int left, int right) {
        for (int i = left + 1; i <= right; ++i) {
            double v = this.array[i];
            int j = i;
            int k = j - 1;
            while (j > 0 && this.array[k] > v) {
                this.array[j] = this.array[k];
                --j;
                --k;
            }
            this.array[j] = v;
        }
    }

    private int partition(int left, int right) {
        int mid = (left + right) / 2;
        if (this.array[left] > this.array[mid]) {
            this.xfswap(this.array, left, mid);
        }
        if (this.array[left] > this.array[right]) {
            this.xfswap(this.array, left, right);
        }
        if (this.array[mid] > this.array[right]) {
            this.xfswap(this.array, mid, right);
        }
        int j = right - 1;
        this.xfswap(this.array, mid, j);
        int i = left;
        double v = this.array[j];
        while (true) {
            if (this.array[++i] < v) {
                continue;
            }
            while (this.array[--j] > v) {
            }
            this.xfswap(this.array, i, j);
            if (i >= j) break;
        }
        this.xfswap(this.array, j, i);
        this.xfswap(this.array, i, right - 1);
        return i;
    }

    private void iqsort(int left, int right) {
        while (right - left > 16) {
            int i = this.partition(left, right);
            if (i - left > right - i) {
                this.iqsort(i + 1, right);
                right = i - 1;
                continue;
            }
            this.iqsort(left, i - 1);
            left = i + 1;
        }
    }

    public void sortAscending() {
        if (this.nelem <= 0) {
            return;
        }
        this.iqsort(0, this.nelem - 1);
        this.inssort(0, this.nelem - 1);
    }

    public void sortDescending() {
        this.sortAscending();
        this.reverse();
    }

    public void reverse() {
        int i = 0;
        for (int j = this.nelem - 1; i < j; ++i, --j) {
            this.xfswap(this.array, i, j);
        }
    }

    public RealArray createReorderedArray(IntSet intSet) {
        RealArray ra = null;
        if (intSet.size() == this.size()) {
            ra = new RealArray(intSet.size());
            for (int i = 0; i < intSet.size(); ++i) {
                ra.setElementAt(i, this.get(intSet.elementAt(i)));
            }
        }
        return ra;
    }

    public IntSet indexSortAscending() {
        if (this.nelem <= 0) {
            return new IntSet();
        }
        IntSet idx = new IntSet(this.nelem);
        IntArray iarray = new IntArray(idx.getElements());
        this.xxiqsort(iarray, this.array, 0, this.nelem - 1);
        this.xxinssort(iarray, this.array, 0, this.nelem - 1);
        try {
            idx = new IntSet(iarray.getArray());
        }
        catch (Exception e) {
            throw new EuclidRuntimeException(e.toString());
        }
        return idx;
    }

    public IntSet indexSortDescending() {
        IntSet idx = this.indexSortAscending();
        int[] temp = new IntArray(idx.getElements()).getReverseArray();
        try {
            idx = new IntSet(temp);
        }
        catch (Exception e) {
            throw new EuclidRuntimeException(e.toString());
        }
        return idx;
    }

    private void xxinssort(IntArray iarr, double[] pfl, int left, int right) {
        for (int i = left + 1; i <= right; ++i) {
            int v = iarr.elementAt(i);
            int j = i;
            int k = j - 1;
            while (j > 0 && pfl[iarr.elementAt(k)] > pfl[v]) {
                iarr.setElementAt(j, iarr.elementAt(k));
                --j;
                --k;
            }
            iarr.setElementAt(j, v);
        }
    }

    private int xxpartition(IntArray iarr, double[] pfl, int left, int right) {
        int mid = (left + right) / 2;
        if (pfl[iarr.elementAt(left)] > pfl[iarr.elementAt(mid)]) {
            this.xxfswap(iarr, left, mid);
        }
        if (pfl[iarr.elementAt(left)] > pfl[iarr.elementAt(right)]) {
            this.xxfswap(iarr, left, right);
        }
        if (pfl[iarr.elementAt(mid)] > pfl[iarr.elementAt(right)]) {
            this.xxfswap(iarr, mid, right);
        }
        int j = right - 1;
        this.xxfswap(iarr, mid, j);
        int i = left;
        double v = pfl[iarr.elementAt(j)];
        while (true) {
            if (pfl[iarr.elementAt(++i)] < v) {
                continue;
            }
            while (pfl[iarr.elementAt(--j)] > v) {
            }
            this.xxfswap(iarr, i, j);
            if (i >= j) break;
        }
        this.xxfswap(iarr, j, i);
        this.xxfswap(iarr, i, right - 1);
        return i;
    }

    private void xxiqsort(IntArray iarr, double[] pfl, int left, int right) {
        while (right - left > 16) {
            int i = this.xxpartition(iarr, pfl, left, right);
            if (i - left > right - i) {
                this.xxiqsort(iarr, pfl, i + 1, right);
                right = i - 1;
                continue;
            }
            this.xxiqsort(iarr, pfl, left, i - 1);
            left = i + 1;
        }
    }

    private void xxfswap(IntArray iarr, int a, int b) {
        int t = iarr.elementAt(a);
        iarr.setElementAt(a, iarr.elementAt(b));
        iarr.setElementAt(b, t);
    }

    public Monotonicity getMonotonicity() {
        Monotonicity monotonicity = null;
        if (this.size() > 1) {
            double last = this.get(0);
            for (int i = 1; i < this.size(); ++i) {
                double current = this.get(i);
                Monotonicity m = null;
                if (current < last) {
                    m = Monotonicity.DECREASING;
                } else if (current > last) {
                    m = Monotonicity.INCREASING;
                }
                if (m != null) {
                    if (monotonicity == null) {
                        monotonicity = m;
                    } else if (monotonicity != m) {
                        monotonicity = null;
                        break;
                    }
                }
                last = current;
            }
        }
        return monotonicity;
    }

    public static void check(RealArray array, int size) throws EuclidRuntimeException {
        if (array == null) {
            throw new EuclidRuntimeException("null array");
        }
        if (array.size() != size) {
            throw new EuclidRuntimeException("array size required (" + size + ") found " + array.size());
        }
    }

    public static boolean isFloatArray(String s, String delimiterRegex) {
        boolean couldBeFloatArray = true;
        String[] ss = s.split(delimiterRegex);
        try {
            new RealArray(ss);
        }
        catch (Exception e) {
            couldBeFloatArray = false;
        }
        return couldBeFloatArray;
    }

    public RealArray createScaledArrayToRange(double thisX0, double thisX1, double targetX0, double targetX1) {
        RealArray newArray = null;
        if (this.nelem > 1) {
            Double scale = null;
            try {
                scale = (targetX0 - targetX1) / (thisX0 - thisX1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (scale != null && !Double.isNaN(scale) && !Double.isInfinite(scale) && this.nelem > 0) {
                newArray = new RealArray(this);
                newArray = newArray.addScalar(-thisX0);
                newArray = newArray.multiplyBy(scale);
                newArray = newArray.addScalar(targetX0);
            }
        }
        return newArray;
    }

    public RealArray createScaledArrayToRange(double x0, double x1) {
        RealArray newArray = null;
        if (this.nelem > 1) {
            double thisX0 = this.get(0);
            double thisX1 = this.get(this.nelem - 1);
            Double scale = null;
            try {
                scale = (x0 - x1) / (thisX0 - thisX1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (scale != null && !Double.isNaN(scale) && !Double.isInfinite(scale) && this.nelem > 0) {
                newArray = new RealArray(this);
                newArray = newArray.addScalar(-thisX0);
                newArray = newArray.multiplyBy(scale);
                newArray = newArray.addScalar(x0);
            }
        }
        return newArray;
    }

    public static RealArray createRealArray(int[] integers) {
        RealArray realArray = null;
        if (integers != null) {
            realArray = new RealArray(integers.length);
            for (int i = 0; i < integers.length; ++i) {
                realArray.array[i] = integers[i];
            }
        }
        return realArray;
    }

    public static RealArray createRealArray(IntArray intArray) {
        int[] ints = intArray == null ? null : intArray.array;
        return RealArray.createRealArray(ints);
    }

    public RealArray calculateDifferences() {
        RealArray differenceArray = new RealArray(this.nelem - 1);
        for (int i = 0; i < this.nelem - 1; ++i) {
            double diff = this.array[i + 1] - this.array[i];
            differenceArray.setElementAt(i, diff);
        }
        return differenceArray;
    }

    public IntArray createIntArray() {
        IntArray intArray = new IntArray(this.nelem);
        for (int i = 0; i < this.nelem; ++i) {
            intArray.array[i] = (int)this.array[i];
        }
        return intArray;
    }

    @Override
    public Iterator<Double> iterator() {
        return this.array == null || this.array.length < this.nelem ? null : new DoubleIterator(this.array, this.nelem);
    }

    public RealArray shiftOriginToRight(double delta) {
        RealArray newArray = new RealArray(this.nelem);
        int offset = 0;
        while (delta < 0.0) {
            ++offset;
            delta += 1.0;
        }
        while (delta >= 1.0) {
            --offset;
            delta -= 1.0;
        }
        LOG.trace((Object)(offset + " " + delta));
        for (int i = 0; i < this.nelem; ++i) {
            int index0 = i - offset + 1;
            int index1 = index0 - 1;
            double previousValue = this.getValueCorrectedForEnds(index1);
            double thisValue = this.getValueCorrectedForEnds(index0);
            LOG.trace((Object)(i + " " + previousValue + " " + thisValue));
            double newValue = previousValue * (1.0 - delta) + thisValue * delta;
            newArray.setElementAt(i, newValue);
        }
        LOG.trace((Object)("newArray: " + newArray.format(2) + "\n"));
        return newArray;
    }

    @Deprecated
    public RealArray scaleAndInterpolate(int newNelem) {
        if (newNelem == this.nelem) {
            return new RealArray(this);
        }
        RealArray newArray = new RealArray(newNelem);
        double old2NewScale = (double)this.nelem / (double)newNelem;
        double pixelScale = 1.0;
        for (int iold = 0; iold < this.nelem; ++iold) {
            LOG.trace((Object)("====" + iold + "===="));
            double value = this.elementAt(iold) * pixelScale;
            if (old2NewScale < 1.0) {
                this.scaleFewToMany(newArray, old2NewScale, iold, value);
                continue;
            }
            this.scaleManyToFew(newNelem, newArray, old2NewScale, iold, value);
        }
        LOG.trace((Object)("newArray: " + newArray.format(2) + "\n"));
        return newArray;
    }

    private void scaleManyToFew(int newNelem, RealArray newArray, double old2NewScale, int iold, double value) {
        double upperNew = (double)(iold + 1) / old2NewScale;
        int intUpperNew = (int)upperNew;
        double lowerNew = (double)iold / old2NewScale;
        int intLowerNew = (int)lowerNew;
        if (intUpperNew == intLowerNew) {
            ++intUpperNew;
        }
        lowerNew = (double)intLowerNew * old2NewScale;
        upperNew = (double)intUpperNew * old2NewScale;
        LOG.trace((Object)(lowerNew + " " + upperNew));
        if (lowerNew <= (double)iold && upperNew >= (double)(iold + 1)) {
            int n = intLowerNew;
            newArray.array[n] = newArray.array[n] + value;
            LOG.trace((Object)("complete " + intLowerNew + " " + value));
        } else {
            double delta = 0.0;
            int index = -1;
            if (lowerNew > (double)iold) {
                delta = lowerNew - (double)iold;
                index = intLowerNew;
            } else {
                delta = upperNew - (double)iold;
                index = intUpperNew;
            }
            int n = index;
            newArray.array[n] = newArray.array[n] + value * delta;
            if (index < newNelem - 1) {
                int n2 = index + 1;
                newArray.array[n2] = newArray.array[n2] + value * (1.0 - delta);
            }
            LOG.trace((Object)("split " + index + " " + delta + " " + value));
        }
    }

    private void scaleFewToMany(RealArray newArray, double old2NewScale, int iold, double value) {
        double lowerNew = (double)iold / old2NewScale;
        double upperNew = (double)(iold + 1) / old2NewScale;
        int intLowerNew = (int)lowerNew;
        int intUpperNew = (int)upperNew;
        if ((double)(intLowerNew + 1) < upperNew) {
            double delta = value * ((double)(intLowerNew + 1) - lowerNew);
            LOG.trace((Object)("deltalow: " + Util.format(delta, 2)));
            int n = intLowerNew;
            newArray.array[n] = newArray.array[n] + delta;
        }
        int middle = intLowerNew + 1;
        while (middle < intUpperNew) {
            LOG.trace((Object)("deltamid: " + Util.format(value, 2)));
            int n = middle++;
            newArray.array[n] = newArray.array[n] + value;
        }
        if ((double)intUpperNew < upperNew) {
            double delta = value * (upperNew - (double)intUpperNew);
            LOG.trace((Object)("deltahi: " + Util.format(delta, 2)));
            int n = intUpperNew;
            newArray.array[n] = newArray.array[n] + delta;
        }
    }

    private double getValueCorrectedForEnds(int index) {
        double value = 0.0;
        value = index < 0 ? this.elementAt(0) : (index >= this.nelem ? this.elementAt(this.nelem - 1) : this.elementAt(index));
        return value;
    }

    public RealArray shiftOriginToRightOld(double delta) {
        RealArray array0 = new RealArray(this);
        RealArray array1 = new RealArray(this);
        int offset = 0;
        while (delta < 0.0) {
            ++offset;
            delta += 1.0;
        }
        while (delta >= 1.0) {
            --offset;
            delta -= 1.0;
        }
        double scale = Math.abs(delta);
        LOG.debug((Object)("this: " + this + " " + offset + " " + Util.format(delta, 2)));
        array0.shiftArrayRight(offset);
        array1.shiftArrayRight(offset);
        array0 = array0.multiplyBy(scale);
        array1 = array1.multiplyBy(1.0 - scale);
        if (delta >= 0.0) {
            array0.shiftArrayRight(-1);
        } else if (delta < 0.0) {
            array1.shiftArrayRight(1);
        }
        LOG.debug((Object)("array0: " + array0.format(2)));
        LOG.debug((Object)("array1: " + array1.format(2)));
        RealArray newArray = array0.plus(array1);
        LOG.debug((Object)("newArray: " + newArray.format(2) + "\n"));
        return newArray;
    }

    public void shiftArrayRight(int nplaces) {
        if (nplaces >= 0) {
            for (int i = 0; i < nplaces; ++i) {
                this.insertElementAt(0, this.get(0));
                this.deleteElement(this.nelem - 1);
            }
        } else {
            nplaces = 0 - nplaces;
            for (int i = 0; i < nplaces; ++i) {
                this.insertElementAt(this.nelem, this.get(this.nelem - 1));
                this.deleteElement(0);
            }
        }
    }

    public double getLast() {
        return this.nelem == 0 ? Double.NaN : this.get(this.nelem - 1);
    }

    public static enum Monotonicity {
        INCREASING,
        DECREASING;

    }

    public static enum Filter {
        GAUSSIAN("Gaussian"),
        GAUSSIAN_FIRST_DERIVATIVE("Gaussian First Derivative"),
        GAUSSIAN_SECOND_DERIVATIVE("Gaussian Second Derivative");

        public String string;

        private Filter(String s) {
            this.string = s;
        }
    }
}

