/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.stml.attribute;

import nu.xom.Attribute;
import nu.xom.Element;
import org.xmlcml.stml.STMLElement;
import org.xmlcml.stml.attribute.StringSTAttribute;
import org.xmlcml.stml.attribute.UnitsAttribute;
import org.xmlcml.stml.interfacex.HasUnits;

public class NamespaceRefAttribute
extends StringSTAttribute {
    public static final String PREFIX_REGEX = "[A-Za-z][A-Za-z0-9\\.\\-\\_]*";
    static int count = 0;

    public NamespaceRefAttribute(String name) {
        super(name);
        this.init(name);
    }

    public NamespaceRefAttribute(String name, String value) {
        this(name);
        this.setSTMLValue(value);
    }

    public NamespaceRefAttribute(Attribute att) {
        this(att.getLocalName());
        this.setSTMLValue(att.getValue());
    }

    void init(String name) {
    }

    @Override
    public void setSTMLValue(String value) {
        super.setSTMLValue(value);
        if (!this.getValue().equals("") && this.getPrefix() == null) {
            throw new RuntimeException("attribute value [" + this.getValue() + "] for " + this.getLocalName() + " must be QName");
        }
    }

    public Element getElement() {
        return (Element)this.getParent();
    }

    public String getPrefix() {
        return NamespaceRefAttribute.getPrefix(this.getValue());
    }

    public static String getPrefix(String value) {
        int idx;
        String prefix = null;
        if (value != null && (idx = value.indexOf(":")) != -1) {
            prefix = value.substring(0, idx);
        }
        return prefix;
    }

    public String getNamespaceURIString() {
        Element element = this.getElement();
        String prefix = this.getPrefix();
        String namespaceURI = prefix == null ? null : element.getNamespaceURI(prefix);
        return namespaceURI;
    }

    public String getIdRef() {
        return NamespaceRefAttribute.getLocalName(this.getValue());
    }

    public void setIdRef(String idRef) {
        String value = NamespaceRefAttribute.createValue(this.getPrefix(), idRef);
        this.setSTMLValue(value);
    }

    public static String createValue(String prefix, String value) {
        if (prefix == null) {
            throw new RuntimeException("null prefix");
        }
        if (value == null) {
            throw new RuntimeException("null value");
        }
        if (prefix.trim().equals("")) {
            throw new RuntimeException("cannot have empty prefix");
        }
        if (value.trim().equals("")) {
            throw new RuntimeException("cannot have empty value");
        }
        if (!prefix.matches(PREFIX_REGEX)) {
            throw new RuntimeException("Prefix [" + prefix + "] incompatible with " + PREFIX_REGEX);
        }
        return prefix + ":" + value;
    }

    public static String getLocalName(String name) {
        String localName = null;
        if (name != null) {
            int idx = name.indexOf(":");
            localName = name.substring(idx + 1);
        }
        return localName;
    }

    public static void setUnits(HasUnits hasUnits, String prefix, String id, String namespaceURI) {
        Attribute units;
        STMLElement element = (STMLElement)((Object)hasUnits);
        String currentNamespace = element.getNamespaceURIForPrefix(prefix);
        if (currentNamespace != null) {
            if (!currentNamespace.equals(namespaceURI)) {
                throw new RuntimeException("Cannot reset units namespace for " + prefix + " from " + currentNamespace + " to " + namespaceURI);
            }
        } else {
            element.addNamespaceDeclaration(prefix, namespaceURI);
        }
        if ((units = element.getAttribute("units")) != null) {
            element.removeAttribute(units);
        }
        UnitsAttribute unitAttribute = new UnitsAttribute(NamespaceRefAttribute.createValue(prefix, id));
        element.addAttribute(unitAttribute);
    }
}

