/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigManager.class);
    public static final String CONFIG_MANAGER = "ConfigManager";
    private final Function<String, String> propertyResolver;

    public ConfigManager() {
        this.propertyResolver = ConfigManager::getHawtioSystemProperty;
    }

    public ConfigManager(Function<String, String> propertyResolver) {
        Objects.requireNonNull(propertyResolver);
        this.propertyResolver = x -> ConfigManager.getProperty(x, ConfigManager::getHawtioSystemProperty, propertyResolver);
    }

    public Optional<String> get(String name) {
        String answer = this.propertyResolver.apply(name);
        LOG.debug("Property {} is set to value {}", (Object)name, (Object)answer);
        return Optional.ofNullable(answer);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return Boolean.parseBoolean(this.get(name).orElse(Boolean.toString(defaultValue)));
    }

    private static String getHawtioSystemProperty(String name) {
        return System.getProperty("hawtio." + name);
    }

    @SafeVarargs
    private static String getProperty(String name, Function<String, String> ... propertyResolvers) {
        return Arrays.stream(propertyResolvers).map(resolver -> (String)resolver.apply(name)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

