/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.io.Serializable;
import java.util.Map;
import org.apache.cayenne.ObjectIdCompound;
import org.apache.cayenne.ObjectIdNumber;
import org.apache.cayenne.ObjectIdSingle;
import org.apache.cayenne.ObjectIdTmp;

public interface ObjectId
extends Serializable {
    public static ObjectId of(String entityName) {
        return new ObjectIdTmp(entityName);
    }

    public static ObjectId of(String entityName, byte[] tmpKey) {
        return new ObjectIdTmp(entityName, tmpKey);
    }

    public static ObjectId of(String entityName, String keyName, Object value) {
        if (value instanceof Number) {
            return new ObjectIdNumber(entityName, keyName, (Number)value);
        }
        return new ObjectIdSingle(entityName, keyName, value);
    }

    public static ObjectId of(String entityName, ObjectId objectId) {
        if (objectId instanceof ObjectIdNumber) {
            ObjectIdNumber id = (ObjectIdNumber)objectId;
            return new ObjectIdNumber(entityName, id.getKeyName(), id.getValue());
        }
        if (objectId instanceof ObjectIdSingle) {
            ObjectIdSingle id = (ObjectIdSingle)objectId;
            return new ObjectIdSingle(entityName, id.getKeyName(), id.getValue());
        }
        if (objectId instanceof ObjectIdTmp) {
            return ObjectId.of(entityName, objectId.getKey());
        }
        return ObjectId.of(entityName, objectId.getIdSnapshot());
    }

    public static ObjectId of(String entityName, Map<String, ?> values) {
        if (values.size() == 1) {
            Map.Entry<String, ?> entry = values.entrySet().iterator().next();
            return ObjectId.of(entityName, entry.getKey(), entry.getValue());
        }
        return new ObjectIdCompound(entityName, values);
    }

    public boolean isTemporary();

    public String getEntityName();

    public byte[] getKey();

    public Map<String, Object> getIdSnapshot();

    public Map<String, Object> getReplacementIdMap();

    public ObjectId createReplacementId();

    public boolean isReplacementIdAttached();
}

