/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;

public class BigDecimalType
implements ExtendedType<BigDecimal> {
    @Override
    public String getClassName() {
        return BigDecimal.class.getName();
    }

    @Override
    public BigDecimal materializeObject(ResultSet rs, int index, int type) throws Exception {
        return rs.getBigDecimal(index);
    }

    @Override
    public BigDecimal materializeObject(CallableStatement rs, int index, int type) throws Exception {
        return rs.getBigDecimal(index);
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, BigDecimal value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            statement.setBigDecimal(pos, value);
        }
    }

    @Override
    public String toString(BigDecimal value) {
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }
}

