/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.util.Calendar;
import org.apache.cayenne.access.types.ExtendedType;

public class TimeType
implements ExtendedType<Time> {
    private final Calendar calendar;
    private final boolean useCalendar;

    public TimeType() {
        this(false);
    }

    public TimeType(boolean useCalendar) {
        this.useCalendar = useCalendar;
        this.calendar = this.useCalendar ? Calendar.getInstance() : null;
    }

    @Override
    public String getClassName() {
        return Time.class.getName();
    }

    @Override
    public Time materializeObject(ResultSet rs, int index, int type) throws Exception {
        return this.useCalendar ? rs.getTime(index, this.calendar) : rs.getTime(index);
    }

    @Override
    public Time materializeObject(CallableStatement rs, int index, int type) throws Exception {
        return this.useCalendar ? rs.getTime(index, this.calendar) : rs.getTime(index);
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Time value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else if (this.useCalendar) {
            statement.setTime(pos, value, this.calendar);
        } else {
            statement.setTime(pos, value);
        }
    }

    @Override
    public String toString(Time value) {
        if (value == null) {
            return "NULL";
        }
        return '\'' + value.toString() + '\'';
    }
}

