/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.ComparableProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;

public class StringProperty<E extends CharSequence>
extends BaseProperty<E>
implements ComparableProperty<E> {
    protected StringProperty(String name, Expression expression, Class<E> type) {
        super(name, expression, type);
    }

    public Expression like(String pattern) {
        return ExpressionFactory.likeExp(this.getExpression(), (Object)pattern);
    }

    public Expression like(StringProperty<?> pattern) {
        return ExpressionFactory.likeExp(this.getExpression(), (Object)pattern.getExpression());
    }

    public Expression like(String pattern, char escapeChar) {
        return ExpressionFactory.likeExp(this.getExpression(), (Object)pattern, escapeChar);
    }

    public Expression likeIgnoreCase(String pattern) {
        return ExpressionFactory.likeIgnoreCaseExp(this.getExpression(), (Object)pattern);
    }

    public Expression likeIgnoreCase(StringProperty<?> pattern) {
        return ExpressionFactory.likeIgnoreCaseExp(this.getExpression(), (Object)pattern.getExpression());
    }

    public Expression nlike(String value) {
        return ExpressionFactory.notLikeExp(this.getExpression(), (Object)value);
    }

    public Expression nlike(StringProperty<?> value) {
        return ExpressionFactory.notLikeExp(this.getExpression(), (Object)value.getExpression());
    }

    public Expression nlikeIgnoreCase(String value) {
        return ExpressionFactory.notLikeIgnoreCaseExp(this.getExpression(), (Object)value);
    }

    public Expression nlikeIgnoreCase(StringProperty<?> value) {
        return ExpressionFactory.notLikeIgnoreCaseExp(this.getExpression(), (Object)value.getExpression());
    }

    public Expression contains(String substring) {
        return ExpressionFactory.containsExp(this.getExpression(), substring);
    }

    public Expression startsWith(String value) {
        return ExpressionFactory.startsWithExp(this.getExpression(), value);
    }

    public Expression endsWith(String value) {
        return ExpressionFactory.endsWithExp(this.getExpression(), value);
    }

    public Expression containsIgnoreCase(String value) {
        return ExpressionFactory.containsIgnoreCaseExp(this.getExpression(), value);
    }

    public Expression startsWithIgnoreCase(String value) {
        return ExpressionFactory.startsWithIgnoreCaseExp(this.getExpression(), value);
    }

    public Expression endsWithIgnoreCase(String value) {
        return ExpressionFactory.endsWithIgnoreCaseExp(this.getExpression(), value);
    }

    public NumericProperty<Integer> length() {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.lengthExp(this.getExpression()), Integer.class);
    }

    public NumericProperty<Integer> locate(String string) {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.locateExp(ExpressionFactory.wrapScalarValue(string), this.getExpression()), Integer.class);
    }

    public NumericProperty<Integer> locate(StringProperty<? extends String> property) {
        return PropertyFactory.createNumeric(FunctionExpressionFactory.locateExp(property.getExpression(), this.getExpression()), Integer.class);
    }

    public StringProperty<String> trim() {
        return PropertyFactory.createString(FunctionExpressionFactory.trimExp(this.getExpression()), String.class);
    }

    public StringProperty<String> upper() {
        return PropertyFactory.createString(FunctionExpressionFactory.upperExp(this.getExpression()), String.class);
    }

    public StringProperty<String> lower() {
        return PropertyFactory.createString(FunctionExpressionFactory.lowerExp(this.getExpression()), String.class);
    }

    public StringProperty<String> concat(Object ... args) {
        Expression[] exp = new Expression[args.length + 1];
        int i = 0;
        exp[i++] = this.getExpression();
        for (Object arg : args) {
            if (arg instanceof BaseProperty) {
                exp[i++] = ((BaseProperty)arg).getExpression();
                continue;
            }
            if (arg instanceof Expression) {
                exp[i++] = (Expression)arg;
                continue;
            }
            if (arg == null) continue;
            exp[i++] = ExpressionFactory.wrapScalarValue(arg.toString());
        }
        return PropertyFactory.createString(FunctionExpressionFactory.concatExp(exp), String.class);
    }

    public StringProperty<String> substring(int offset, int length) {
        return PropertyFactory.createString(FunctionExpressionFactory.substringExp(this.getExpression(), offset, length), String.class);
    }

    public StringProperty<String> substring(NumericProperty<?> offset, NumericProperty<?> length) {
        return PropertyFactory.createString(FunctionExpressionFactory.substringExp(this.getExpression(), offset.getExpression(), length.getExpression()), String.class);
    }

    @Override
    public StringProperty<E> alias(String alias) {
        return PropertyFactory.createString(alias, this.getExpression(), this.getType());
    }

    @Override
    public StringProperty<E> enclosing() {
        return PropertyFactory.createString(ExpressionFactory.enclosingObjectExp(this.getExpression()), this.getType());
    }
}

