/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.oracle.Oracle8LOBBatchTranslator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.UpdateBatchQuery;

class Oracle8LOBUpdateBatchTranslator
extends Oracle8LOBBatchTranslator {
    Oracle8LOBUpdateBatchTranslator(UpdateBatchQuery query, DbAdapter adapter, String trimFunction) {
        super(query, adapter, trimFunction);
    }

    @Override
    List<Object> getValuesForLOBUpdateParameters(BatchQueryRow row) {
        int i;
        int len = this.query.getDbAttributes().size();
        UpdateBatchQuery updateBatch = (UpdateBatchQuery)this.query;
        ArrayList<Object> values = new ArrayList<Object>(len);
        List<DbAttribute> qualifierAttributes = updateBatch.getQualifierAttributes();
        List<DbAttribute> updatedDbAttributes = updateBatch.getUpdatedAttributes();
        int updatedLen = updatedDbAttributes.size();
        int qualifierLen = qualifierAttributes.size();
        for (i = 0; i < updatedLen; ++i) {
            DbAttribute attribute = updatedDbAttributes.get(i);
            Object value = row.getValue(i);
            if (!this.isUpdateableColumn(value, attribute.getType())) continue;
            values.add(value);
        }
        for (i = 0; i < qualifierLen; ++i) {
            values.add(row.getValue(updatedLen + i));
        }
        return values;
    }

    @Override
    public String createSql(BatchQueryRow row) {
        DbAttribute attribute;
        UpdateBatchQuery updateBatch = (UpdateBatchQuery)this.query;
        List<DbAttribute> idDbAttributes = updateBatch.getQualifierAttributes();
        List<DbAttribute> updatedDbAttributes = updateBatch.getUpdatedAttributes();
        QuotingStrategy strategy = this.adapter.getQuotingStrategy();
        StringBuilder buffer = new StringBuilder("UPDATE ");
        buffer.append(strategy.quotedFullyQualifiedName(this.query.getDbEntity()));
        buffer.append(" SET ");
        int len = updatedDbAttributes.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            attribute = updatedDbAttributes.get(i);
            buffer.append(strategy.quotedName(attribute));
            buffer.append(" = ");
            this.appendUpdatedParameter(buffer, attribute, row.getValue(i));
        }
        buffer.append(" WHERE ");
        Iterator<DbAttribute> i = idDbAttributes.iterator();
        while (i.hasNext()) {
            attribute = i.next();
            this.appendDbAttribute(buffer, attribute);
            buffer.append(" = ?");
            if (!i.hasNext()) continue;
            buffer.append(" AND ");
        }
        return buffer.toString();
    }
}

