/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportConfiguration;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.di.Injector;

public class DbImportConfigurationValidator
implements Cloneable {
    private final ReverseEngineering reverseEngineering;
    private final DbImportConfiguration config;
    private final Injector injector;

    public DbImportConfigurationValidator(ReverseEngineering reverseEngineering, DbImportConfiguration config, Injector injector) {
        this.reverseEngineering = reverseEngineering;
        this.config = config;
        this.injector = injector;
    }

    public void validate() throws Exception {
        DbAdapter adapter;
        DataNodeDescriptor dataNodeDescriptor = this.config.createDataNodeDescriptor();
        try {
            DataSource dataSource = this.injector.getInstance(DataSourceFactory.class).getDataSource(dataNodeDescriptor);
            adapter = this.injector.getInstance(DbAdapterFactory.class).createAdapter(dataNodeDescriptor, dataSource);
        }
        catch (Exception ex) {
            throw new Exception("Error creating DataSource or DbAdapter for DataNodeDescriptor (" + dataNodeDescriptor + ")", ex);
        }
        if (adapter != null && !adapter.supportsCatalogsOnReverseEngineering() && !this.isReverseEngineeringCatalogsEmpty()) {
            String message = "Your database does not support catalogs on reverse engineering. It allows to connect to only one at the moment. Please don't note catalogs in <dbimport> configuration.";
            throw new Exception(message);
        }
    }

    private boolean isReverseEngineeringCatalogsEmpty() {
        List<Catalog> catalogs = this.reverseEngineering.getCatalogs();
        if (catalogs == null || catalogs.isEmpty()) {
            return true;
        }
        for (Catalog catalog : catalogs) {
            if (catalog.getName() == null) continue;
            return false;
        }
        return true;
    }
}

