/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.graph;

import java.io.Serializable;
import java.util.Objects;
import org.apache.cayenne.reflect.ArcProperty;

public class ArcId
implements Serializable {
    private static final long serialVersionUID = -3712846298213425259L;
    private final String forwardArc;
    private final String reverseArc;

    public ArcId(ArcProperty property) {
        this.forwardArc = property.getName();
        this.reverseArc = property.getComplimentaryReverseArc() == null ? "db:" + property.getComplimentaryReverseDbRelationshipPath() : property.getComplimentaryReverseArc().getName();
    }

    public ArcId(String forwardArc, String reverseArc) {
        this.forwardArc = Objects.requireNonNull(forwardArc);
        this.reverseArc = Objects.requireNonNull(reverseArc);
    }

    public String getForwardArc() {
        return this.forwardArc;
    }

    public String getReverseArc() {
        return this.reverseArc;
    }

    public ArcId getReverseId() {
        return new ArcId(this.reverseArc, this.forwardArc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArcId arcId = (ArcId)o;
        if (!this.forwardArc.equals(arcId.forwardArc)) {
            return false;
        }
        return this.reverseArc.equals(arcId.reverseArc);
    }

    public int hashCode() {
        int result = this.forwardArc.hashCode();
        result = 31 * result + this.reverseArc.hashCode();
        return result;
    }

    public String toString() {
        return this.forwardArc;
    }
}

