/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneDialog;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.PanelFactory;

public class DbRelationshipDialogView
extends CayenneDialog {
    private JTextField name;
    private JComboBox<String> targetEntities;
    private JCheckBox toDepPk;
    private JCheckBox toMany;
    private JTextField comment;
    private JLabel sourceName;
    private JTextField reverseName;
    private CayenneTable table;
    private TableColumnPreferences tablePreferences;
    private JButton addButton;
    private JButton removeButton;
    private JButton saveButton;
    private JButton cancelButton;
    private boolean cancelPressed;

    public DbRelationshipDialogView() {
        super(Application.getFrame(), "Create dbRelationship", true);
        this.initView();
        this.pack();
        this.centerWindow();
    }

    private void initView() {
        this.name = new JTextField(25);
        this.targetEntities = new JComboBox();
        this.toDepPk = new JCheckBox();
        this.toMany = new JCheckBox();
        this.comment = new JTextField(25);
        this.sourceName = new JLabel();
        this.reverseName = new JTextField(25);
        this.addButton = new JButton("Add");
        this.removeButton = new JButton("Remove");
        this.saveButton = new JButton("Done");
        this.cancelButton = new JButton("Cancel");
        this.table = new AttributeTable();
        this.table.getSelectionModel().setSelectionMode(0);
        this.tablePreferences = new TableColumnPreferences(this.getClass(), "dbentity/dbjoinTable");
        this.getRootPane().setDefaultButton(this.saveButton);
        this.getContentPane().setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("right:max(50dlu;pref), 3dlu, fill:min(150dlu;pref), 3dlu, fill:min(50dlu;pref)", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, top:14dlu, 3dlu, top:p:grow"));
        builder.setDefaultDialogBorder();
        builder.addSeparator("Create dbRelationship", cc.xywh(1, 1, 5, 1));
        builder.addLabel("Relationship Name:", cc.xy(1, 3));
        builder.add((Component)this.name, cc.xywh(3, 3, 1, 1));
        builder.addLabel("Source Entity:", cc.xy(1, 5));
        builder.add((Component)this.sourceName, cc.xywh(3, 5, 1, 1));
        builder.addLabel("Target Entity:", cc.xy(1, 7));
        builder.add(this.targetEntities, cc.xywh(3, 7, 1, 1));
        builder.addLabel("To Dep PK:", cc.xy(1, 9));
        builder.add((Component)this.toDepPk, cc.xywh(3, 9, 1, 1));
        builder.addLabel("To Many:", cc.xy(1, 11));
        builder.add((Component)this.toMany, cc.xywh(3, 11, 1, 1));
        builder.addLabel("Comment:", cc.xy(1, 13));
        builder.add((Component)this.comment, cc.xywh(3, 13, 1, 1));
        builder.addSeparator("DbRelationship Information", cc.xywh(1, 15, 5, 1));
        builder.addLabel("Reverse Relationship Name:", cc.xy(1, 17));
        builder.add((Component)this.reverseName, cc.xywh(3, 17, 1, 1));
        builder.addSeparator("Joins", cc.xywh(1, 19, 5, 1));
        builder.add((Component)new JScrollPane(this.table), cc.xywh(1, 21, 3, 3, "fill, fill"));
        JPanel joinButtons = new JPanel(new FlowLayout(3));
        joinButtons.add(this.addButton);
        joinButtons.add(this.removeButton);
        builder.add((Component)joinButtons, cc.xywh(5, 21, 1, 3));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        JButton[] buttons = new JButton[]{this.cancelButton, this.saveButton};
        this.getContentPane().add((Component)PanelFactory.createButtonPanel(buttons), "South");
    }

    public void enableOptions(boolean enable) {
        this.saveButton.setEnabled(enable);
        this.reverseName.setEnabled(enable);
        this.addButton.setEnabled(enable);
        this.removeButton.setEnabled(enable);
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this.cancelPressed) {
            return;
        }
        super.setVisible(b);
    }

    public JTextField getNameField() {
        return this.name;
    }

    public JComboBox<String> getTargetEntities() {
        return this.targetEntities;
    }

    public JCheckBox getToDepPk() {
        return this.toDepPk;
    }

    public JCheckBox getToMany() {
        return this.toMany;
    }

    public JTextField getComment() {
        return this.comment;
    }

    public JLabel getSourceName() {
        return this.sourceName;
    }

    public JTextField getReverseName() {
        return this.reverseName;
    }

    public CayenneTable getTable() {
        return this.table;
    }

    public TableColumnPreferences getTablePreferences() {
        return this.tablePreferences;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    public void setCancelPressed(boolean cancelPressed) {
        this.cancelPressed = cancelPressed;
    }

    final class AttributeTable
    extends CayenneTable {
        final Dimension preferredSize = new Dimension(203, 100);

        AttributeTable() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.preferredSize;
        }
    }
}

