/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.RootSelectionHandler;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

abstract class BaseQueryMainTab
extends JPanel {
    protected ProjectController mediator;
    protected TextAdapter name;
    protected JComboBox<ObjEntity> queryRoot;

    BaseQueryMainTab(ProjectController mediator) {
        this.mediator = mediator;
    }

    protected void initQueryRoot() {
        this.queryRoot = Application.getWidgetFactory().createComboBox();
        AutoCompletion.enable(this.queryRoot);
        this.queryRoot.setRenderer(CellRenderers.listRendererWithIcons());
        RootSelectionHandler rootHandler = new RootSelectionHandler(this);
        this.queryRoot.addActionListener(rootHandler);
        this.queryRoot.addFocusListener(rootHandler);
        this.queryRoot.getEditor().getEditorComponent().addFocusListener(rootHandler);
    }

    public TextAdapter getNameField() {
        return this.name;
    }

    public JComboBox<ObjEntity> getQueryRoot() {
        return this.queryRoot;
    }

    public ProjectController getMediator() {
        return this.mediator;
    }

    void setQueryName(String newName) {
        QueryDescriptor query;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((query = this.getQuery()) == null) {
            return;
        }
        if (Util.nullSafeEquals(newName, query.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("SelectQuery name is required.", new Object[0]);
        }
        DataMap map = this.mediator.getCurrentDataMap();
        QueryDescriptor matchingQuery = map.getQueryDescriptor(newName);
        if (matchingQuery == null) {
            QueryEvent e = new QueryEvent((Object)this, query, query.getName());
            ProjectUtil.setQueryName(map, query, newName);
            this.mediator.fireQueryEvent(e);
        } else if (matchingQuery != query) {
            throw new ValidationException("There is another query named '" + newName + "'. Use a different name.", new Object[0]);
        }
    }

    abstract QueryDescriptor getQuery();
}

