/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.DataMapView;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorController;
import org.apache.cayenne.modeler.editor.cgen.domain.CgenTab;
import org.apache.cayenne.modeler.editor.dbimport.DbImportView;
import org.apache.cayenne.modeler.editor.dbimport.domain.DbImportTab;

public class DataMapTabbedView
extends JTabbedPane {
    ProjectController mediator;
    private DbImportView dbImportView;
    private JScrollPane dbImportScrollPane;
    private CodeGeneratorController codeGeneratorController;
    private JScrollPane cgenView;

    public DataMapTabbedView(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    private void initView() {
        this.setTabPlacement(1);
        JScrollPane dataMapScrollPane = new JScrollPane(new DataMapView(this.mediator));
        this.dbImportView = new DbImportView(this.mediator);
        this.dbImportScrollPane = new JScrollPane(this.dbImportView);
        this.codeGeneratorController = new CodeGeneratorController(this.mediator);
        this.cgenView = new JScrollPane(this.codeGeneratorController.getView());
        this.addTab("DataMap", dataMapScrollPane);
        this.addTab("DB Import", this.dbImportScrollPane);
        this.addTab("Class Generation", this.cgenView);
        this.addChangeListener(tab -> {
            if (this.isCgenTabActive()) {
                this.codeGeneratorController.initFromModel();
            } else if (this.isDbImportTabActive()) {
                this.dbImportView.initFromModel();
            }
        });
        this.mediator.addDataMapDisplayListener(e -> {
            if (e.getSource() instanceof CgenTab) {
                this.setSelectedComponent(this.cgenView);
            } else if (e.getSource() instanceof DbImportTab) {
                this.setSelectedComponent(this.dbImportScrollPane);
            } else if (this.isCgenTabActive() || this.isDbImportTabActive()) {
                this.fireStateChanged();
            }
        });
    }

    private boolean isCgenTabActive() {
        return this.getSelectedComponent() == this.cgenView;
    }

    private boolean isDbImportTabActive() {
        return this.getSelectedComponent() == this.dbImportScrollPane;
    }
}

