/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.modeler.editor.dbimport.tree.Node;
import org.apache.cayenne.modeler.editor.dbimport.tree.Status;
import org.apache.cayenne.modeler.editor.dbimport.tree.TableNode;

class ColumnNode
extends Node<TableNode<?>> {
    ColumnNode(String name, TableNode<?> parent) {
        super(name, parent);
    }

    @Override
    public Status getStatus(ReverseEngineering config) {
        Status parentStatus = ((TableNode)this.getParent()).getStatus(config);
        if (parentStatus != Status.INCLUDE) {
            return parentStatus;
        }
        List<FilterContainer> containers = ((TableNode)this.getParent()).getContainers(config);
        ArrayList<IncludeColumn> includeColumns = new ArrayList<IncludeColumn>();
        ArrayList<ExcludeColumn> excludeColumns = new ArrayList<ExcludeColumn>();
        for (FilterContainer container : containers) {
            if (container == null) continue;
            IncludeTable table = ((TableNode)this.getParent()).getIncludeTable(container.getIncludeTables());
            if (table != null) {
                includeColumns.addAll(table.getIncludeColumns());
                excludeColumns.addAll(table.getExcludeColumns());
            }
            includeColumns.addAll(container.getIncludeColumns());
            excludeColumns.addAll(container.getExcludeColumns());
        }
        return this.includesColumn(includeColumns, excludeColumns);
    }

    private Status includesColumn(Collection<IncludeColumn> includeColumns, Collection<ExcludeColumn> excludeColumns) {
        if (includeColumns.isEmpty() && excludeColumns.isEmpty()) {
            return Status.INCLUDE;
        }
        if (!includeColumns.isEmpty() && this.getIncludeColumn(includeColumns) != null) {
            return Status.INCLUDE;
        }
        if (!excludeColumns.isEmpty()) {
            if (this.getExcludeColumn(excludeColumns) != null) {
                return Status.EXCLUDE_EXPLICIT;
            }
            return includeColumns.isEmpty() ? Status.INCLUDE : Status.EXCLUDE_IMPLICIT;
        }
        return Status.EXCLUDE_IMPLICIT;
    }

    IncludeColumn getIncludeColumn(Collection<IncludeColumn> includeColumns) {
        for (IncludeColumn column : includeColumns) {
            if (!this.getName().matches(column.getPattern())) continue;
            return column;
        }
        return null;
    }

    ExcludeColumn getExcludeColumn(Collection<ExcludeColumn> excludeColumns) {
        for (ExcludeColumn column : excludeColumns) {
            if (!this.getName().matches(column.getPattern())) continue;
            return column;
        }
        return null;
    }
}

