/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import org.apache.cayenne.modeler.undo.JComboBoxUndoListener;
import org.apache.cayenne.validation.ValidationException;

public abstract class ComboBoxAdapter<T> {
    private JComboBox<T> comboBox;
    private ActionListener listener;
    private JComboBoxUndoListener undoListener;

    protected ComboBoxAdapter(JComboBox<T> comboBox) {
        this.comboBox = comboBox;
        this.listener = e -> this.updateModel();
        this.undoListener = new JComboBoxUndoListener();
        comboBox.addActionListener(this.listener);
        comboBox.addItemListener(this.undoListener);
    }

    public void setItem(Object item) {
        this.comboBox.removeActionListener(this.listener);
        this.comboBox.removeItemListener(this.undoListener);
        try {
            this.comboBox.setSelectedItem(item);
        }
        finally {
            this.comboBox.addActionListener(this.listener);
            this.comboBox.addItemListener(this.undoListener);
        }
    }

    public JComboBox<T> getComboBox() {
        return this.comboBox;
    }

    protected abstract void updateModel(T var1) throws ValidationException;

    public void updateModel() {
        this.updateModel(this.comboBox.getSelectedItem());
    }
}

