/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util.commons;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.cayenne.util.commons.IteratorChain;

public class CompositeCollection<E>
implements Collection<E> {
    protected ArrayList<Collection<E>> all = new ArrayList();

    @Override
    public int size() {
        int size = 0;
        for (Collection<E> collection : this.all) {
            size += collection.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<E> collection : this.all) {
            if (collection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object obj) {
        for (Collection<E> collection : this.all) {
            if (collection.contains(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.all.isEmpty()) {
            return Collections.emptyIterator();
        }
        IteratorChain<E> chain = new IteratorChain<E>();
        for (Collection<E> collection : this.all) {
            chain.addIterator(collection.iterator());
        }
        return chain;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        for (Collection<E> collection : this.all) {
            for (E o : collection) {
                result[i++] = o;
            }
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        Object[] result = array.length >= size ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        int offset = 0;
        for (Collection<E> collection : this.all) {
            for (E e : collection) {
                result[offset++] = e;
            }
        }
        if (result.length > size) {
            result[size] = null;
        }
        return result;
    }

    @Override
    public boolean add(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        for (Object o : coll) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        if (coll.size() == 0) {
            return false;
        }
        boolean changed = false;
        for (Collection<E> collection : this.all) {
            changed = collection.removeAll(coll) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        boolean changed = false;
        for (Collection<E> collection : this.all) {
            changed = collection.retainAll(coll) || changed;
        }
        return changed;
    }

    @Override
    public void clear() {
        for (Collection<E> collection : this.all) {
            collection.clear();
        }
    }

    public void addComposited(Collection<E> c) {
        this.all.add(c);
    }

    public void removeComposited(Collection<E> coll) {
        this.all.remove(coll);
    }

    public Collection<Collection<E>> getCollections() {
        return Collections.unmodifiableCollection(this.all);
    }
}

