/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeSet;
import org.apache.cayenne.dbsync.merge.MergerDictionary;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.TableFilter;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;

class DbRelationshipDictionary
extends MergerDictionary<DbRelationship> {
    private final DbEntity container;
    private final FiltersConfig filtersConfig;

    DbRelationshipDictionary(DbEntity container, FiltersConfig filtersConfig) {
        this.container = container;
        this.filtersConfig = filtersConfig;
    }

    @Override
    String getName(DbRelationship entity) {
        return new Signature(entity).getName();
    }

    @Override
    Collection<DbRelationship> getAll() {
        return this.filter();
    }

    private Collection<DbRelationship> filter() {
        if (this.filtersConfig == null) {
            return this.container.getRelationships();
        }
        LinkedList<DbRelationship> existingFiltered = new LinkedList<DbRelationship>();
        TableFilter tableFilter = this.filtersConfig.tableFilter(this.container.getCatalog(), this.container.getSchema());
        if (tableFilter != null && tableFilter.isIncludeTable(this.container.getName())) {
            PatternFilter patternFilter = tableFilter.getIncludeTableRelationshipFilter(this.container.getName());
            for (DbRelationship rel : this.container.getRelationships()) {
                if (!patternFilter.isIncluded(rel.getName())) continue;
                existingFiltered.add(rel);
            }
        }
        return existingFiltered;
    }

    private static class Signature {
        private final DbRelationship relationship;
        private String[] joinSignature;

        private Signature(DbRelationship relationship) {
            this.relationship = relationship;
            this.build();
        }

        public String getName() {
            if (this.joinSignature.length == 0) {
                return "";
            }
            String name = this.joinSignature[0];
            for (int i = 1; i < this.joinSignature.length; ++i) {
                name = name + "|" + this.joinSignature[i];
            }
            return name;
        }

        private void build() {
            TreeSet<String> joins = new TreeSet<String>();
            for (DbJoin join : this.relationship.getJoins()) {
                joins.add(this.relationship.getSourceEntityName() + "." + join.getSourceName() + ">" + this.relationship.getTargetEntityName() + "." + join.getTargetName());
            }
            this.joinSignature = joins.toArray(new String[0]);
        }
    }
}

