/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManyToManyCandidateEntity {
    private static final Logger LOG = LoggerFactory.getLogger(ManyToManyCandidateEntity.class);
    private final ObjEntity joinEntity;
    private final DbRelationship dbRel1;
    private final DbRelationship dbRel2;
    private final ObjEntity entity1;
    private final ObjEntity entity2;
    private final DbRelationship reverseRelationship1;
    private final DbRelationship reverseRelationship2;

    private ManyToManyCandidateEntity(ObjEntity entityValue, List<ObjRelationship> relationships) {
        this.joinEntity = entityValue;
        ObjRelationship rel1 = relationships.get(0);
        ObjRelationship rel2 = relationships.get(1);
        this.dbRel1 = (DbRelationship)rel1.getDbRelationships().get(0);
        this.dbRel2 = (DbRelationship)rel2.getDbRelationships().get(0);
        this.reverseRelationship1 = this.dbRel1.getReverseRelationship();
        this.reverseRelationship2 = this.dbRel2.getReverseRelationship();
        this.entity1 = rel1.getTargetEntity();
        this.entity2 = rel2.getTargetEntity();
    }

    public static ManyToManyCandidateEntity build(ObjEntity joinEntity) {
        ArrayList<ObjRelationship> relationships = new ArrayList<ObjRelationship>(joinEntity.getRelationships());
        if (relationships.size() != 2 || ((ObjRelationship)relationships.get(0)).getDbRelationships().isEmpty() || ((ObjRelationship)relationships.get(1)).getDbRelationships().isEmpty()) {
            return null;
        }
        ManyToManyCandidateEntity candidateEntity = new ManyToManyCandidateEntity(joinEntity, relationships);
        if (candidateEntity.isManyToMany()) {
            return candidateEntity;
        }
        return null;
    }

    private boolean isManyToMany() {
        boolean isNotHaveAttributes = this.joinEntity.getAttributes().size() == 0;
        return isNotHaveAttributes && this.reverseRelationship1 != null && this.reverseRelationship1.isToDependentPK() && this.reverseRelationship2 != null && this.reverseRelationship2.isToDependentPK() && this.entity1 != null && this.entity2 != null;
    }

    private void addFlattenedRelationship(ObjectNameGenerator nameGenerator, ObjEntity srcEntity, ObjEntity dstEntity, DbRelationship rel1, DbRelationship rel2) {
        if (rel1.getSourceAttributes().isEmpty() && rel2.getTargetAttributes().isEmpty()) {
            LOG.warn("Wrong call ManyToManyCandidateEntity.addFlattenedRelationship(... , " + srcEntity.getName() + ", " + dstEntity.getName() + ", ...)");
            return;
        }
        ObjRelationship newRelationship = new ObjRelationship();
        newRelationship.setName(NameBuilder.builder((ConfigurationNode)newRelationship, (ConfigurationNode)srcEntity).baseName(nameGenerator.relationshipName(rel1, rel2)).name());
        newRelationship.setSourceEntity((Entity)srcEntity);
        newRelationship.setTargetEntityName((Entity)dstEntity);
        newRelationship.addDbRelationship(rel1);
        newRelationship.addDbRelationship(rel2);
        srcEntity.addRelationship((Relationship)newRelationship);
    }

    public void optimizeRelationships(ObjectNameGenerator nameGenerator) {
        this.entity1.removeRelationship(this.reverseRelationship1.getName());
        this.entity2.removeRelationship(this.reverseRelationship2.getName());
        this.addFlattenedRelationship(nameGenerator, this.entity1, this.entity2, this.reverseRelationship1, this.dbRel2);
        this.addFlattenedRelationship(nameGenerator, this.entity2, this.entity1, this.reverseRelationship2, this.dbRel1);
    }
}

