/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.hessian;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.SerializerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.remote.hessian.CayenneSerializerFactory;
import org.apache.cayenne.util.Util;

public class HessianConfig {
    public static SerializerFactory createFactory(String[] factoryNames, EntityResolver resolver) {
        return HessianConfig.createFactory(factoryNames, resolver, Collections.emptyList());
    }

    public static SerializerFactory createFactory(String[] factoryNames, EntityResolver resolver, Collection<String> additionalWhitelist) {
        CayenneSerializerFactory factory = new CayenneSerializerFactory();
        factory.setAllowNonSerializable(true);
        ArrayList<String> whitelist = new ArrayList<String>(additionalWhitelist);
        if (resolver != null) {
            whitelist.add("org.apache.cayenne.*");
            for (DataMap dataMap : resolver.getDataMaps()) {
                whitelist.add(dataMap.getDefaultPackage() + ".*");
            }
        }
        if (!whitelist.isEmpty()) {
            for (String pattern : whitelist) {
                factory.getClassFactory().allow(pattern);
            }
            factory.getClassFactory().setWhitelist(true);
        }
        if (factoryNames != null && factoryNames.length > 0) {
            for (String factoryName : factoryNames) {
                try {
                    factory.addFactory(HessianConfig.loadFactory(factoryName, resolver));
                }
                catch (Exception e) {
                    throw new CayenneRuntimeException("Error configuring factory class " + factoryName, (Throwable)e, new Object[0]);
                }
            }
        }
        return factory;
    }

    static AbstractSerializerFactory loadFactory(String factoryName, EntityResolver resolver) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> factoryClass = Class.forName(factoryName, true, loader);
        if (!AbstractSerializerFactory.class.isAssignableFrom(factoryClass)) {
            throw new IllegalArgumentException(factoryClass + " is not a AbstractSerializerFactory");
        }
        Constructor<?> c = factoryClass.getDeclaredConstructor(new Class[0]);
        if (!Util.isAccessible(c)) {
            c.setAccessible(true);
        }
        AbstractSerializerFactory object = (AbstractSerializerFactory)c.newInstance(new Object[0]);
        if (resolver != null) {
            try {
                Method setter = factoryClass.getDeclaredMethod("setEntityResolver", EntityResolver.class);
                if (!Util.isAccessible((Member)setter)) {
                    setter.setAccessible(true);
                }
                setter.invoke((Object)object, resolver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }
}

