/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.mutable.MutableShort;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MutableShortTest
extends AbstractLangTest {
    MutableShortTest() {
    }

    @Test
    void testAddAndGetValueObject() {
        MutableShort mutableShort = new MutableShort(0);
        short result = mutableShort.addAndGet((Number)1);
        Assertions.assertEquals((short)1, (short)result);
        Assertions.assertEquals((short)1, (short)mutableShort.shortValue());
    }

    @Test
    void testAddAndGetValuePrimitive() {
        MutableShort mutableShort = new MutableShort(0);
        short result = mutableShort.addAndGet((short)1);
        Assertions.assertEquals((short)1, (short)result);
        Assertions.assertEquals((short)1, (short)mutableShort.shortValue());
    }

    @Test
    void testAddValueObject() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.add((Number)1);
        Assertions.assertEquals((short)2, (short)mutNum.shortValue());
    }

    @Test
    void testAddValuePrimitive() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.add((short)1);
        Assertions.assertEquals((short)2, (short)mutNum.shortValue());
    }

    @Test
    void testCompareTo() {
        MutableShort mutNum = new MutableShort(0);
        Assertions.assertEquals((int)0, (int)mutNum.compareTo(new MutableShort(0)));
        Assertions.assertEquals((int)1, (int)mutNum.compareTo(new MutableShort(-1)));
        Assertions.assertEquals((int)-1, (int)mutNum.compareTo(new MutableShort(1)));
        LangAssertions.assertNullPointerException(() -> mutNum.compareTo(null));
    }

    @Test
    void testConstructors() {
        Assertions.assertEquals((short)0, (short)new MutableShort().shortValue());
        Assertions.assertEquals((short)1, (short)new MutableShort(1).shortValue());
        Assertions.assertEquals((short)2, (short)new MutableShort((Number)2).shortValue());
        Assertions.assertEquals((short)3, (short)new MutableShort((Number)new MutableShort(3)).shortValue());
        Assertions.assertEquals((short)2, (short)new MutableShort("2").shortValue());
        LangAssertions.assertNullPointerException(() -> new MutableShort((Number)null));
    }

    @Test
    void testDecrement() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.decrement();
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    void testDecrementAndGet() {
        MutableShort mutNum = new MutableShort(1);
        short result = mutNum.decrementAndGet();
        Assertions.assertEquals((int)0, (int)result);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    void testEquals() {
        MutableShort mutNumA = new MutableShort(0);
        MutableShort mutNumB = new MutableShort(0);
        MutableShort mutNumC = new MutableShort(1);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumB);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumB);
        Assertions.assertNotEquals((Object)mutNumA, (Object)mutNumC);
        Assertions.assertNotEquals((Object)mutNumB, (Object)mutNumC);
        Assertions.assertEquals((Object)mutNumC, (Object)mutNumC);
        Assertions.assertNotEquals(null, (Object)mutNumA);
        Assertions.assertNotEquals((Object)mutNumA, (Object)0);
        Assertions.assertNotEquals((Object)"0", (Object)mutNumA);
    }

    @Test
    void testGetAndAddValueObject() {
        MutableShort mutableShort = new MutableShort(0);
        short result = mutableShort.getAndAdd((Number)1);
        Assertions.assertEquals((short)0, (short)result);
        Assertions.assertEquals((short)1, (short)mutableShort.shortValue());
    }

    @Test
    void testGetAndAddValuePrimitive() {
        MutableShort mutableShort = new MutableShort(0);
        short result = mutableShort.getAndAdd((short)1);
        Assertions.assertEquals((short)0, (short)result);
        Assertions.assertEquals((short)1, (short)mutableShort.shortValue());
    }

    @Test
    void testGetAndDecrement() {
        MutableShort mutNum = new MutableShort(1);
        short result = mutNum.getAndDecrement();
        Assertions.assertEquals((int)1, (int)result);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    void testGetAndIncrement() {
        MutableShort mutNum = new MutableShort(1);
        short result = mutNum.getAndIncrement();
        Assertions.assertEquals((int)1, (int)result);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    void testGetSet() {
        MutableShort mutNum = new MutableShort(0);
        Assertions.assertEquals((short)0, (short)new MutableShort().shortValue());
        Assertions.assertEquals((Object)0, (Object)new MutableShort().get());
        Assertions.assertEquals((Short)0, (Short)new MutableShort().getValue());
        mutNum.setValue((short)1);
        Assertions.assertEquals((short)1, (short)mutNum.shortValue());
        Assertions.assertEquals((Object)1, (Object)mutNum.get());
        Assertions.assertEquals((Short)1, (Short)mutNum.getValue());
        mutNum.setValue((Number)2);
        Assertions.assertEquals((short)2, (short)mutNum.shortValue());
        Assertions.assertEquals((Object)2, (Object)mutNum.get());
        Assertions.assertEquals((Short)2, (Short)mutNum.getValue());
        mutNum.setValue((Number)new MutableShort(3));
        Assertions.assertEquals((short)3, (short)mutNum.shortValue());
        Assertions.assertEquals((Object)3, (Object)mutNum.get());
        Assertions.assertEquals((Short)3, (Short)mutNum.getValue());
        LangAssertions.assertNullPointerException(() -> mutNum.setValue(null));
    }

    @Test
    void testHashCode() {
        MutableShort mutNumA = new MutableShort(0);
        MutableShort mutNumB = new MutableShort(0);
        MutableShort mutNumC = new MutableShort(1);
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumA.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumB.hashCode());
        Assertions.assertNotEquals((int)mutNumA.hashCode(), (int)mutNumC.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)Short.valueOf((short)0).hashCode());
    }

    @Test
    void testIncrement() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.increment();
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    void testIncrementAndGet() {
        MutableShort mutNum = new MutableShort(1);
        short result = mutNum.incrementAndGet();
        Assertions.assertEquals((int)2, (int)result);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    void testPrimitiveValues() {
        MutableShort mutNum = new MutableShort(1);
        Assertions.assertEquals((float)1.0f, (float)mutNum.floatValue());
        Assertions.assertEquals((double)1.0, (double)mutNum.doubleValue());
        Assertions.assertEquals((byte)1, (byte)mutNum.byteValue());
        Assertions.assertEquals((short)1, (short)mutNum.shortValue());
        Assertions.assertEquals((int)1, (int)mutNum.intValue());
        Assertions.assertEquals((long)1L, (long)mutNum.longValue());
    }

    @Test
    void testSubtractValueObject() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.subtract((Number)1);
        Assertions.assertEquals((short)0, (short)mutNum.shortValue());
    }

    @Test
    void testSubtractValuePrimitive() {
        MutableShort mutNum = new MutableShort(1);
        mutNum.subtract((short)1);
        Assertions.assertEquals((short)0, (short)mutNum.shortValue());
    }

    @Test
    void testToShort() {
        Assertions.assertEquals((Short)0, (Short)new MutableShort(0).toShort());
        Assertions.assertEquals((Short)123, (Short)new MutableShort(123).toShort());
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"0", (Object)new MutableShort(0).toString());
        Assertions.assertEquals((Object)"10", (Object)new MutableShort(10).toString());
        Assertions.assertEquals((Object)"-123", (Object)new MutableShort(-123).toString());
    }
}

