/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.noop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.AbstractLogTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.NoOpLog;

public class NoOpLogTestCase
extends AbstractLogTest {
    private void checkLog(Log log) {
        NoOpLogTestCase.assertNotNull((String)"Log exists", (Object)log);
        NoOpLogTestCase.assertEquals((String)"Log class", (String)"org.apache.commons.logging.impl.NoOpLog", (String)log.getClass().getName());
        NoOpLogTestCase.assertFalse((boolean)log.isTraceEnabled());
        NoOpLogTestCase.assertFalse((boolean)log.isDebugEnabled());
        NoOpLogTestCase.assertFalse((boolean)log.isInfoEnabled());
        NoOpLogTestCase.assertFalse((boolean)log.isWarnEnabled());
        NoOpLogTestCase.assertFalse((boolean)log.isErrorEnabled());
        NoOpLogTestCase.assertFalse((boolean)log.isFatalEnabled());
    }

    @Override
    public Log getLogObject() {
        return new NoOpLog(((Object)((Object)this)).getClass().getName());
    }

    public void setUp() throws Exception {
        LogFactory.releaseAll();
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }

    public void tearDown() {
        LogFactory.releaseAll();
        System.getProperties().remove("org.apache.commons.logging.Log");
    }

    public void testSerializable() throws Exception {
        Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
        this.checkLog(log);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(log);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        log = (Log)ois.readObject();
        ois.close();
        this.checkLog(log);
    }
}

