/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.builder;

import io.undertow.UndertowLogger;
import io.undertow.attribute.ConstantExchangeAttribute;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.SetAttributeHandler;
import io.undertow.server.handlers.builder.HandlerBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class RewriteHandlerBuilder
implements HandlerBuilder {
    @Override
    public String name() {
        return "rewrite";
    }

    @Override
    public Map<String, Class<?>> parameters() {
        return Collections.singletonMap("value", ExchangeAttribute.class);
    }

    @Override
    public Set<String> requiredParameters() {
        return Collections.singleton("value");
    }

    @Override
    public String defaultParameter() {
        return "value";
    }

    @Override
    public HandlerWrapper build(Map<String, Object> config) {
        final ExchangeAttribute configValue = (ExchangeAttribute)config.get("value");
        ExchangeAttribute tmpValue = null;
        tmpValue = configValue instanceof ConstantExchangeAttribute ? new ConstantExchangeAttribute(this.normalize(configValue.readAttribute(null))) : new ExchangeAttribute(){

            @Override
            public String readAttribute(HttpServerExchange exchange) {
                return RewriteHandlerBuilder.this.normalize(configValue.readAttribute(exchange));
            }

            @Override
            public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
                throw new ReadOnlyAttributeException("constant", newValue);
            }

            public String toString() {
                return "NDA";
            }
        };
        final ExchangeAttribute value = tmpValue;
        return new HandlerWrapper(){

            @Override
            public HttpHandler wrap(HttpHandler handler) {
                return new SetAttributeHandler(handler, ExchangeAttributes.relativePath(), value){

                    @Override
                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                        UndertowLogger.PREDICATE_LOGGER.debugf("Request rewritten to [%s] for %s.", this.getValue().readAttribute(exchange), exchange);
                        super.handleRequest(exchange);
                    }

                    @Override
                    public String toString() {
                        return "rewrite( '" + this.getValue().toString() + "' )";
                    }
                };
            }
        };
    }

    private String normalize(String readAttribute) {
        if (readAttribute.startsWith("/")) {
            return readAttribute;
        }
        return "/" + readAttribute;
    }
}

