/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.ssl;

import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.ssl.DisableEncryptWriteRequest;
import org.apache.mina.filter.ssl.EncryptedWriteRequest;
import org.apache.mina.filter.ssl.SSLHandlerG0;
import org.apache.mina.filter.ssl.SslHandler;
import org.apache.mina.util.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslFilter
extends IoFilterAdapter {
    public static final AttributeKey SSL_SECURED = new AttributeKey(SslFilter.class, "status");
    protected static final AttributeKey SSL_HANDLER = new AttributeKey(SslFilter.class, "handler");
    protected static final Logger LOGGER = LoggerFactory.getLogger(SslFilter.class);
    protected static final Executor EXECUTOR = new ThreadPoolExecutor(2, 2, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), new BasicThreadFactory("ssl-exec", true));
    protected final SSLContext sslContext;
    protected boolean needClientAuth = false;
    protected boolean wantClientAuth = false;
    protected String[] enabledCipherSuites;
    protected String[] enabledProtocols;

    public SslFilter(SSLContext sslContext) {
        Objects.requireNonNull(sslContext, "ssl must not be null");
        this.sslContext = sslContext;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String ... enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String ... enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    @Override
    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter next) throws Exception {
        if (parent.contains(SslFilter.class)) {
            throw new IllegalStateException("Only one SSL filter is permitted in a chain");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding the SSL Filter {} to the chain", (Object)name);
        }
    }

    @Override
    public void onPostAdd(IoFilterChain parent, String name, IoFilter.NextFilter next) throws Exception {
        IoSession session = parent.getSession();
        if (session.isConnected()) {
            this.onConnected(next, session);
        }
        super.onPostAdd(parent, name, next);
    }

    @Override
    public void onPreRemove(IoFilterChain parent, String name, IoFilter.NextFilter next) throws Exception {
        IoSession session = parent.getSession();
        this.onClose(next, session, false);
    }

    protected synchronized void onConnected(IoFilter.NextFilter next, IoSession session) throws SSLException {
        SslHandler sslHandler = (SslHandler)SslHandler.class.cast(session.getAttribute(SSL_HANDLER));
        if (sslHandler == null) {
            InetSocketAddress s = (InetSocketAddress)InetSocketAddress.class.cast(session.getRemoteAddress());
            SSLEngine sslEngine = this.createEngine(session, s);
            sslHandler = new SSLHandlerG0(sslEngine, EXECUTOR, session);
            session.setAttribute(SSL_HANDLER, sslHandler);
        }
        sslHandler.open(next);
    }

    protected synchronized void onClose(IoFilter.NextFilter next, IoSession session, boolean linger) throws SSLException {
        session.removeAttribute(SSL_SECURED);
        SslHandler sslHandler = (SslHandler)SslHandler.class.cast(session.removeAttribute(SSL_HANDLER));
        if (sslHandler != null) {
            sslHandler.close(next, linger);
        }
    }

    protected SSLEngine createEngine(IoSession session, InetSocketAddress addr) {
        SSLEngine sslEngine;
        SSLEngine sSLEngine = sslEngine = addr != null ? this.sslContext.createSSLEngine(addr.getHostString(), addr.getPort()) : this.sslContext.createSSLEngine();
        if (this.wantClientAuth) {
            sslEngine.setWantClientAuth(true);
        }
        if (this.needClientAuth) {
            sslEngine.setNeedClientAuth(true);
        }
        if (this.enabledCipherSuites != null) {
            sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        sslEngine.setUseClientMode(!session.isServer());
        return sslEngine;
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter next, IoSession session) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("session {} openend", (Object)session);
        }
        this.onConnected(next, session);
        super.sessionOpened(next, session);
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter next, IoSession session) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("session {} closed", (Object)session);
        }
        this.onClose(next, session, false);
        super.sessionClosed(next, session);
    }

    @Override
    public void messageReceived(IoFilter.NextFilter next, IoSession session, Object message) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("session {} received {}", (Object)session, message);
        }
        SslHandler sslHandler = (SslHandler)SslHandler.class.cast(session.getAttribute(SSL_HANDLER));
        sslHandler.receive(next, (IoBuffer)IoBuffer.class.cast(message));
    }

    @Override
    public void messageSent(IoFilter.NextFilter next, IoSession session, WriteRequest request) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("session {} ack {}", (Object)session, (Object)request);
        }
        if (request instanceof EncryptedWriteRequest) {
            EncryptedWriteRequest encryptedWriteRequest = (EncryptedWriteRequest)EncryptedWriteRequest.class.cast(request);
            SslHandler sslHandler = (SslHandler)SslHandler.class.cast(session.getAttribute(SSL_HANDLER));
            sslHandler.ack(next, request);
            if (encryptedWriteRequest.getOriginalRequest() != encryptedWriteRequest) {
                next.messageSent(session, encryptedWriteRequest.getOriginalRequest());
            }
        } else {
            super.messageSent(next, session, request);
        }
    }

    @Override
    public void filterWrite(IoFilter.NextFilter next, IoSession session, WriteRequest request) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("session {} write {}", (Object)session, (Object)request);
        }
        if (request instanceof EncryptedWriteRequest || request instanceof DisableEncryptWriteRequest) {
            super.filterWrite(next, session, request);
        } else {
            SslHandler sslHandler = (SslHandler)SslHandler.class.cast(session.getAttribute(SSL_HANDLER));
            sslHandler.write(next, request);
        }
    }
}

