/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.transaction.impl;

import io.netty.util.collection.IntObjectHashMap;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionTimeoutException;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.OperationConsistencyLevel;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImpl
implements Transaction {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<TransactionOperation> operations;
    private List<TransactionOperation> storeOperations;
    private IntObjectHashMap properties = null;
    protected final StorageManager storageManager;
    protected final Xid xid;
    protected final long id;
    protected volatile Transaction.State state = Transaction.State.ACTIVE;
    private ActiveMQException exception;
    private final Object timeoutLock = new Object();
    private final long createTime;
    protected volatile boolean containsPersistent;
    private int timeoutSeconds = -1;
    private Object protocolData;
    private boolean async;
    private Runnable afterWired;
    private int delayed;
    private Runnable delayedRunnable;

    @Override
    public boolean isAsync() {
        return this.async;
    }

    @Override
    public TransactionImpl setAsync(boolean async) {
        this.async = async;
        return this;
    }

    @Override
    public Object getProtocolData() {
        return this.protocolData;
    }

    @Override
    public void setProtocolData(Object protocolData) {
        this.protocolData = protocolData;
    }

    public TransactionImpl(StorageManager storageManager, int timeoutSeconds) {
        this(storageManager.generateID(), null, storageManager, timeoutSeconds);
    }

    public TransactionImpl(StorageManager storageManager) {
        this(storageManager.generateID(), null, storageManager, -1);
    }

    public TransactionImpl(Xid xid, StorageManager storageManager, int timeoutSeconds) {
        this(storageManager.generateID(), xid, storageManager, timeoutSeconds);
    }

    public TransactionImpl(long id, Xid xid, StorageManager storageManager) {
        this(id, xid, storageManager, -1);
    }

    private TransactionImpl(long id, Xid xid, StorageManager storageManager, int timeoutSeconds) {
        this.storageManager = storageManager;
        this.xid = xid;
        this.id = id;
        this.createTime = System.currentTimeMillis();
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public boolean isEffective() {
        return this.state == Transaction.State.PREPARED || this.state == Transaction.State.COMMITTED || this.state == Transaction.State.ROLLEDBACK;
    }

    @Override
    public void setContainsPersistent() {
        this.containsPersistent = true;
    }

    @Override
    public boolean isContainsPersistent() {
        return this.containsPersistent;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeoutSeconds = timeout;
    }

    @Override
    public RefsOperation createRefsOperation(Queue queue, AckReason reason) {
        return new RefsOperation(queue, reason, this.storageManager);
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTimedOut(long currentTime, int defaultTimeout) {
        try (ArtemisCloseable lock = this.storageManager.closeableReadLock();){
            Object object = this.timeoutLock;
            synchronized (object) {
                boolean timedout;
                if (this.timeoutSeconds == -1) {
                    timedout = this.getState() != Transaction.State.PREPARED && currentTime > this.createTime + (long)defaultTimeout * 1000L;
                } else {
                    boolean bl = timedout = this.getState() != Transaction.State.PREPARED && currentTime > this.createTime + (long)this.timeoutSeconds * 1000L;
                }
                if (timedout) {
                    this.markAsRollbackOnly((ActiveMQException)new ActiveMQTransactionTimeoutException());
                }
                boolean bl = timedout;
                return bl;
            }
        }
    }

    @Override
    public boolean hasTimedOut() {
        return this.state == Transaction.State.ROLLBACK_ONLY && this.exception != null && this.exception.getType() == ActiveMQExceptionType.TRANSACTION_TIMEOUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        logger.trace("TransactionImpl::prepare::{}", (Object)this);
        try (ArtemisCloseable lock = this.storageManager.closeableReadLock();){
            Object object = this.timeoutLock;
            synchronized (object) {
                block18: {
                    if (this.isEffective()) {
                        logger.debug("TransactionImpl::prepare::{} is being ignored", (Object)this);
                        return;
                    }
                    if (this.state != Transaction.State.ROLLBACK_ONLY) break block18;
                    logger.trace("TransactionImpl::prepare::rollbackonly, rollingback {}", (Object)this);
                    this.internalRollback();
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    return;
                }
                if (this.state != Transaction.State.ACTIVE) {
                    throw new IllegalStateException("Transaction is in invalid state " + String.valueOf((Object)this.state));
                }
                if (this.xid == null) {
                    throw new IllegalStateException("Cannot prepare non XA transaction");
                }
                this.beforePrepare();
                if (this.delayed > 0) {
                    this.delayedRunnable = new DelayedPrepare(this.id, this.xid);
                } else {
                    this.storageManager.prepare(this.id, this.xid);
                }
                this.state = Transaction.State.PREPARED;
                this.storageManager.afterCompleteOperations(new IOCallback(){

                    public void onError(int errorCode, String errorMessage) {
                        ActiveMQServerLogger.LOGGER.ioErrorOnTX("prepare", errorCode, errorMessage);
                    }

                    public void done() {
                        TransactionImpl.this.afterPrepare();
                    }
                });
            }
        }
    }

    @Override
    public void commit() throws Exception {
        this.commit(true);
    }

    @Override
    public void afterWired(Runnable callback) {
        this.afterWired = callback;
    }

    private void wired() {
        if (this.afterWired != null) {
            this.afterWired.run();
            this.afterWired = null;
        }
    }

    protected OperationConsistencyLevel getRequiredConsistency() {
        return OperationConsistencyLevel.FULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(boolean onePhase) throws Exception {
        logger.trace("TransactionImpl::commit::{}", (Object)this);
        try (ArtemisCloseable lock = this.storageManager.closeableReadLock();){
            Object object = this.timeoutLock;
            synchronized (object) {
                block16: {
                    if (this.state == Transaction.State.COMMITTED) {
                        logger.debug("TransactionImpl::commit::{} is being ignored", (Object)this);
                        return;
                    }
                    if (this.state != Transaction.State.ROLLBACK_ONLY) break block16;
                    this.internalRollback();
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    return;
                }
                if (this.xid != null ? onePhase && this.state != Transaction.State.ACTIVE || !onePhase && this.state != Transaction.State.PREPARED : this.state != Transaction.State.ACTIVE) {
                    throw new ActiveMQIllegalStateException("Transaction is in invalid state " + String.valueOf((Object)this.state));
                }
                this.beforeCommit();
                this.doCommit();
                final List<TransactionOperation> operationsToComplete = this.operations;
                this.operations = null;
                this.storageManager.afterCompleteOperations(new IOCallback(){
                    final /* synthetic */ TransactionImpl this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void onError(int errorCode, String errorMessage) {
                        ActiveMQServerLogger.LOGGER.ioErrorOnTX("commit - afterComplete", errorCode, errorMessage);
                    }

                    public void done() {
                        this.this$0.afterCommit(operationsToComplete);
                    }
                }, this.getRequiredConsistency());
                final List<TransactionOperation> storeOperationsToComplete = this.storeOperations;
                this.storeOperations = null;
                if (storeOperationsToComplete != null) {
                    this.storageManager.afterStoreOperations(new IOCallback(){
                        final /* synthetic */ TransactionImpl this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void onError(int errorCode, String errorMessage) {
                            ActiveMQServerLogger.LOGGER.ioErrorOnTX("commit - afterStore", errorCode, errorMessage);
                        }

                        public void done() {
                            this.this$0.afterCommit(storeOperationsToComplete);
                        }
                    });
                }
                this.wired();
            }
        }
    }

    protected void doCommit() throws Exception {
        if (this.containsPersistent || this.xid != null && this.state == Transaction.State.PREPARED) {
            if (this.delayed > 0) {
                this.delayedRunnable = new DelayedCommit(this.id);
            } else if (this.async) {
                this.storageManager.asyncCommit(this.id);
            } else {
                this.storageManager.commit(this.id);
            }
        } else if (this.delayed > 0) {
            this.delayedRunnable = new NonPersistentDelay(this.id);
        }
        this.state = Transaction.State.COMMITTED;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean tryRollback() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws Exception {
        logger.trace("TransactionImpl::rollback::{}", (Object)this);
        try (ArtemisCloseable lock = this.storageManager.closeableReadLock();){
            Object object = this.timeoutLock;
            synchronized (object) {
                block12: {
                    this.delayedRunnable = null;
                    if (this.state != Transaction.State.ROLLEDBACK) break block12;
                    logger.debug("TransactionImpl::rollback::{} is being ignored", (Object)this);
                    return;
                }
                if (this.xid != null ? this.state != Transaction.State.PREPARED && this.state != Transaction.State.ACTIVE && this.state != Transaction.State.ROLLBACK_ONLY : this.delayed == 0 && this.state != Transaction.State.ACTIVE && this.state != Transaction.State.ROLLBACK_ONLY) {
                    throw new ActiveMQIllegalStateException("Transaction is in invalid state " + String.valueOf((Object)this.state));
                }
                this.internalRollback();
            }
        }
    }

    private void internalRollback() throws Exception {
        logger.trace("TransactionImpl::internalRollback {}", (Object)this);
        this.delayedRunnable = null;
        this.beforeRollback();
        try {
            this.doRollback();
            this.state = Transaction.State.ROLLEDBACK;
        }
        catch (IllegalStateException e) {
            ActiveMQServerLogger.LOGGER.failedToPerformRollback(e);
        }
        final List<TransactionOperation> operationsToComplete = this.operations;
        this.operations = null;
        final List<TransactionOperation> storeOperationsToComplete = this.storeOperations;
        this.storeOperations = null;
        this.storageManager.afterCompleteOperations(new IOCallback(){
            final /* synthetic */ TransactionImpl this$0;
            {
                this.this$0 = this$0;
            }

            public void onError(int errorCode, String errorMessage) {
                ActiveMQServerLogger.LOGGER.ioErrorOnTX("rollback - afterComplete", errorCode, errorMessage);
            }

            public void done() {
                this.this$0.afterRollback(operationsToComplete);
            }
        });
        if (storeOperationsToComplete != null) {
            this.storageManager.afterStoreOperations(new IOCallback(){
                final /* synthetic */ TransactionImpl this$0;
                {
                    this.this$0 = this$0;
                }

                public void onError(int errorCode, String errorMessage) {
                    ActiveMQServerLogger.LOGGER.ioErrorOnTX("rollback - afterStore", errorCode, errorMessage);
                }

                public void done() {
                    this.this$0.afterRollback(storeOperationsToComplete);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() {
        try (ArtemisCloseable lock = this.storageManager.closeableReadLock();){
            Object object = this.timeoutLock;
            synchronized (object) {
                if (this.state != Transaction.State.ACTIVE) {
                    throw new IllegalStateException("Can only suspend active transaction");
                }
                this.state = Transaction.State.SUSPENDED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        try (ArtemisCloseable lock = this.storageManager.closeableReadLock();){
            Object object = this.timeoutLock;
            synchronized (object) {
                if (this.state != Transaction.State.SUSPENDED) {
                    throw new IllegalStateException("Can only resume a suspended transaction");
                }
                this.state = Transaction.State.ACTIVE;
            }
        }
    }

    @Override
    public Transaction.State getState() {
        return this.state;
    }

    @Override
    public void setState(Transaction.State state) {
        this.state = state;
    }

    @Override
    public Xid getXid() {
        return this.xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsRollbackOnly(ActiveMQException exception) {
        try (ArtemisCloseable lock = this.storageManager.closeableReadLock();){
            Object object = this.timeoutLock;
            synchronized (object) {
                block14: {
                    if (logger.isTraceEnabled()) {
                        logger.trace("TransactionImpl::{} marking rollbackOnly for {}, msg={}", new Object[]{this, exception.toString(), exception.getMessage()});
                    }
                    this.delayedRunnable = null;
                    if (!this.isEffective()) break block14;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Trying to mark transaction {} xid={} as rollbackOnly but it was already effective (prepared, committed or rolledback!)", (Object)this.id, (Object)this.xid);
                    }
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Marking Transaction {} as rollback only", (Object)this.id);
                }
                this.state = Transaction.State.ROLLBACK_ONLY;
                this.exception = exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delay() {
        try (ArtemisCloseable lock = this.storageManager.closeableReadLock();){
            Object object = this.timeoutLock;
            synchronized (object) {
                ++this.delayed;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delayDone() {
        try (ArtemisCloseable lock = this.storageManager.closeableReadLock();){
            Object object = this.timeoutLock;
            synchronized (object) {
                if (--this.delayed <= 0 && this.delayedRunnable != null) {
                    try {
                        this.delayedRunnable.run();
                    }
                    finally {
                        this.delayedRunnable = null;
                    }
                }
            }
        }
    }

    public int getPendingDelay() {
        return this.delayed;
    }

    @Override
    public synchronized void addOperation(TransactionOperation operation) {
        switch (this.state) {
            case COMMITTED: {
                operation.afterCommit(this);
                return;
            }
            case ROLLEDBACK: {
                operation.afterRollback(this);
                return;
            }
        }
        this.checkCreateOperations();
        this.operations.add(operation);
    }

    @Override
    public synchronized void afterStore(TransactionOperation sync) {
        if (this.storeOperations == null) {
            this.storeOperations = new LinkedList<TransactionOperation>();
        }
        this.storeOperations.add(sync);
    }

    private int getOperationsCount() {
        this.checkCreateOperations();
        return this.operations.size();
    }

    @Override
    public synchronized List<TransactionOperation> getAllOperations() {
        if (this.operations != null) {
            return new ArrayList<TransactionOperation>(this.operations);
        }
        return new ArrayList<TransactionOperation>();
    }

    @Override
    public void putProperty(int index, Object property) {
        if (this.properties == null) {
            this.properties = new IntObjectHashMap();
        }
        this.properties.put(index, property);
    }

    @Override
    public Object getProperty(int index) {
        return this.properties == null ? null : this.properties.get(index);
    }

    protected void doRollback() throws Exception {
        if (this.containsPersistent || this.xid != null && this.state == Transaction.State.PREPARED) {
            this.storageManager.rollback(this.id);
        }
    }

    private void checkCreateOperations() {
        if (this.operations == null) {
            this.operations = new LinkedList<TransactionOperation>();
        }
    }

    protected synchronized void afterCommit(List<TransactionOperation> operationsToComplete) {
        if (operationsToComplete != null) {
            for (TransactionOperation operation : operationsToComplete) {
                operation.afterCommit(this);
            }
            operationsToComplete.clear();
        }
    }

    private synchronized void afterRollback(List<TransactionOperation> operationsToComplete) {
        if (operationsToComplete != null) {
            for (TransactionOperation operation : operationsToComplete) {
                operation.afterRollback(this);
            }
            operationsToComplete.clear();
        }
    }

    private synchronized void beforeCommit() throws Exception {
        if (this.operations != null) {
            for (TransactionOperation operation : this.operations) {
                operation.beforeCommit(this);
            }
        }
        if (this.storeOperations != null) {
            for (TransactionOperation operation : this.storeOperations) {
                operation.beforeCommit(this);
            }
        }
    }

    private synchronized void beforePrepare() throws Exception {
        if (this.operations != null) {
            for (TransactionOperation operation : this.operations) {
                operation.beforePrepare(this);
            }
        }
        if (this.storeOperations != null) {
            for (TransactionOperation operation : this.storeOperations) {
                operation.beforePrepare(this);
            }
        }
    }

    private synchronized void beforeRollback() throws Exception {
        if (this.operations != null) {
            for (TransactionOperation operation : this.operations) {
                operation.beforeRollback(this);
            }
        }
        if (this.storeOperations != null) {
            for (TransactionOperation operation : this.storeOperations) {
                operation.beforeRollback(this);
            }
        }
    }

    private synchronized void afterPrepare() {
        if (this.operations != null) {
            for (TransactionOperation operation : this.operations) {
                operation.afterPrepare(this);
            }
        }
        if (this.storeOperations != null) {
            for (TransactionOperation operation : this.storeOperations) {
                operation.afterPrepare(this);
            }
        }
    }

    public String toString() {
        Date dt = new Date(this.createTime);
        return "TransactionImpl [xid=" + String.valueOf(this.xid) + ", txID=" + this.id + ", xid=" + String.valueOf(this.xid) + ", state=" + String.valueOf((Object)this.state) + ", createTime=" + this.createTime + "(" + String.valueOf(dt) + "), timeoutSeconds=" + this.timeoutSeconds + ", nr operations = " + this.getOperationsCount() + "]@" + Integer.toHexString(this.hashCode());
    }

    class DelayedPrepare
    extends DelayedRunnable {
        long id;
        Xid xid;

        DelayedPrepare(long id, Xid xid) {
            super(id);
            this.xid = xid;
        }

        @Override
        protected void actualRun() throws Exception {
            TransactionImpl.this.storageManager.prepare(this.id, this.xid);
        }
    }

    class DelayedCommit
    extends DelayedRunnable {
        DelayedCommit(long id) {
            super(id);
        }

        @Override
        protected void actualRun() throws Exception {
            if (TransactionImpl.this.async) {
                TransactionImpl.this.storageManager.asyncCommit(this.id);
            } else {
                TransactionImpl.this.storageManager.commit(this.id);
            }
        }
    }

    class NonPersistentDelay
    extends DelayedRunnable {
        NonPersistentDelay(long id) {
            super(id);
        }

        @Override
        protected void actualRun() throws Exception {
        }
    }

    abstract class DelayedRunnable
    implements Runnable {
        OperationContext parentContext;
        OperationContext storageContext;
        long id;

        DelayedRunnable(long id) {
            this.parentContext = TransactionImpl.this.storageManager.getContext();
            this.parentContext.storeLineUp();
            this.storageContext = TransactionImpl.this.storageManager.newSingleThreadContext();
            this.id = id;
        }

        protected abstract void actualRun() throws Exception;

        @Override
        public void run() {
            OperationContext oldContext = TransactionImpl.this.storageManager.getContext();
            try {
                TransactionImpl.this.storageManager.setContext(this.storageContext);
                this.actualRun();
                this.storageContext.executeOnCompletion(new IOCallback(){

                    public void done() {
                        DelayedRunnable.this.parentContext.done();
                    }

                    public void onError(int errorCode, String errorMessage) {
                        DelayedRunnable.this.parentContext.onError(errorCode, errorMessage);
                    }
                });
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                this.parentContext.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
            }
            finally {
                TransactionImpl.this.storageManager.setContext(oldContext);
            }
        }
    }
}

