/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class CharConstantNode
extends ConstantNode {
    static final int K_CHAR = 0;
    static final int K_VARCHAR = 1;
    static final int K_LONGVARCHAR = 2;
    static final int K_CLOB = 3;
    final int kind;

    CharConstantNode(String value, ContextManager cm) throws StandardException {
        super(TypeId.CHAR_ID, value == null, value != null ? value.length() : 0, cm);
        this.setValue(this.getDataValueFactory().getCharDataValue(value));
        this.kind = 0;
    }

    CharConstantNode(TypeId t, ContextManager cm) throws StandardException {
        super(t, true, 0, cm);
        this.kind = 0;
    }

    CharConstantNode(int kind, TypeId t, ContextManager cm) throws StandardException {
        super(t, true, 0, cm);
        this.kind = kind;
    }

    CharConstantNode(String newValue, int newLength, ContextManager cm) throws StandardException {
        super(TypeId.CHAR_ID, newValue == null, newLength, cm);
        this.kind = 0;
        if (((String)newValue).length() > newLength) {
            throw StandardException.newException("22001", "CHAR", newValue, String.valueOf(newLength));
        }
        while (((String)newValue).length() < newLength) {
            newValue = (String)newValue + " ";
        }
        this.setValue(this.getDataValueFactory().getCharDataValue((String)newValue));
    }

    String getString() throws StandardException {
        return this.value.getString();
    }

    @Override
    Object getConstantValueAsObject() throws StandardException {
        return this.value.getString();
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.setCollationUsingCompilationSchema();
        this.value = ((StringDataValue)this.value).getValue(this.getLanguageConnectionContext().getDataValueFactory().getCharacterCollator(this.getTypeServices().getCollationType()));
        return this;
    }

    @Override
    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        mb.push(this.getString());
    }

    @Override
    boolean isSameNodeKind(ValueNode o) {
        return super.isSameNodeKind(o) && ((CharConstantNode)o).kind == this.kind;
    }
}

