/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.AsciiStream;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClobLocatorOutputStream;
import org.apache.derby.client.am.ClobLocatorWriter;
import org.apache.derby.client.am.ClobOutputStream;
import org.apache.derby.client.am.ClobWriter;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.UpdateSensitiveClobLocatorInputStream;
import org.apache.derby.client.am.UpdateSensitiveClobLocatorReader;
import org.apache.derby.client.net.EncodedInputStream;

public class ClientClob
extends Lob
implements Clob {
    protected String string_ = null;
    private InputStream asciiStream_ = null;
    private InputStream unicodeStream_ = null;
    private Reader characterStream_ = null;
    private byte[] utf8String_;

    public ClientClob(Agent agent, String string) {
        this(agent, false);
        this.string_ = string;
        this.setSqlLength(this.string_.length());
        this.dataType_ |= 2;
    }

    public ClientClob(Agent agent, byte[] byArray, Charset charset, int n) throws SqlException {
        this(agent, false);
        if (charset == null) {
            throw new SqlException(agent.logWriter_, new ClientMessageId("22005.S.2"), new Object[0]);
        }
        this.string_ = new String(byArray, n, byArray.length - n, charset);
        this.setSqlLength(this.string_.length());
        this.dataType_ |= 2;
    }

    public ClientClob(Agent agent, InputStream inputStream, Charset charset, int n) {
        this(agent, false);
        this.setSqlLength(n);
        if (charset.equals(Cursor.ISO_8859_1)) {
            this.asciiStream_ = inputStream;
            this.dataType_ |= 4;
        } else if (charset.equals(Cursor.UTF_8)) {
            this.unicodeStream_ = inputStream;
            this.dataType_ |= 8;
        } else if (charset.equals(Cursor.UTF_16BE)) {
            this.characterStream_ = new InputStreamReader(inputStream, Cursor.UTF_16BE);
            this.dataType_ |= 0x10;
            this.setSqlLength(n / 2);
        }
    }

    ClientClob(Agent agent, InputStream inputStream, Charset charset) throws SqlException {
        this(agent, ClientClob.isLayerBStreamingPossible(agent));
        if (charset.equals(Cursor.ISO_8859_1)) {
            this.asciiStream_ = inputStream;
            this.dataType_ |= 4;
        } else {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), charset + " InputStream", "String/Clob");
        }
    }

    ClientClob(Agent agent, Reader reader, int n) {
        this(agent, false);
        this.setSqlLength(n);
        this.characterStream_ = reader;
        this.dataType_ |= 0x10;
    }

    public ClientClob(Agent agent, int n) {
        super(agent, false);
        this.locator_ = n;
        this.dataType_ |= 0x80;
    }

    ClientClob(Agent agent, Reader reader) {
        this(agent, ClientClob.isLayerBStreamingPossible(agent));
        this.unicodeStream_ = EncodedInputStream.createUTF8Stream(reader);
        this.dataType_ |= 8;
    }

    private ClientClob(Agent agent, boolean bl) {
        super(agent, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "length", new Object[0]);
                }
                long l = super.sqlLength();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "length", l);
                }
                return l;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long l, int n) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                String string = null;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getSubString", (int)l, n);
                }
                if (l <= 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), l);
                }
                if (n < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), n);
                }
                if (l > this.sqlLength() + 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), l);
                }
                string = this.getSubStringX(l, n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getSubString", string);
                }
                return string;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private String getSubStringX(long l, int n) throws SqlException {
        this.checkForClosedConnection();
        long l2 = Math.min(this.sqlLength() - l + 1L, (long)n);
        if (this.isLocator()) {
            return this.agent_.connection_.locatorProcedureCall().clobGetSubString(this.locator_, l, (int)l2);
        }
        return this.string_.substring((int)l - 1, (int)(l - 1L + l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCharacterStream", new Object[0]);
                }
                Reader reader = this.getCharacterStreamX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", reader);
                }
                return reader;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    Reader getCharacterStreamX() throws SqlException {
        this.checkForClosedConnection();
        if (this.isLocator()) {
            return new UpdateSensitiveClobLocatorReader(this.agent_.connection_, this);
        }
        if (this.isCharacterStream()) {
            return this.characterStream_;
        }
        return new StringReader(this.string_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getAsciiStream", new Object[0]);
                }
                InputStream inputStream = this.getAsciiStreamX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getAsciiStream", inputStream);
                }
                return inputStream;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    InputStream getAsciiStreamX() throws SqlException {
        this.checkForClosedConnection();
        if (this.isAsciiStream()) {
            return this.asciiStream_;
        }
        if (this.isLocator()) {
            return new UpdateSensitiveClobLocatorInputStream(this.agent_.connection_, this);
        }
        return new AsciiStream(this.string_, new StringReader(this.string_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(String string, long l) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "position(String, long)", string, l);
                }
                if (string == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"), new Object[0]);
                }
                if (l < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), l);
                }
                long l2 = this.positionX(string, l);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(String, long)", l2);
                }
                return l2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private long positionX(String string, long l) throws SqlException {
        this.checkForClosedConnection();
        long l2 = -1L;
        if (l <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), l, "start", "Clob.position()");
        }
        if (this.isLocator()) {
            l2 = this.agent_.connection_.locatorProcedureCall().clobGetPositionFromString(this.locator_, string, l);
        } else {
            l2 = this.string_.indexOf(string, (int)l - 1);
            if (l2 != -1L) {
                ++l2;
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(Clob clob, long l) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "position(Clob, long)", clob, l);
                }
                if (l < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), l);
                }
                if (clob == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"), new Object[0]);
                }
                long l2 = this.positionX(clob, l);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(Clob, long)", l2);
                }
                return l2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private long positionX(Clob clob, long l) throws SqlException {
        long l2;
        this.checkForClosedConnection();
        if (l <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), l, "start", "Clob.position()");
        }
        try {
            if (clob.length() > this.sqlLength()) {
                return -1L;
            }
            if (this.isLocator()) {
                l2 = this.agent_.connection_.locatorProcedureCall().clobGetPositionFromLocator(this.locator_, ((ClientClob)clob).getLocator(), l);
            } else {
                l2 = this.string_.indexOf(clob.getSubString(1L, (int)clob.length()), (int)l - 1);
                if (l2 != -1L) {
                    ++l2;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long l, String string) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setString", (int)l, string);
                }
                int n = this.setStringX(l, string, 0, string.length());
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setString", n);
                }
                return n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setString", (int)l, string, n, n2);
                }
                int n3 = this.setStringX(l, string, n, n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setString", n3);
                }
                return n3;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    int setStringX(long l, String string, int n, int n2) throws SqlException {
        if ((int)l <= 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), l);
        }
        if (l - 1L > this.sqlLength()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), l);
        }
        if (string == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"), new Object[0]);
        }
        if (string.length() == 0) {
            return 0;
        }
        if (n < 0 || n >= string.length()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ078.S"), n);
        }
        if (n2 < 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), n2);
        }
        if (n + n2 > string.length()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22011.S.1"), n, n2, string);
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        n3 = Math.min(string.length() - n, n2);
        if (this.isLocator()) {
            this.agent_.connection_.locatorProcedureCall().clobSetString(this.locator_, l, n3, string.substring(n, n + n3));
            if (l + (long)n3 - 1L > this.sqlLength()) {
                this.setSqlLength(l + (long)n3 - 1L);
            }
            this.incrementUpdateCount();
        } else {
            this.reInitForNonLocator(this.string_.substring(0, (int)l - 1).concat(string.substring(n, n + n3)));
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setAsciiStream", (int)l);
                }
                OutputStream outputStream = null;
                outputStream = this.isLocator() ? new ClobLocatorOutputStream(this, l) : new ClobOutputStream(this, l);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setAsciiStream", outputStream);
                }
                return outputStream;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "setCharacterStream", (int)l);
                }
                Writer writer = null;
                writer = this.isLocator() ? new ClobLocatorWriter(this.agent_.connection_, this, l) : new ClobWriter(this, l);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setCharacterStream", writer);
                }
                return writer;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long l) throws SQLException {
        this.checkValidity();
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, " truncate", (int)l);
                }
                if (l < 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), l);
                }
                if (l > this.sqlLength()) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ079.S"), l);
                }
                if (l == this.sqlLength()) {
                    return;
                }
                if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().clobTruncate(this.locator_, l);
                    this.incrementUpdateCount();
                    this.setSqlLength(l);
                } else {
                    this.reInitForNonLocator(this.string_.substring(0, (int)l));
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws SQLException {
        if (!this.isValid_) {
            return;
        }
        this.isValid_ = false;
        try {
            ClientConnection clientConnection = this.agent_.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "free", new Object[0]);
                }
                if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().clobReleaseLocator(this.locator_);
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        if (this.isString()) {
            this.string_ = null;
            this.utf8String_ = null;
        }
        if (this.isAsciiStream()) {
            try {
                this.asciiStream_.close();
            }
            catch (IOException iOException) {
                throw new SqlException(null, new ClientMessageId("XJ214.S"), new Object[0]).getSQLException();
            }
        }
        if (this.isUnicodeStream()) {
            try {
                this.unicodeStream_.close();
            }
            catch (IOException iOException) {
                throw new SqlException(null, new ClientMessageId("XJ214.S"), new Object[0]).getSQLException();
            }
        }
        if (this.isCharacterStream()) {
            try {
                this.characterStream_.close();
            }
            catch (IOException iOException) {
                throw new SqlException(null, new ClientMessageId("XJ214.S"), new Object[0]).getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        this.checkValidity();
        ClientConnection clientConnection = this.agent_.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getCharacterStream", (int)l, l2);
            }
            this.checkPosAndLength(l, l2);
            Reader reader = null;
            if (this.isLocator()) {
                try {
                    reader = new UpdateSensitiveClobLocatorReader(this.agent_.connection_, this, l, l2);
                }
                catch (SqlException sqlException) {
                    throw sqlException.getSQLException();
                }
            }
            String string = null;
            try {
                string = this.getSubStringX(l, (int)l2);
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
            reader = new StringReader(string);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", reader);
            }
            return reader;
        }
    }

    public boolean isString() {
        return (this.dataType_ & 2) == 2;
    }

    public boolean isAsciiStream() {
        return (this.dataType_ & 4) == 4;
    }

    public boolean isCharacterStream() {
        return (this.dataType_ & 0x10) == 16;
    }

    public boolean isUnicodeStream() {
        return (this.dataType_ & 8) == 8;
    }

    public InputStream getUnicodeStream() {
        return this.unicodeStream_;
    }

    public String getString() {
        return this.string_;
    }

    public byte[] getUtf8String() {
        return this.utf8String_;
    }

    public int getUTF8Length() {
        if (this.utf8String_ != null) {
            return this.utf8String_.length;
        }
        this.utf8String_ = this.string_.getBytes(Cursor.UTF_8);
        return this.utf8String_.length;
    }

    void reInitForNonLocator(String string) {
        this.string_ = string;
        this.asciiStream_ = new StringBufferInputStream(this.string_);
        this.unicodeStream_ = new StringBufferInputStream(this.string_);
        this.characterStream_ = new StringReader(this.string_);
        this.setSqlLength(this.string_.length());
    }

    @Override
    protected void materializeStream() throws SqlException {
        this.unicodeStream_ = super.materializeStream(this.isAsciiStream() ? this.asciiStream_ : this.unicodeStream_, "java.sql.Clob");
        this.dataType_ = 8;
    }

    @Override
    long getLocatorLength() throws SqlException {
        return this.agent_.connection_.locatorProcedureCall().clobGetLength(this.locator_);
    }
}

