/*
 * Decompiled with CFR 0.152.
 */
package grails.init;

import grails.init.FindLastSnapshotHandler;
import grails.init.GrailsReleaseNotFoundException;
import grails.init.GrailsReleaseType;
import grails.init.GrailsVersion;
import grails.init.GrailsWrapperHome;
import grails.init.GrailsWrapperRepo;
import grails.init.RootMetadataHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GrailsUpdater {
    private final GrailsWrapperHome grailsWrapperHome;
    private final GrailsVersion preferredVersion;
    private GrailsVersion updatedVersion;

    public GrailsUpdater(LinkedHashSet<GrailsReleaseType> allowedTypes, GrailsVersion preferredVersion) throws IOException {
        this(allowedTypes, preferredVersion, null);
    }

    public GrailsUpdater(LinkedHashSet<GrailsReleaseType> allowedTypes, GrailsVersion preferredVersion, String possibleGrailsHome) throws IOException {
        this.grailsWrapperHome = new GrailsWrapperHome(allowedTypes, possibleGrailsHome);
        this.preferredVersion = preferredVersion;
    }

    public GrailsVersion getSelectedVersion() {
        if (this.preferredVersion != null) {
            return this.preferredVersion;
        }
        if (this.updatedVersion != null) {
            return this.updatedVersion;
        }
        return this.grailsWrapperHome.latestVersion;
    }

    public File getExecutedJarFile() {
        GrailsVersion selectedVersion = this.getSelectedVersion();
        return this.grailsWrapperHome.getWrapperImplementation(selectedVersion, this.grailsWrapperHome.getVersionDirectory(selectedVersion));
    }

    public boolean needsUpdating() {
        File jarFile = this.grailsWrapperHome.getLatestWrapperImplementation();
        if (jarFile == null) {
            return true;
        }
        if (this.preferredVersion != null) {
            if (!this.grailsWrapperHome.versions.contains(this.preferredVersion)) {
                return true;
            }
            return this.preferredVersion.releaseType.isSnapshot();
        }
        return false;
    }

    public boolean update() {
        boolean validRepoFound = false;
        List<GrailsWrapperRepo> repos = GrailsWrapperRepo.getSelectedRepos();
        for (GrailsWrapperRepo repo : repos) {
            GrailsVersion selectedVersion = null;
            if (this.preferredVersion != null) {
                selectedVersion = this.preferredVersion;
            } else {
                try {
                    selectedVersion = this.getRootVersion(repo);
                }
                catch (GrailsReleaseNotFoundException e) {
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Unable to fetch latest Grails CLI from [" + repo.getUrl() + "].");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            String detailedVersion = null;
            if (selectedVersion.releaseType.isSnapshot()) {
                try {
                    detailedVersion = this.fetchSnapshotForVersion(repo, selectedVersion);
                }
                catch (GrailsReleaseNotFoundException e) {
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Could not parse snapshot version from maven metadata.");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            validRepoFound = true;
            boolean theResult = this.updateJar(repo, selectedVersion, detailedVersion);
            if (!theResult) continue;
            this.updatedVersion = selectedVersion;
            return theResult;
        }
        if (validRepoFound) {
            return false;
        }
        String repoUrls = repos.stream().map(GrailsWrapperRepo::getUrl).collect(Collectors.joining(","));
        throw new IllegalStateException("Could not find the Grails Repo in any repository: " + repoUrls);
    }

    private boolean updateJar(GrailsWrapperRepo repo, GrailsVersion version, String snapshotVersion) {
        boolean success = false;
        String localJarFilename = "grails-cli-" + version.version + "-all";
        String remoteJarFilename = snapshotVersion != null ? "grails-cli-" + snapshotVersion + "-all" : "grails-cli-" + version.version + "-all";
        String jarFileExtension = ".jar";
        try {
            InputStream inputStream;
            File downloadedJar = File.createTempFile(localJarFilename, ".jar");
            String wrapperUrl = repo.getFileUrl(version, remoteJarFilename + ".jar");
            if (snapshotVersion != null) {
                System.out.println("... Using Snapshot URL: " + wrapperUrl);
            }
            long contentLength = -1L;
            if (repo.isFile) {
                File jarFile = new File(wrapperUrl);
                if (!jarFile.exists()) {
                    throw new IllegalStateException("Could not determine local metadata file from local maven repository: " + jarFile.getAbsolutePath() + " does not exist");
                }
                inputStream = Files.newInputStream(jarFile.toPath(), new OpenOption[0]);
                contentLength = jarFile.length();
            } else {
                HttpURLConnection conn = GrailsUpdater.createHttpURLConnection(wrapperUrl);
                contentLength = conn.getContentLengthLong();
                inputStream = conn.getInputStream();
            }
            success = this.downloadWrapperJar(version, downloadedJar, inputStream, contentLength, repo.isFile);
        }
        catch (Exception e) {
            System.err.println("There was an error downloading the wrapper jar from [" + repo.getUrl() + "]");
            e.printStackTrace();
        }
        return success;
    }

    private void transfer(File downloadJarLocation, InputStream inputStream, long expectedSize) throws IOException {
        try (InputStream inputStream2 = inputStream;
             FileOutputStream fos = new FileOutputStream(downloadJarLocation);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            long totalBytesRead = 0L;
            int lastProgressPercent = 0;
            long lastMillis = System.currentTimeMillis();
            long lastBytes = 0L;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesRead);
                totalBytesRead += (long)bytesRead;
                if (expectedSize > 0L) {
                    long currentMillis = System.currentTimeMillis();
                    if (currentMillis - lastMillis < 500L) continue;
                    long elapsedMillis = currentMillis - lastMillis;
                    long bytesThisRound = totalBytesRead - lastBytes;
                    double bytesPerSecond = (double)bytesThisRound / ((double)elapsedMillis / 1000.0);
                    int progressPercent = (int)(totalBytesRead * 100L / expectedSize);
                    if (progressPercent != lastProgressPercent) {
                        String transferSpeed = GrailsUpdater.readableSize((long)bytesPerSecond, true);
                        System.out.printf("\r... %3d%% (%s)", progressPercent, transferSpeed);
                        lastProgressPercent = progressPercent;
                    }
                    lastMillis = currentMillis;
                    lastBytes = totalBytesRead;
                    continue;
                }
                System.out.printf("\r... %s", GrailsUpdater.readableSize(totalBytesRead, false));
            }
            System.out.print("\n");
        }
    }

    public static String readableSize(long bytes, boolean addSeconds) {
        List<String> units = List.of("KiB", "MiB", "GiB", "TiB");
        List<Long> thresholds = List.of(Long.valueOf(1024L), Long.valueOf(0x100000L), Long.valueOf(0x40000000L), Long.valueOf(0x10000000000L));
        if (bytes > 0x10000000000L) {
            return "---";
        }
        for (int i = thresholds.size() - 1; i >= 0; --i) {
            if (bytes < thresholds.get(i)) continue;
            double thresholdValue = (double)bytes / (double)thresholds.get(i).longValue();
            return String.format(addSeconds ? "%.2f %s/s" : "%.2f %s", thresholdValue, units.get(i));
        }
        return addSeconds ? "B/s" : "B";
    }

    private boolean downloadWrapperJar(GrailsVersion version, File downloadJarLocation, InputStream inputStream, long expectedSize, boolean isLocal) throws IOException {
        this.transfer(downloadJarLocation, inputStream, expectedSize);
        try {
            this.grailsWrapperHome.cleanupOtherVersions(version);
        }
        catch (Exception e) {
            System.err.println("Unable to cleanup old versions of the wrapper");
            e.printStackTrace();
        }
        File directory = this.grailsWrapperHome.getVersionDirectory(version);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        Path jarFile = new File(directory, "grails-cli-" + version.version + "-all.jar").toPath();
        System.out.println("...Moving " + (isLocal ? "local" : "remotely") + " downloaded jar to: " + String.valueOf(jarFile.toAbsolutePath()));
        Files.move(downloadJarLocation.getAbsoluteFile().toPath(), jarFile, StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    private static InputStream retrieveMavenMetadata(GrailsWrapperRepo repo, String metadataUrl) throws IOException, GrailsReleaseNotFoundException {
        if (repo.isFile) {
            File metadataFile = new File(metadataUrl);
            if (!metadataFile.exists()) {
                throw new GrailsReleaseNotFoundException("Could not determine local metadata file from local maven repository: " + metadataFile.getAbsolutePath() + " does not exist");
            }
            return Files.newInputStream(metadataFile.toPath(), new OpenOption[0]);
        }
        HttpURLConnection connection = GrailsUpdater.createHttpURLConnection(metadataUrl);
        try {
            return connection.getInputStream();
        }
        catch (Exception e) {
            throw new GrailsReleaseNotFoundException("There was an error downloading the metadata file", e);
        }
    }

    private GrailsVersion getRootVersion(GrailsWrapperRepo repo) throws IOException, SAXException, ParserConfigurationException, GrailsReleaseNotFoundException {
        RootMetadataHandler findLastReleaseHandler = new RootMetadataHandler(this.grailsWrapperHome.allowedReleaseTypes);
        try (InputStream stream = GrailsUpdater.retrieveMavenMetadata(repo, repo.getRootMetadataUrl());){
            GrailsUpdater.createSAXParser().parse(stream, (DefaultHandler)findLastReleaseHandler);
            List<GrailsVersion> foundVersions = findLastReleaseHandler.getVersions();
            if (foundVersions.isEmpty()) {
                throw new GrailsReleaseNotFoundException("No Grails Releases were found for the allowed types: " + this.grailsWrapperHome.allowedReleaseTypes.stream().map(Enum::name).collect(Collectors.joining(", ")));
            }
            Collections.sort(foundVersions);
            GrailsVersion grailsVersion = foundVersions.get(0);
            return grailsVersion;
        }
    }

    private String fetchSnapshotForVersion(GrailsWrapperRepo repo, GrailsVersion baseVersion) throws IOException, SAXException, ParserConfigurationException, GrailsReleaseNotFoundException {
        System.out.println("...A Grails snapshot version has been detected. Downloading latest snapshot.");
        FindLastSnapshotHandler findVersionHandler = new FindLastSnapshotHandler();
        try (InputStream stream = GrailsUpdater.retrieveMavenMetadata(repo, repo.getMetadataUrl(baseVersion));){
            GrailsUpdater.createSAXParser().parse(stream, (DefaultHandler)findVersionHandler);
            String string = findVersionHandler.getVersion();
            return string;
        }
    }

    private static HttpURLConnection createHttpURLConnection(String mavenMetadataFileUrl) throws IOException {
        URL url = new URL(mavenMetadataFileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", "Apache-Maven/3.9.6");
        conn.setInstanceFollowRedirects(true);
        return conn;
    }

    private static SAXParser createSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setXIncludeAware(false);
        factory.setNamespaceAware(true);
        return factory.newSAXParser();
    }
}

