/*
 * Decompiled with CFR 0.152.
 */
package org.grails.config;

import grails.config.Config;
import grails.util.GrailsStringUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.grails.core.exceptions.GrailsConfigurationException;

public class CompositeConfig
implements Config {
    protected Deque<Config> configs = new ArrayDeque<Config>();

    public void addFirst(Config config) {
        this.configs.addFirst(config);
    }

    public void addLast(Config config) {
        this.configs.addLast(config);
    }

    @Override
    @Deprecated
    public Map<String, Object> flatten() {
        LinkedHashMap<String, Object> flattened = new LinkedHashMap<String, Object>();
        for (Config c : this.configs) {
            flattened.putAll(c.flatten());
        }
        return flattened;
    }

    @Override
    public Properties toProperties() {
        Properties properties = new Properties();
        for (Config c : this.configs) {
            properties.putAll((Map<?, ?>)c.toProperties());
        }
        return properties;
    }

    @Override
    public Config merge(Map<String, Object> toMerge) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue, List<T> allowedValues) {
        T v = this.getProperty(key, targetType, defaultValue);
        if (!allowedValues.contains(v)) {
            throw new GrailsConfigurationException("Invalid configuration value [$value] for key [${key}]. Possible values $allowedValues");
        }
        return v;
    }

    @Override
    public Object getAt(Object key) {
        for (Config c : this.configs) {
            Object v = c.getAt(key);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Override
    public void setAt(Object key, Object value) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    @Override
    public Object navigate(String ... path) {
        for (Config c : this.configs) {
            Object v = c.navigate(path);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Override
    public int size() {
        int size = 0;
        for (Config config : this.configs) {
            size += config.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (Config config : this.configs) {
            if (config.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Config config : this.configs) {
            if (!config.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Config config : this.configs) {
            if (!config.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        for (Config config : this.configs) {
            Object v = config.get(key);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Config cannot be modified");
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.entrySet().iterator();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> entries = new HashSet<String>();
        for (Config config : this.configs) {
            entries.addAll(config.keySet());
        }
        return entries;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Config config : this.configs) {
            values.addAll(config.values());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
        for (Config config : this.configs) {
            entries.addAll(config.entrySet());
        }
        return entries;
    }

    @Override
    public boolean containsProperty(String key) {
        return this.containsKey(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String v = this.getProperty(key, String.class);
        return !GrailsStringUtils.isBlank(v) ? v : defaultValue;
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType) {
        for (Config config : this.configs) {
            T v = config.getProperty(key, targetType);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        T v = this.getProperty(key, targetType);
        return v != null ? v : defaultValue;
    }

    @Override
    public String getRequiredProperty(String key) throws IllegalStateException {
        String value = this.getProperty(key);
        if (GrailsStringUtils.isBlank(value)) {
            throw new IllegalStateException("Value for key [$key] cannot be resolved");
        }
        return value;
    }

    @Override
    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        T value = this.getProperty(key, targetType);
        if (value == null) {
            throw new IllegalStateException("Value for key [$key] cannot be resolved");
        }
        return value;
    }

    @Override
    public String resolvePlaceholders(String text) {
        throw new UnsupportedOperationException("Config cannot be used to resolve placeholders");
    }

    @Override
    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Config cannot be used to resolve placeholders");
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, String.class);
    }
}

