/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mime;

import grails.web.mime.MimeType;
import grails.web.mime.MimeUtility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultMimeUtility
implements MimeUtility {
    private List<MimeType> mimeTypes;
    private Map<String, MimeType> extensionToMimeMap = new HashMap<String, MimeType>();

    public DefaultMimeUtility(MimeType[] mimeTypes) {
        this(Arrays.asList(mimeTypes));
    }

    public DefaultMimeUtility(List<MimeType> mimeTypes) {
        this.mimeTypes = mimeTypes;
        for (MimeType mimeType : mimeTypes) {
            String ext = mimeType.getExtension();
            if (this.extensionToMimeMap.containsKey(ext)) continue;
            this.extensionToMimeMap.put(ext, mimeType);
        }
    }

    @Override
    public List<MimeType> getKnownMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public MimeType getMimeTypeForExtension(String extension) {
        if (extension == null) {
            return null;
        }
        return this.extensionToMimeMap.get(extension);
    }

    @Override
    public MimeType getMimeTypeForURI(String uri) {
        if (uri == null) {
            return null;
        }
        int i2 = uri.lastIndexOf(46);
        int length = uri.length();
        if (i2 > -1 && i2 < length) {
            String extension = uri.substring(i2 + 1, length);
            return this.getMimeTypeForExtension(extension);
        }
        return null;
    }
}

