/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.managers.systemview.walker;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.systemview.view.PartitionStateView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

/**
 * Generated by {@code org.apache.ignite.codegen.SystemViewRowAttributeWalkerGenerator}.
 * {@link PartitionStateView} attributes walker.
 * 
 * @see PartitionStateView
 */
public class PartitionStateViewWalker implements SystemViewRowAttributeWalker<PartitionStateView> {
    /** Filter key for attribute "cacheGroupId" */
    public static final String CACHE_GROUP_ID_FILTER = "cacheGroupId";

    /** Filter key for attribute "nodeId" */
    public static final String NODE_ID_FILTER = "nodeId";

    /** Filter key for attribute "partitionId" */
    public static final String PARTITION_ID_FILTER = "partitionId";

    /** List of filtrable attributes. */
    private static final List<String> FILTRABLE_ATTRS = Collections.unmodifiableList(F.asList(
        "cacheGroupId", "nodeId", "partitionId"
    ));

    /** {@inheritDoc} */
    @Override public List<String> filtrableAttributes() {
        return FILTRABLE_ATTRS;
    }

    /** {@inheritDoc} */
    @Override public void visitAll(AttributeVisitor v) {
        v.accept(0, "cacheGroupId", int.class);
        v.accept(1, "nodeId", UUID.class);
        v.accept(2, "partitionId", int.class);
        v.accept(3, "state", String.class);
        v.accept(4, "isPrimary", boolean.class);
    }

    /** {@inheritDoc} */
    @Override public void visitAll(PartitionStateView row, AttributeWithValueVisitor v) {
        v.acceptInt(0, "cacheGroupId", row.cacheGroupId());
        v.accept(1, "nodeId", UUID.class, row.nodeId());
        v.acceptInt(2, "partitionId", row.partitionId());
        v.accept(3, "state", String.class, row.state());
        v.acceptBoolean(4, "isPrimary", row.isPrimary());
    }

    /** {@inheritDoc} */
    @Override public int count() {
        return 5;
    }
}
