/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.cluster.config;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.call.configuration.ClusterConfigShowCall;
import org.apache.ignite.internal.cli.call.configuration.ClusterConfigShowCallInput;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import picocli.CommandLine;

@CommandLine.Command(name="show", description={"Shows cluster configuration"})
public class ClusterConfigShowReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Parameters(arity="0..1", description={"Configuration path selector"})
    private String selector;
    @Inject
    private ClusterConfigShowCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::configShowCallInput).then(Flows.fromCall(this.call)).exceptionHandler(new ClusterNotInitializedExceptionHandler("Cannot show cluster config", "cluster init")).verbose(this.verbose).print().start();
    }

    private ClusterConfigShowCallInput configShowCallInput(String clusterUrl) {
        return ClusterConfigShowCallInput.builder().selector(this.selector).clusterUrl(clusterUrl).build();
    }
}

