/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.config.ini;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.cli.config.ConfigInitializationException;
import org.apache.ignite.internal.cli.config.ConfigManager;
import org.apache.ignite.internal.cli.config.Profile;
import org.apache.ignite.internal.cli.config.ProfileNotFoundException;
import org.apache.ignite.internal.cli.config.ini.IniFile;
import org.apache.ignite.internal.cli.config.ini.IniProfile;
import org.apache.ignite.internal.cli.config.ini.IniSection;
import org.apache.ignite.internal.cli.logger.CliLoggers;
import org.apache.ignite.internal.logger.IgniteLogger;

public class IniConfigManager
implements ConfigManager {
    private static final IgniteLogger LOG = CliLoggers.forClass(IniConfigManager.class);
    private static final String DEFAULT_PROFILE_NAME = "default";
    private final IniFile configFile;
    private String currentProfileName;

    public IniConfigManager(File file) {
        IniFile configFile;
        try {
            configFile = new IniFile(file);
            IniConfigManager.findCurrentProfileName(configFile);
        }
        catch (IOException | NoSuchElementException e) {
            LOG.warn("User config is corrupted or doesn't exist.", (Throwable)e);
            configFile = IniConfigManager.createDefaultConfig(file);
        }
        this.configFile = configFile;
        this.currentProfileName = IniConfigManager.findCurrentProfileName(configFile);
    }

    private static String findCurrentProfileName(IniFile configFile) {
        IniSection topLevelSection = configFile.getTopLevelSection();
        IniSection section = configFile.getSections().stream().findFirst().orElseThrow();
        String currentProfile = topLevelSection.getProperty("current_profile");
        if (currentProfile == null) {
            topLevelSection.setProperty("current_profile", section.getName());
            currentProfile = section.getName();
        }
        return currentProfile;
    }

    @Override
    public Profile getCurrentProfile() {
        return this.getProfile(this.currentProfileName);
    }

    @Override
    public Profile getProfile(String profile) {
        IniSection section = this.configFile.getSection(profile);
        if (section == null) {
            throw new ProfileNotFoundException(profile);
        }
        return new IniProfile(section, this.configFile::store);
    }

    @Override
    public Profile createProfile(String profileName) {
        return new IniProfile(this.configFile.createSection(profileName), this.configFile::store);
    }

    @Override
    public void setCurrentProfile(String profileName) {
        IniSection section = this.configFile.getSection(profileName);
        if (section == null) {
            throw new ProfileNotFoundException(profileName);
        }
        this.currentProfileName = profileName;
        this.configFile.getTopLevelSection().setProperty("current_profile", profileName);
        this.configFile.store();
    }

    @Override
    public Collection<String> getProfileNames() {
        return this.configFile.getSectionNames();
    }

    private static IniFile createDefaultConfig(File file) {
        try {
            file.getParentFile().mkdirs();
            file.delete();
            file.createNewFile();
            IniFile ini = new IniFile(file);
            ini.getTopLevelSection().setProperty("current_profile", DEFAULT_PROFILE_NAME);
            IniSection defaultSection = ini.createSection(DEFAULT_PROFILE_NAME);
            defaultSection.setProperty("ignite.cluster-endpoint-url", "http://localhost:10300");
            defaultSection.setProperty("ignite.jdbc-url", "jdbc:ignite:thin://127.0.0.1:10800");
            ini.store();
            return ini;
        }
        catch (IOException e) {
            throw new ConfigInitializationException(file.getAbsolutePath(), e);
        }
    }
}

