/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.executor;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.ignite.internal.cli.config.StateFolderProvider;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandlers;
import org.apache.ignite.internal.cli.core.exception.handler.PicocliExecutionExceptionHandler;
import org.apache.ignite.internal.cli.core.exception.handler.ReplExceptionHandlers;
import org.apache.ignite.internal.cli.core.flow.question.JlineQuestionWriterReader;
import org.apache.ignite.internal.cli.core.flow.question.QuestionAskerFactory;
import org.apache.ignite.internal.cli.core.repl.Repl;
import org.apache.ignite.internal.cli.core.repl.completer.DynamicCompleterActivationPoint;
import org.apache.ignite.internal.cli.core.repl.completer.DynamicCompleterFilter;
import org.apache.ignite.internal.cli.core.repl.completer.DynamicCompleterRegistry;
import org.apache.ignite.internal.cli.core.repl.context.CommandLineContextProvider;
import org.apache.ignite.internal.cli.core.repl.executor.IgnitePicocliCommands;
import org.apache.ignite.internal.cli.core.repl.executor.RegistryCommandExecutor;
import org.apache.ignite.internal.cli.core.repl.expander.NoopExpander;
import org.jline.console.CommandRegistry;
import org.jline.console.SystemRegistry;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.reader.Completer;
import org.jline.reader.Expander;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.terminal.Terminal;
import org.jline.widget.TailTipWidgets;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;

public class ReplExecutor {
    private final Parser parser = new DefaultParser();
    private final Supplier<Path> workDirProvider = () -> Paths.get(System.getProperty("user.dir"), new String[0]);
    private final AtomicBoolean interrupted = new AtomicBoolean();
    private final ExceptionHandlers exceptionHandlers = new ReplExceptionHandlers(this.interrupted::set);
    private final PicocliCommands.PicocliCommandsFactory factory;
    private final Terminal terminal;

    public ReplExecutor(PicocliCommands.PicocliCommandsFactory commandsFactory, Terminal terminal) {
        this.factory = commandsFactory;
        this.terminal = terminal;
    }

    public void execute(Repl repl) {
        try {
            repl.customizeTerminal(this.terminal);
            IgnitePicocliCommands picocliCommands = this.createPicocliCommands(repl);
            SystemRegistryImpl registry = new SystemRegistryImpl(this.parser, this.terminal, this.workDirProvider, null);
            registry.setCommandRegistries(new CommandRegistry[]{picocliCommands});
            registry.register("help", (CommandRegistry)picocliCommands);
            LineReader reader = this.createReader((Completer)(repl.getCompleter() != null ? new AggregateCompleter(new Completer[]{registry.completer(), repl.getCompleter()}) : registry.completer()));
            if (repl.getHistoryFileName() != null) {
                reader.variable("history-file", (Object)StateFolderProvider.getStateFile(repl.getHistoryFileName()));
            }
            RegistryCommandExecutor executor = new RegistryCommandExecutor((SystemRegistry)registry, this.parser);
            TailTipWidgets widgets = repl.isTailTipWidgetsEnabled() ? ReplExecutor.createWidgets(registry, reader) : null;
            QuestionAskerFactory.setReadWriter(new JlineQuestionWriterReader(reader, widgets));
            repl.onStart();
            while (!this.interrupted.get()) {
                try {
                    executor.cleanUp();
                    String prompt = repl.getPromptProvider().getPrompt();
                    String line = reader.readLine(prompt, null, (MaskingCallback)null, null);
                    if (line.isEmpty()) continue;
                    repl.getPipeline(executor, this.exceptionHandlers, line).runPipeline();
                }
                catch (Throwable t) {
                    this.exceptionHandlers.handleException(System.err::println, t);
                }
            }
            reader.getHistory().save();
        }
        catch (Throwable t) {
            this.exceptionHandlers.handleException(System.err::println, t);
        }
    }

    private static TailTipWidgets createWidgets(SystemRegistryImpl registry, LineReader reader) {
        TailTipWidgets widgets = new TailTipWidgets(reader, arg_0 -> ((SystemRegistryImpl)registry).commandDescription(arg_0), 5, TailTipWidgets.TipType.COMPLETER);
        widgets.enable();
        CommandLineContextProvider.setPrintWrapper(printer -> {
            widgets.disable();
            printer.run();
            widgets.enable();
        });
        registry.setScriptDescription(cmdLine -> null);
        return widgets;
    }

    private LineReader createReader(Completer completer) {
        LineReader result = LineReaderBuilder.builder().terminal(this.terminal).completer(completer).parser(this.parser).expander((Expander)new NoopExpander()).variable("list-max", (Object)50).build();
        result.setAutosuggestion(LineReader.SuggestionType.COMPLETER);
        return result;
    }

    private IgnitePicocliCommands createPicocliCommands(Repl repl) throws Exception {
        CommandLine cmd = new CommandLine(repl.commandClass(), (CommandLine.IFactory)this.factory);
        CommandLine.IDefaultValueProvider defaultValueProvider = repl.defaultValueProvider();
        if (defaultValueProvider != null) {
            cmd.setDefaultValueProvider(defaultValueProvider);
        }
        CommandLineContextProvider.setCmd(cmd);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new PicocliExecutionExceptionHandler());
        DynamicCompleterRegistry completerRegistry = (DynamicCompleterRegistry)this.factory.create(DynamicCompleterRegistry.class);
        DynamicCompleterActivationPoint activationPoint = (DynamicCompleterActivationPoint)this.factory.create(DynamicCompleterActivationPoint.class);
        activationPoint.activateDynamicCompleter(completerRegistry);
        DynamicCompleterFilter dynamicCompleterFilter = (DynamicCompleterFilter)this.factory.create(DynamicCompleterFilter.class);
        return new IgnitePicocliCommands(cmd, completerRegistry, List.of(dynamicCompleterFilter));
    }
}

