/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorGroup {
    public static final String ERR_PREFIX = "IGN-";
    private static final Pattern EXCEPTION_MESSAGE_PATTERN = Pattern.compile("(.*)(IGN)-([A-Z]+)-(\\d+)\\s(TraceId:)([a-f0-9]{8}(?:-[a-f0-9]{4}){4}[a-f0-9]{8})(\\s?)(.*)", 32);
    private static final Int2ObjectMap<ErrorGroup> registeredGroups = new Int2ObjectOpenHashMap();
    private final String groupName;
    private final int groupCode;
    private final IntSet codes = new IntOpenHashSet();

    private ErrorGroup(String groupName, int groupCode) {
        this.groupName = groupName;
        this.groupCode = groupCode;
    }

    public String name() {
        return this.groupName;
    }

    public int code() {
        return this.groupCode;
    }

    public int registerErrorCode(int errorCode) {
        if (errorCode <= 0 || errorCode > 65535) {
            throw new IllegalArgumentException("Error code should be greater than 0 and less than or equal to 0xFFFF");
        }
        if (this.codes.contains(errorCode)) {
            throw new IllegalArgumentException("Error code already registered [errorCode=" + errorCode + ", group=" + this.name() + "]");
        }
        this.codes.add(errorCode);
        return this.code() << 16 | errorCode & 0xFFFF;
    }

    public boolean isRegistered(ErrorGroup group, int code) {
        return group.codes.contains(code);
    }

    public static synchronized ErrorGroup newGroup(String groupName, int groupCode) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Group name is null or empty");
        }
        String grpName = groupName.toUpperCase(Locale.ENGLISH);
        if (registeredGroups.containsKey(groupCode)) {
            throw new IllegalArgumentException("Error group already registered [groupName=" + groupName + ", groupCode=" + groupCode + ", registeredGroup=" + registeredGroups.get(groupCode) + "]");
        }
        for (ErrorGroup group : registeredGroups.values()) {
            if (!group.name().equals(groupName)) continue;
            throw new IllegalArgumentException("Error group already registered [groupName=" + groupName + ", groupCode=" + groupCode + ", registeredGroup=" + group + "]");
        }
        ErrorGroup newGroup = new ErrorGroup(grpName, groupCode);
        registeredGroups.put(groupCode, (Object)newGroup);
        return newGroup;
    }

    public static int extractGroupCode(int code) {
        return code >>> 16;
    }

    public static int extractErrorCode(int code) {
        return code & 0xFFFF;
    }

    public static ErrorGroup errorGroupByCode(int groupCode) {
        return (ErrorGroup)registeredGroups.get(groupCode);
    }

    public static String errorMessage(UUID traceId, int code, String message) {
        return ErrorGroup.errorMessage(traceId, ((ErrorGroup)registeredGroups.get(ErrorGroup.extractGroupCode(code))).name(), code, message);
    }

    public static String errorMessage(UUID traceId, String groupName, int code, String message) {
        return ERR_PREFIX + groupName + "-" + ErrorGroup.extractErrorCode(code) + " TraceId:" + traceId + (String)(message != null ? " " + message : "");
    }

    public static String errorMessageFromCause(UUID traceId, int code, Throwable cause) {
        return ErrorGroup.errorMessageFromCause(traceId, ((ErrorGroup)registeredGroups.get(ErrorGroup.extractGroupCode(code))).name(), code, cause);
    }

    public static String errorMessageFromCause(UUID traceId, String groupName, int code, Throwable cause) {
        String c;
        String string = c = cause != null && cause.getMessage() != null ? cause.getMessage() : null;
        if (c != null) {
            c = ErrorGroup.extractCauseMessage(c);
        }
        return ErrorGroup.errorMessage(traceId, groupName, code, c);
    }

    public static String extractCauseMessage(String errorMessage) {
        if (errorMessage == null) {
            return null;
        }
        Matcher m = EXCEPTION_MESSAGE_PATTERN.matcher(errorMessage);
        return m.matches() ? m.group(8) : errorMessage;
    }

    public String toString() {
        return "ErrorGroup [name=" + this.name() + ", code=" + this.code() + "]";
    }
}

