/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.client.table.ClientColumn;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.util.IgniteNameUtils;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.NotNull;

public final class ClientTuple
implements Tuple {
    private static final Object NULL_OBJ = new Object();
    private final Object[] vals;
    private final ClientSchema schema;
    private final int minColumnIndex;
    private final int maxColumnIndex;

    public ClientTuple(ClientSchema schema) {
        this(schema, 0, schema.columns().length - 1);
    }

    public ClientTuple(ClientSchema schema, int minColumnIndex, int maxColumnIndex) {
        assert (schema != null) : "Schema can't be null.";
        assert (schema.columns().length > 0) : "Schema can't be empty.";
        assert (minColumnIndex >= 0) : "offset >= 0";
        assert (maxColumnIndex >= minColumnIndex) : "maxColumnIndex >= minColumnIndex";
        assert (maxColumnIndex < schema.columns().length) : "maxColumnIndex < schema.columns().length";
        this.schema = schema;
        this.vals = new Object[maxColumnIndex + 1 - minColumnIndex];
        this.minColumnIndex = minColumnIndex;
        this.maxColumnIndex = maxColumnIndex;
    }

    public Tuple set(@NotNull String columnName, Object value) {
        ClientColumn col = this.schema.column(IgniteNameUtils.parseSimpleName((String)columnName));
        this.vals[col.schemaIndex() - this.minColumnIndex] = value == null ? NULL_OBJ : value;
        return this;
    }

    public <T> T valueOrDefault(@NotNull String columnName, T def) {
        ClientColumn col = this.schema.columnSafe(IgniteNameUtils.parseSimpleName((String)columnName));
        if (col == null) {
            return def;
        }
        Object val = this.vals[col.schemaIndex() - this.minColumnIndex];
        return (T)(val == null ? def : ClientTuple.convertValue(val));
    }

    public <T> T value(@NotNull String columnName) {
        ClientColumn col = this.schema.column(IgniteNameUtils.parseSimpleName((String)columnName));
        return this.getValue(col.schemaIndex() - this.minColumnIndex);
    }

    public <T> T value(int columnIndex) {
        Objects.checkIndex(columnIndex, this.vals.length);
        return this.getValue(columnIndex);
    }

    public int columnCount() {
        return this.vals.length;
    }

    public String columnName(int columnIndex) {
        Objects.checkIndex(columnIndex, this.vals.length);
        return this.schema.columns()[columnIndex + this.minColumnIndex].name();
    }

    public int columnIndex(@NotNull String columnName) {
        ClientColumn col = this.schema.columnSafe(IgniteNameUtils.parseSimpleName((String)columnName));
        if (col == null || col.schemaIndex() < this.minColumnIndex || col.schemaIndex() > this.maxColumnIndex) {
            return -1;
        }
        return col.schemaIndex() - this.minColumnIndex;
    }

    public BinaryObject binaryObjectValue(@NotNull String columnName) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public BinaryObject binaryObjectValue(int columnIndex) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public byte byteValue(@NotNull String columnName) {
        return (Byte)this.value(columnName);
    }

    public byte byteValue(int columnIndex) {
        return (Byte)this.value(columnIndex);
    }

    public short shortValue(@NotNull String columnName) {
        return (Short)this.value(columnName);
    }

    public short shortValue(int columnIndex) {
        return (Short)this.value(columnIndex);
    }

    public int intValue(@NotNull String columnName) {
        return (Integer)this.value(columnName);
    }

    public int intValue(int columnIndex) {
        return (Integer)this.value(columnIndex);
    }

    public long longValue(@NotNull String columnName) {
        return (Long)this.value(columnName);
    }

    public long longValue(int columnIndex) {
        return (Long)this.value(columnIndex);
    }

    public float floatValue(@NotNull String columnName) {
        return ((Float)this.value(columnName)).floatValue();
    }

    public float floatValue(int columnIndex) {
        return ((Float)this.value(columnIndex)).floatValue();
    }

    public double doubleValue(@NotNull String columnName) {
        return (Double)this.value(columnName);
    }

    public double doubleValue(int columnIndex) {
        return (Double)this.value(columnIndex);
    }

    public String stringValue(@NotNull String columnName) {
        return (String)this.value(columnName);
    }

    public String stringValue(int columnIndex) {
        return (String)this.value(columnIndex);
    }

    public UUID uuidValue(@NotNull String columnName) {
        return (UUID)this.value(columnName);
    }

    public UUID uuidValue(int columnIndex) {
        return (UUID)this.value(columnIndex);
    }

    public BitSet bitmaskValue(@NotNull String columnName) {
        return (BitSet)this.value(columnName);
    }

    public BitSet bitmaskValue(int columnIndex) {
        return (BitSet)this.value(columnIndex);
    }

    public LocalDate dateValue(String columnName) {
        return (LocalDate)this.value(columnName);
    }

    public LocalDate dateValue(int columnIndex) {
        return (LocalDate)this.value(columnIndex);
    }

    public LocalTime timeValue(String columnName) {
        return (LocalTime)this.value(columnName);
    }

    public LocalTime timeValue(int columnIndex) {
        return (LocalTime)this.value(columnIndex);
    }

    public LocalDateTime datetimeValue(String columnName) {
        return (LocalDateTime)this.value(columnName);
    }

    public LocalDateTime datetimeValue(int columnIndex) {
        return (LocalDateTime)this.value(columnIndex);
    }

    public Instant timestampValue(String columnName) {
        return (Instant)this.value(columnName);
    }

    public Instant timestampValue(int columnIndex) {
        return (Instant)this.value(columnIndex);
    }

    @NotNull
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private int cur;

            @Override
            public boolean hasNext() {
                return this.cur < ClientTuple.this.vals.length;
            }

            @Override
            public Object next() {
                return this.cur < ClientTuple.this.vals.length ? ClientTuple.this.vals[this.cur++] : null;
            }
        };
    }

    public int hashCode() {
        return Tuple.hashCode((Tuple)this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tuple) {
            return Tuple.equals((Tuple)this, (Tuple)((Tuple)obj));
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientTuple [");
        for (int i = 0; i < this.columnCount(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.columnName(i)).append('=').append(this.value(i));
        }
        sb.append(']');
        return sb.toString();
    }

    public void setInternal(int columnIndex, Object value) {
        this.vals[columnIndex] = value;
    }

    public ClientSchema schema() {
        return this.schema;
    }

    private <T> T getValue(int columnIndex) {
        return (T)ClientTuple.convertValue(this.vals[columnIndex]);
    }

    private static <T> T convertValue(T val) {
        return val == NULL_OBJ ? null : (T)val;
    }
}

