/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.tx;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.client.ClientChannel;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionException;

public class ClientTransaction
implements Transaction {
    private static final int STATE_OPEN = 0;
    private static final int STATE_COMMITTED = 1;
    private static final int STATE_ROLLED_BACK = 2;
    private final ClientChannel ch;
    private final long id;
    private final AtomicInteger state = new AtomicInteger(0);

    public ClientTransaction(ClientChannel ch, long id) {
        this.ch = ch;
        this.id = id;
    }

    public long id() {
        return this.id;
    }

    public ClientChannel channel() {
        return this.ch;
    }

    public void commit() throws TransactionException {
        ClientUtils.sync(this.commitAsync());
    }

    public CompletableFuture<Void> commitAsync() {
        this.setState(1);
        return this.ch.serviceAsync(44, w -> w.out().packLong(this.id), r -> null);
    }

    public void rollback() throws TransactionException {
        ClientUtils.sync(this.rollbackAsync());
    }

    public CompletableFuture<Void> rollbackAsync() {
        this.setState(2);
        return this.ch.serviceAsync(45, w -> w.out().packLong(this.id), r -> null);
    }

    private void setState(int state) {
        int oldState = this.state.compareAndExchange(0, state);
        if (oldState == 0) {
            return;
        }
        String message = oldState == 1 ? "Transaction is already committed." : "Transaction is already rolled back.";
        throw new TransactionException(message);
    }

    public boolean isReadOnly() {
        return false;
    }

    public HybridTimestamp readTimestamp() {
        return null;
    }
}

