/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.client.RetryLimitPolicy;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.AbstractClientView;
import org.apache.ignite.internal.client.table.ClientDataStreamer;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite.internal.client.table.TupleStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.ReceiverDescriptor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;

public class ClientRecordBinaryView
extends AbstractClientView<Tuple>
implements RecordView<Tuple> {
    private final ClientTupleSerializer ser;

    ClientRecordBinaryView(ClientTable tbl, ClientSql sql) {
        super(tbl, sql);
        this.ser = new ClientTupleSerializer(tbl.tableId());
    }

    @Override
    public Tuple get(@Nullable Transaction tx, Tuple keyRec) {
        return ViewUtils.sync(this.getAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(12, (s2, w) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s2, (PayloadOutputChannel)w, true), (s2, r) -> ClientTupleSerializer.readTuple(s2, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, keyRec), tx);
    }

    @Override
    public List<Tuple> getAll(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        return ViewUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    @Override
    public CompletableFuture<List<Tuple>> getAllAsync(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        ViewUtils.checkCollectionForNulls(keyRecs, "keyRecs", "key");
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(15, (s2, w) -> this.ser.writeTuples(tx, keyRecs, (ClientSchema)s2, (PayloadOutputChannel)w, true), (s2, r) -> ClientTupleSerializer.readTuplesNullable(s2, r.in()), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, keyRecs.iterator().next()), tx);
    }

    @Override
    public boolean contains(@Nullable Transaction tx, Tuple key) {
        return ViewUtils.sync(this.containsAsync(tx, key));
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(33, (s2, w) -> this.ser.writeTuple(tx, key, (ClientSchema)s2, (PayloadOutputChannel)w, true), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, key), tx);
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.tbl.doSchemaOutOpAsync(67, (s2, w) -> this.ser.writeTuples(tx, keys, (ClientSchema)s2, (PayloadOutputChannel)w, true), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, keys.iterator().next()), tx);
    }

    @Override
    public void upsert(@Nullable Transaction tx, Tuple rec) {
        ViewUtils.sync(this.upsertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(10, (s2, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s2, (PayloadOutputChannel)w), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, rec), tx);
    }

    @Override
    public void upsertAll(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.sync(this.upsertAllAsync(tx, recs));
    }

    @Override
    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.checkCollectionForNulls(recs, "recs", "rec");
        if (recs.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.tbl.doSchemaOutOpAsync(13, (s2, w) -> this.ser.writeTuples(tx, recs, (ClientSchema)s2, (PayloadOutputChannel)w, false), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, recs.iterator().next()), tx);
    }

    @Override
    public Tuple getAndUpsert(@Nullable Transaction tx, Tuple rec) {
        return ViewUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Tuple> getAndUpsertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(16, (s2, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s2, (PayloadOutputChannel)w, false), (s2, r) -> ClientTupleSerializer.readTuple(s2, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, rec), tx);
    }

    @Override
    public boolean insert(@Nullable Transaction tx, Tuple rec) {
        return ViewUtils.sync(this.insertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(18, (s2, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s2, (PayloadOutputChannel)w, false), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, rec), tx);
    }

    @Override
    public List<Tuple> insertAll(@Nullable Transaction tx, Collection<Tuple> recs) {
        return ViewUtils.sync(this.insertAllAsync(tx, recs));
    }

    @Override
    public CompletableFuture<List<Tuple>> insertAllAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.checkCollectionForNulls(recs, "recs", "rec");
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(20, (s2, w) -> this.ser.writeTuples(tx, recs, (ClientSchema)s2, (PayloadOutputChannel)w, false), (s2, r) -> ClientTupleSerializer.readTuples(s2, r.in()), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, recs.iterator().next()), tx);
    }

    @Override
    public boolean replace(@Nullable Transaction tx, Tuple rec) {
        return ViewUtils.sync(this.replaceAsync(tx, rec));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, Tuple oldRec, Tuple newRec) {
        return ViewUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(22, (s2, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s2, (PayloadOutputChannel)w, false), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, rec), tx);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple oldRec, Tuple newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.tbl.doSchemaOutOpAsync(24, (s2, w) -> {
            this.ser.writeTuple(tx, oldRec, (ClientSchema)s2, (PayloadOutputChannel)w, false, false);
            this.ser.writeTuple(tx, newRec, (ClientSchema)s2, (PayloadOutputChannel)w, false, true);
        }, r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, oldRec), tx);
    }

    @Override
    public Tuple getAndReplace(@Nullable Transaction tx, Tuple rec) {
        return ViewUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(26, (s2, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s2, (PayloadOutputChannel)w, false), (s2, r) -> ClientTupleSerializer.readTuple(s2, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, rec), tx);
    }

    @Override
    public boolean delete(@Nullable Transaction tx, Tuple keyRec) {
        return ViewUtils.sync(this.deleteAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutOpAsync(28, (s2, w) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s2, (PayloadOutputChannel)w, true), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, keyRec), tx);
    }

    @Override
    public boolean deleteExact(@Nullable Transaction tx, Tuple rec) {
        return ViewUtils.sync(this.deleteExactAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(30, (s2, w) -> this.ser.writeTuple(tx, rec, (ClientSchema)s2, (PayloadOutputChannel)w, false), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, rec), tx);
    }

    @Override
    public Tuple getAndDelete(@Nullable Transaction tx, Tuple keyRec) {
        return ViewUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<Tuple> getAndDeleteAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(32, (s2, w) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s2, (PayloadOutputChannel)w, true), (s2, r) -> ClientTupleSerializer.readTuple(s2, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, keyRec), tx);
    }

    @Override
    public List<Tuple> deleteAll(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        return ViewUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    @Override
    public CompletableFuture<List<Tuple>> deleteAllAsync(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        Objects.requireNonNull(keyRecs);
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(29, (s2, w) -> this.ser.writeTuples(tx, keyRecs, (ClientSchema)s2, (PayloadOutputChannel)w, true), (s2, r) -> ClientTupleSerializer.readTuples(s2, r.in(), true), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, keyRecs.iterator().next()), tx);
    }

    @Override
    public List<Tuple> deleteAllExact(@Nullable Transaction tx, Collection<Tuple> recs) {
        return ViewUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    @Override
    public CompletableFuture<List<Tuple>> deleteAllExactAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(31, (s2, w) -> this.ser.writeTuples(tx, recs, (ClientSchema)s2, (PayloadOutputChannel)w, false), (s2, r) -> ClientTupleSerializer.readTuples(s2, r.in()), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, recs.iterator().next()), tx);
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Tuple>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        TupleStreamerPartitionAwarenessProvider provider = new TupleStreamerPartitionAwarenessProvider(this.tbl);
        DataStreamerOptions opts = options == null ? DataStreamerOptions.DEFAULT : options;
        StreamerBatchSender batchSender = (partitionId, items, deleted) -> this.tbl.doSchemaOutOpAsync(62, (s2, w) -> this.ser.writeStreamerTuples((int)partitionId, items, deleted, (ClientSchema)s2, (PayloadOutputChannel)w), r -> null, PartitionAwarenessProvider.of(partitionId), new RetryLimitPolicy().retryLimit(opts.retryLimit()), null);
        return ClientDataStreamer.streamData(publisher, opts, batchSender, provider, this.tbl);
    }

    @Override
    public <E, V, R, A> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, Function<E, Tuple> keyFunc, Function<E, V> payloadFunc, ReceiverDescriptor<A> receiver, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options, A receiverArg) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        return ClientDataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options == null ? DataStreamerOptions.DEFAULT : options, new TupleStreamerPartitionAwarenessProvider(this.tbl), this.tbl, resultSubscriber, receiver.units(), receiver.receiverClassName(), receiverArg, receiver.argumentMarshaller());
    }
}

