/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.client.RetryPolicy;
import org.apache.ignite.internal.client.ClientSchemaVersionMismatchException;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.PayloadInputChannel;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.ColumnTypeConverter;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.ClientColumn;
import org.apache.ignite.internal.client.table.ClientKeyValueBinaryView;
import org.apache.ignite.internal.client.table.ClientKeyValueView;
import org.apache.ignite.internal.client.table.ClientPartitionManager;
import org.apache.ignite.internal.client.table.ClientRecordBinaryView;
import org.apache.ignite.internal.client.table.ClientRecordView;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite.internal.client.table.api.PublicApiClientKeyValueView;
import org.apache.ignite.internal.client.table.api.PublicApiClientRecordView;
import org.apache.ignite.internal.client.tx.ClientLazyTransaction;
import org.apache.ignite.internal.client.tx.ClientTransaction;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.marshaller.UnmappedColumnsException;
import org.apache.ignite.internal.tostring.IgniteToStringBuilder;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;
import org.apache.ignite.shaded.org.jetbrains.annotations.TestOnly;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.partition.PartitionManager;
import org.apache.ignite.tx.Transaction;

public class ClientTable
implements Table {
    private final int id;
    private final String name;
    private final ReliableChannel ch;
    private final MarshallersProvider marshallers;
    private final ClientSql sql;
    private final ConcurrentHashMap<Integer, CompletableFuture<ClientSchema>> schemas = new ConcurrentHashMap();
    private final IgniteLogger log;
    private static final int UNKNOWN_SCHEMA_VERSION = -1;
    private volatile int latestSchemaVer = -1;
    private final Object latestSchemaLock = new Object();
    private final Object partitionAssignmentLock = new Object();
    private volatile PartitionAssignment partitionAssignment = null;
    private volatile int partitionCount = -1;
    private final ClientPartitionManager clientPartitionManager;

    public ClientTable(ReliableChannel ch, MarshallersProvider marshallers, int id, String name) {
        assert (ch != null);
        assert (marshallers != null);
        assert (name != null && !name.isEmpty());
        this.ch = ch;
        this.marshallers = marshallers;
        this.id = id;
        this.name = name;
        this.log = ClientUtils.logger(ch.configuration(), ClientTable.class);
        this.sql = new ClientSql(ch, marshallers);
        this.clientPartitionManager = new ClientPartitionManager(this);
    }

    public int tableId() {
        return this.id;
    }

    ReliableChannel channel() {
        return this.ch;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public PartitionManager partitionManager() {
        return this.clientPartitionManager;
    }

    @Override
    public <R> RecordView<R> recordView(Mapper<R> recMapper) {
        Objects.requireNonNull(recMapper);
        return new PublicApiClientRecordView<R>(new ClientRecordView<R>(this, this.sql, recMapper));
    }

    @Override
    public RecordView<Tuple> recordView() {
        return new PublicApiClientRecordView<Tuple>(new ClientRecordBinaryView(this, this.sql));
    }

    @Override
    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valMapper);
        return new PublicApiClientKeyValueView<K, V>(new ClientKeyValueView<K, V>(this, this.sql, keyMapper, valMapper));
    }

    @Override
    public KeyValueView<Tuple, Tuple> keyValueView() {
        return new PublicApiClientKeyValueView<Tuple, Tuple>(new ClientKeyValueBinaryView(this, this.sql));
    }

    CompletableFuture<ClientSchema> getLatestSchema() {
        return this.getSchema(this.latestSchemaVer);
    }

    @TestOnly
    public CompletableFuture<ClientSchema> getSchemaByVersion(int schemaVersion) {
        return this.getSchema(schemaVersion);
    }

    private CompletableFuture<ClientSchema> getSchema(int ver) {
        CompletableFuture fut = this.schemas.computeIfAbsent(ver, this::loadSchema);
        if (fut.isCompletedExceptionally()) {
            this.schemas.remove(ver, fut);
            fut = this.schemas.computeIfAbsent(ver, this::loadSchema);
        }
        return fut;
    }

    private CompletableFuture<ClientSchema> loadSchema(int ver) {
        return this.ch.serviceAsync(5, w -> {
            w.out().packInt(this.id);
            if (ver == -1) {
                w.out().packNil();
            } else {
                w.out().packInt(1);
                w.out().packInt(ver);
            }
        }, r -> {
            ClientMessageUnpacker clientMessageUnpacker = r.in();
            int schemaCnt = clientMessageUnpacker.unpackInt();
            if (schemaCnt == 0) {
                this.log.warn("Schema not found [tableId=" + this.id + ", schemaVersion=" + ver + "]", new Object[0]);
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Schema not found: " + ver);
            }
            ClientSchema last = null;
            for (int i = 0; i < schemaCnt; ++i) {
                last = this.readSchema(r.in(), ver);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Schema loaded [tableId=" + this.id + ", schemaVersion=" + last.version() + "]", new Object[0]);
            }
            return last;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSchema readSchema(ClientMessageUnpacker in, int targetVer) {
        int schemaVer = in.unpackInt();
        int colCnt = in.unpackInt();
        ClientColumn[] columns = new ClientColumn[colCnt];
        int valCnt = 0;
        for (int i = 0; i < colCnt; ++i) {
            ClientColumn column;
            int propCnt = in.unpackInt();
            assert (propCnt >= 7);
            String name = in.unpackString();
            ColumnType type = ColumnTypeConverter.fromIdOrThrow(in.unpackInt());
            int keyIndex = in.unpackInt();
            boolean isNullable = in.unpackBoolean();
            int colocationIndex = in.unpackInt();
            int scale = in.unpackInt();
            int precision = in.unpackInt();
            int valIndex = keyIndex < 0 ? valCnt++ : -1;
            in.skipValues(propCnt - 7);
            columns[i] = column = new ClientColumn(name, type, isNullable, keyIndex, valIndex, colocationIndex, i, scale, precision);
        }
        ClientSchema schema = new ClientSchema(schemaVer, columns, this.marshallers);
        if (schemaVer != targetVer) {
            this.schemas.put(schemaVer, CompletableFuture.completedFuture(schema));
        }
        Object object = this.latestSchemaLock;
        synchronized (object) {
            if (schemaVer > this.latestSchemaVer) {
                this.latestSchemaVer = schemaVer;
            }
        }
        return schema;
    }

    public String toString() {
        return IgniteToStringBuilder.toString(ClientTable.class, this);
    }

    public static void writeTx(@Nullable Transaction tx, PayloadOutputChannel out) {
        if (tx == null) {
            out.out().packNil();
        } else {
            ClientTransaction clientTx = ClientTransaction.get(tx);
            if (clientTx.channel() != out.clientChannel()) {
                throw new IgniteException(ErrorGroups.Client.CONNECTION_ERR, "Transaction context has been lost due to connection errors.");
            }
            out.out().packLong(clientTx.id());
        }
    }

    public <T> CompletableFuture<T> doSchemaOutOpAsync(int opCode, BiConsumer<ClientSchema, PayloadOutputChannel> writer, Function<PayloadInputChannel, T> reader, @Nullable PartitionAwarenessProvider provider, @Nullable Transaction tx) {
        return this.doSchemaOutInOpAsync(opCode, writer, (schema, unpacker) -> reader.apply((PayloadInputChannel)unpacker), null, false, provider, null, null, false, tx);
    }

    public <T> CompletableFuture<T> doSchemaOutOpAsync(int opCode, BiConsumer<ClientSchema, PayloadOutputChannel> writer, Function<PayloadInputChannel, T> reader, @Nullable PartitionAwarenessProvider provider, boolean expectNotifications, @Nullable Transaction tx) {
        return this.doSchemaOutInOpAsync(opCode, writer, (schema, unpacker) -> reader.apply((PayloadInputChannel)unpacker), null, false, provider, null, null, expectNotifications, tx);
    }

    <T> CompletableFuture<T> doSchemaOutOpAsync(int opCode, BiConsumer<ClientSchema, PayloadOutputChannel> writer, Function<PayloadInputChannel, T> reader, @Nullable PartitionAwarenessProvider provider, @Nullable RetryPolicy retryPolicyOverride, @Nullable Transaction tx) {
        return this.doSchemaOutInOpAsync(opCode, writer, (schema, unpacker) -> reader.apply((PayloadInputChannel)unpacker), null, false, provider, retryPolicyOverride, null, false, tx);
    }

    <T> CompletableFuture<T> doSchemaOutInOpAsync(int opCode, BiConsumer<ClientSchema, PayloadOutputChannel> writer, BiFunction<ClientSchema, PayloadInputChannel, T> reader, @Nullable T defaultValue, @Nullable PartitionAwarenessProvider provider, @Nullable Transaction tx) {
        return this.doSchemaOutInOpAsync(opCode, writer, reader, defaultValue, true, provider, null, null, false, tx);
    }

    private <T> CompletableFuture<T> doSchemaOutInOpAsync(int opCode, BiConsumer<ClientSchema, PayloadOutputChannel> writer, BiFunction<ClientSchema, PayloadInputChannel, T> reader, @Nullable T defaultValue, boolean responseSchemaRequired, @Nullable PartitionAwarenessProvider provider, @Nullable RetryPolicy retryPolicyOverride, @Nullable Integer schemaVersionOverride, boolean expectNotifications, @Nullable Transaction tx) {
        CompletableFuture fut = new CompletableFuture();
        CompletableFuture<ClientSchema> schemaFut = this.getSchema(schemaVersionOverride == null ? this.latestSchemaVer : schemaVersionOverride);
        CompletableFuture partitionsFut = provider == null || !provider.isPartitionAwarenessEnabled() ? CompletableFutures.nullCompletedFuture() : this.getPartitionAssignment();
        ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(schemaFut, partitionsFut).thenCompose(v -> {
            ClientSchema schema = schemaFut.getNow(null);
            String txPreferredNodeName = ClientTable.getPreferredNodeName(provider, partitionsFut.getNow(null), schema);
            return ClientLazyTransaction.ensureStarted(tx, this.ch, txPreferredNodeName).thenCompose(unused -> {
                String opPreferredNodeName = ClientTable.getPreferredNodeName(provider, partitionsFut.getNow(null), schema);
                return this.ch.serviceAsync(opCode, w -> writer.accept(schema, w), r -> this.readSchemaAndReadData(schema, r, reader, defaultValue, responseSchemaRequired), opPreferredNodeName, retryPolicyOverride, expectNotifications);
            });
        })).thenCompose(t2 -> this.loadSchemaAndReadData(t2, reader))).whenComplete((res, err) -> {
            if (err == null) {
                fut.complete(res);
                return;
            }
            for (Throwable cause = err; cause != null; cause = cause.getCause()) {
                if (cause instanceof ClientSchemaVersionMismatchException) {
                    int expectedVersion = ((ClientSchemaVersionMismatchException)cause).expectedVersion();
                    this.doSchemaOutInOpAsync(opCode, writer, reader, defaultValue, responseSchemaRequired, provider, retryPolicyOverride, expectedVersion, expectNotifications, tx).whenComplete((res0, err0) -> {
                        if (err0 != null) {
                            fut.completeExceptionally((Throwable)err0);
                        } else {
                            fut.complete(res0);
                        }
                    });
                    return;
                }
                if (schemaVersionOverride != null || !(cause instanceof UnmappedColumnsException)) continue;
                this.schemas.remove(-1);
                this.doSchemaOutInOpAsync(opCode, writer, reader, defaultValue, responseSchemaRequired, provider, retryPolicyOverride, -1, expectNotifications, tx).whenComplete((res0, err0) -> {
                    if (err0 != null) {
                        fut.completeExceptionally((Throwable)err0);
                    } else {
                        fut.complete(res0);
                    }
                });
                return;
            }
            fut.completeExceptionally((Throwable)err);
        });
        return fut;
    }

    @Nullable
    private <T> Object readSchemaAndReadData(ClientSchema knownSchema, PayloadInputChannel in, BiFunction<ClientSchema, PayloadInputChannel, T> fn, @Nullable T defaultValue, boolean responseSchemaRequired) {
        ClientSchema resSchema;
        int schemaVer = in.in().unpackInt();
        if (!responseSchemaRequired) {
            this.ensureSchemaLoadedAsync(schemaVer);
            return fn.apply(null, in);
        }
        if (in.in().tryUnpackNil()) {
            this.ensureSchemaLoadedAsync(schemaVer);
            return defaultValue;
        }
        ClientSchema clientSchema = resSchema = schemaVer == knownSchema.version() ? knownSchema : this.schemas.get(schemaVer);
        if (resSchema != null) {
            return fn.apply(knownSchema, in);
        }
        in.in().retain();
        return new IgniteBiTuple<PayloadInputChannel, Integer>(in, schemaVer);
    }

    private <T> CompletionStage<T> loadSchemaAndReadData(Object data, BiFunction<ClientSchema, PayloadInputChannel, T> fn) {
        if (!(data instanceof IgniteBiTuple)) {
            return CompletableFuture.completedFuture(data);
        }
        IgniteBiTuple biTuple = (IgniteBiTuple)data;
        PayloadInputChannel in = (PayloadInputChannel)biTuple.getKey();
        Integer schemaId = (Integer)biTuple.getValue();
        assert (in != null);
        assert (schemaId != null);
        CompletionStage resFut = this.getSchema(schemaId).thenApply(schema -> fn.apply((ClientSchema)schema, in));
        ((CompletableFuture)resFut).handle((tuple, err) -> {
            in.close();
            return null;
        });
        return resFut;
    }

    private void ensureSchemaLoadedAsync(int schemaVer) {
        if (this.schemas.get(schemaVer) == null) {
            this.getSchema(schemaVer);
        }
    }

    private static boolean isPartitionAssignmentValid(PartitionAssignment pa, long timestamp) {
        return pa != null && pa.timestamp >= timestamp && !pa.partitionsFut.isCompletedExceptionally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized CompletableFuture<List<String>> getPartitionAssignment() {
        PartitionAssignment pa = this.partitionAssignment;
        long timestamp = this.ch.partitionAssignmentTimestamp();
        if (ClientTable.isPartitionAssignmentValid(pa, timestamp)) {
            return pa.partitionsFut;
        }
        Object object = this.partitionAssignmentLock;
        synchronized (object) {
            pa = this.partitionAssignment;
            if (ClientTable.isPartitionAssignmentValid(pa, timestamp)) {
                return pa.partitionsFut;
            }
            PartitionAssignment newAssignment = new PartitionAssignment();
            newAssignment.timestamp = timestamp;
            newAssignment.partitionsFut = this.ch.serviceAsync(53, w -> {
                w.out().packInt(this.id);
                w.out().packLong(timestamp);
            }, r -> {
                int cnt = r.in().unpackInt();
                assert (cnt >= 0) : "Invalid partition count: " + cnt;
                int oldPartitionCount = this.partitionCount;
                if (oldPartitionCount < 0) {
                    this.partitionCount = cnt;
                } else if (oldPartitionCount != cnt) {
                    throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, String.format("Partition count has changed for table '%s': %d -> %d", this.name, oldPartitionCount, cnt));
                }
                boolean assignmentAvailable = r.in().unpackBoolean();
                if (!assignmentAvailable) {
                    newAssignment.timestamp = 0L;
                    return new ArrayList(cnt);
                }
                long ts = r.in().unpackLong();
                assert (ts >= timestamp) : "Returned timestamp is older than requested: " + ts + " < " + timestamp;
                newAssignment.timestamp = ts;
                ArrayList<String> res = new ArrayList<String>(cnt);
                for (int i = 0; i < cnt; ++i) {
                    res.add(r.in().tryUnpackNil() ? null : r.in().unpackString());
                }
                return res;
            });
            this.partitionAssignment = newAssignment;
            return newAssignment.partitionsFut;
        }
    }

    int tryGetPartitionCount() {
        return this.partitionCount;
    }

    @Nullable
    private static String getPreferredNodeName(@Nullable PartitionAwarenessProvider provider, @Nullable List<String> partitions, ClientSchema schema) {
        if (provider == null) {
            return null;
        }
        String nodeName = provider.nodeName();
        if (nodeName != null) {
            return nodeName;
        }
        if (partitions == null || partitions.isEmpty()) {
            return null;
        }
        Integer partition = provider.partition();
        if (partition != null) {
            return partitions.get(partition);
        }
        Integer hash = provider.getObjectHashCode(schema);
        if (hash == null) {
            return null;
        }
        return partitions.get(Math.abs(hash % partitions.size()));
    }

    private static class PartitionAssignment {
        volatile long timestamp = 0L;
        CompletableFuture<List<String>> partitionsFut;

        private PartitionAssignment() {
        }
    }
}

