/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.util.UUID;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.util.IgniteNameUtils;

public class ColumnNotFoundException
extends IgniteException {
    public ColumnNotFoundException(String columnName) {
        super(ErrorGroups.Table.COLUMN_NOT_FOUND_ERR, "Column does not exist [name=" + IgniteNameUtils.quote(columnName) + "]");
    }

    public ColumnNotFoundException(String schemaName, String tableName, String columnName) {
        super(ErrorGroups.Table.COLUMN_NOT_FOUND_ERR, "Column does not exist [tableName=" + IgniteNameUtils.canonicalName(schemaName, tableName) + ", columnName=" + IgniteNameUtils.quote(columnName) + "]");
    }

    public ColumnNotFoundException(UUID traceId, int code, String message, Throwable cause) {
        super(traceId, code, message, cause);
    }
}

