/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.io.netty.channel;

import java.util.ArrayDeque;
import org.apache.ignite.shaded.io.netty.buffer.ByteBuf;
import org.apache.ignite.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.ignite.shaded.io.netty.buffer.CompositeByteBuf;
import org.apache.ignite.shaded.io.netty.channel.Channel;
import org.apache.ignite.shaded.io.netty.channel.ChannelFuture;
import org.apache.ignite.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.ignite.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.ignite.shaded.io.netty.channel.ChannelOutboundInvoker;
import org.apache.ignite.shaded.io.netty.channel.ChannelPromise;
import org.apache.ignite.shaded.io.netty.channel.DelegatingChannelPromiseNotifier;
import org.apache.ignite.shaded.io.netty.channel.PendingBytesTracker;
import org.apache.ignite.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.ignite.shaded.io.netty.util.internal.ObjectUtil;
import org.apache.ignite.shaded.io.netty.util.internal.PlatformDependent;
import org.apache.ignite.shaded.io.netty.util.internal.logging.InternalLogger;
import org.apache.ignite.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class AbstractCoalescingBufferQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractCoalescingBufferQueue.class);
    private final ArrayDeque<Object> bufAndListenerPairs;
    private final PendingBytesTracker tracker;
    private int readableBytes;

    protected AbstractCoalescingBufferQueue(Channel channel, int initSize) {
        this.bufAndListenerPairs = new ArrayDeque(initSize);
        this.tracker = channel == null ? null : PendingBytesTracker.newTracker(channel);
    }

    public final void addFirst(ByteBuf buf, ChannelPromise promise) {
        this.addFirst(buf, AbstractCoalescingBufferQueue.toChannelFutureListener(promise));
    }

    private void addFirst(ByteBuf buf, ChannelFutureListener listener) {
        buf.touch();
        if (listener != null) {
            this.bufAndListenerPairs.addFirst(listener);
        }
        this.bufAndListenerPairs.addFirst(buf);
        this.incrementReadableBytes(buf.readableBytes());
    }

    public final void add(ByteBuf buf) {
        this.add(buf, (ChannelFutureListener)null);
    }

    public final void add(ByteBuf buf, ChannelPromise promise) {
        this.add(buf, AbstractCoalescingBufferQueue.toChannelFutureListener(promise));
    }

    public final void add(ByteBuf buf, ChannelFutureListener listener) {
        buf.touch();
        this.bufAndListenerPairs.add(buf);
        if (listener != null) {
            this.bufAndListenerPairs.add(listener);
        }
        this.incrementReadableBytes(buf.readableBytes());
    }

    public final ByteBuf removeFirst(ChannelPromise aggregatePromise) {
        Object entry = this.bufAndListenerPairs.poll();
        if (entry == null) {
            return null;
        }
        assert (entry instanceof ByteBuf);
        ByteBuf result = (ByteBuf)entry;
        this.decrementReadableBytes(result.readableBytes());
        entry = this.bufAndListenerPairs.peek();
        if (entry instanceof ChannelFutureListener) {
            aggregatePromise.addListener((ChannelFutureListener)entry);
            this.bufAndListenerPairs.poll();
        }
        return result;
    }

    public final ByteBuf remove(ByteBufAllocator alloc, int bytes, ChannelPromise aggregatePromise) {
        ObjectUtil.checkPositiveOrZero(bytes, "bytes");
        ObjectUtil.checkNotNull(aggregatePromise, "aggregatePromise");
        if (this.bufAndListenerPairs.isEmpty()) {
            assert (this.readableBytes == 0);
            return this.removeEmptyValue();
        }
        bytes = Math.min(bytes, this.readableBytes);
        ByteBuf toReturn = null;
        ByteBuf entryBuffer = null;
        int originalBytes = bytes;
        Object entry = null;
        try {
            while ((entry = this.bufAndListenerPairs.poll()) != null) {
                if (entry instanceof ByteBuf) {
                    entryBuffer = (ByteBuf)entry;
                    int bufferBytes = entryBuffer.readableBytes();
                    if (bufferBytes > bytes) {
                        this.bufAndListenerPairs.addFirst(entryBuffer);
                        if (bytes > 0) {
                            entryBuffer = entryBuffer.readRetainedSlice(bytes);
                            toReturn = toReturn == null ? entryBuffer : this.compose(alloc, toReturn, entryBuffer);
                            bytes = 0;
                        }
                        break;
                    }
                    toReturn = toReturn == null ? (bytes == 0 ? entryBuffer : this.composeFirst(alloc, entryBuffer, bufferBytes + (bytes -= bufferBytes))) : this.compose(alloc, toReturn, entryBuffer);
                    entryBuffer = null;
                    continue;
                }
                if (entry instanceof DelegatingChannelPromiseNotifier) {
                    aggregatePromise.addListener((DelegatingChannelPromiseNotifier)entry);
                    continue;
                }
                if (!(entry instanceof ChannelFutureListener)) continue;
                aggregatePromise.addListener((ChannelFutureListener)entry);
            }
        }
        catch (Throwable cause) {
            this.decrementReadableBytes(originalBytes - bytes);
            entry = this.bufAndListenerPairs.peek();
            if (entry instanceof ChannelFutureListener) {
                aggregatePromise.addListener((ChannelFutureListener)entry);
                this.bufAndListenerPairs.poll();
            }
            ReferenceCountUtil.safeRelease(entryBuffer);
            ReferenceCountUtil.safeRelease(toReturn);
            aggregatePromise.setFailure(cause);
            PlatformDependent.throwException(cause);
        }
        this.decrementReadableBytes(originalBytes - bytes);
        return toReturn;
    }

    public final int readableBytes() {
        return this.readableBytes;
    }

    public final boolean isEmpty() {
        return this.bufAndListenerPairs.isEmpty();
    }

    public final void releaseAndFailAll(ChannelOutboundInvoker invoker, Throwable cause) {
        this.releaseAndCompleteAll(invoker.newFailedFuture(cause));
    }

    public final void copyTo(AbstractCoalescingBufferQueue dest) {
        dest.bufAndListenerPairs.addAll(this.bufAndListenerPairs);
        dest.incrementReadableBytes(this.readableBytes);
    }

    public final void writeAndRemoveAll(ChannelHandlerContext ctx) {
        Throwable pending = null;
        ByteBuf previousBuf = null;
        while (true) {
            Object entry = this.bufAndListenerPairs.poll();
            try {
                if (entry == null) {
                    if (previousBuf == null) break;
                    this.decrementReadableBytes(previousBuf.readableBytes());
                    ctx.write(previousBuf, ctx.voidPromise());
                    break;
                }
                if (entry instanceof ByteBuf) {
                    if (previousBuf != null) {
                        this.decrementReadableBytes(previousBuf.readableBytes());
                        ctx.write(previousBuf, ctx.voidPromise());
                    }
                    previousBuf = (ByteBuf)entry;
                    continue;
                }
                if (entry instanceof ChannelPromise) {
                    this.decrementReadableBytes(previousBuf.readableBytes());
                    ctx.write(previousBuf, (ChannelPromise)entry);
                    previousBuf = null;
                    continue;
                }
                this.decrementReadableBytes(previousBuf.readableBytes());
                ctx.write(previousBuf).addListener((ChannelFutureListener)entry);
                previousBuf = null;
            }
            catch (Throwable t2) {
                if (pending == null) {
                    pending = t2;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)pending, (Object)t2);
            }
        }
        if (pending != null) {
            throw new IllegalStateException(pending);
        }
    }

    public String toString() {
        return "bytes: " + this.readableBytes + " buffers: " + (this.size() >> 1);
    }

    protected abstract ByteBuf compose(ByteBufAllocator var1, ByteBuf var2, ByteBuf var3);

    protected final ByteBuf composeIntoComposite(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next) {
        CompositeByteBuf composite = alloc.compositeBuffer(this.size() + 2);
        try {
            composite.addComponent(true, cumulation);
            composite.addComponent(true, next);
        }
        catch (Throwable cause) {
            composite.release();
            ReferenceCountUtil.safeRelease(next);
            PlatformDependent.throwException(cause);
        }
        return composite;
    }

    protected final ByteBuf copyAndCompose(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next) {
        ByteBuf newCumulation = alloc.ioBuffer(cumulation.readableBytes() + next.readableBytes());
        try {
            newCumulation.writeBytes(cumulation).writeBytes(next);
        }
        catch (Throwable cause) {
            newCumulation.release();
            ReferenceCountUtil.safeRelease(next);
            PlatformDependent.throwException(cause);
        }
        cumulation.release();
        next.release();
        return newCumulation;
    }

    protected ByteBuf composeFirst(ByteBufAllocator allocator, ByteBuf first, int bufferSize) {
        return this.composeFirst(allocator, first);
    }

    @Deprecated
    protected ByteBuf composeFirst(ByteBufAllocator allocator, ByteBuf first) {
        return first;
    }

    protected abstract ByteBuf removeEmptyValue();

    protected final int size() {
        return this.bufAndListenerPairs.size();
    }

    private void releaseAndCompleteAll(ChannelFuture future) {
        Object entry;
        Throwable pending = null;
        while ((entry = this.bufAndListenerPairs.poll()) != null) {
            try {
                if (entry instanceof ByteBuf) {
                    ByteBuf buffer = (ByteBuf)entry;
                    this.decrementReadableBytes(buffer.readableBytes());
                    ReferenceCountUtil.safeRelease(buffer);
                    continue;
                }
                ((ChannelFutureListener)entry).operationComplete(future);
            }
            catch (Throwable t2) {
                if (pending == null) {
                    pending = t2;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)pending, (Object)t2);
            }
        }
        if (pending != null) {
            throw new IllegalStateException(pending);
        }
    }

    private void incrementReadableBytes(int increment) {
        int nextReadableBytes = this.readableBytes + increment;
        if (nextReadableBytes < this.readableBytes) {
            throw new IllegalStateException("buffer queue length overflow: " + this.readableBytes + " + " + increment);
        }
        this.readableBytes = nextReadableBytes;
        if (this.tracker != null) {
            this.tracker.incrementPendingOutboundBytes(increment);
        }
    }

    private void decrementReadableBytes(int decrement) {
        this.readableBytes -= decrement;
        assert (this.readableBytes >= 0);
        if (this.tracker != null) {
            this.tracker.decrementPendingOutboundBytes(decrement);
        }
    }

    private static ChannelFutureListener toChannelFutureListener(ChannelPromise promise) {
        return promise.isVoid() ? null : new DelegatingChannelPromiseNotifier(promise);
    }
}

