/*
 * Decompiled with CFR 0.152.
 */
package org.treesitter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.treesitter.CleanerRunner;
import org.treesitter.TSInputEdit;
import org.treesitter.TSLanguage;
import org.treesitter.TSNode;
import org.treesitter.TSParser;
import org.treesitter.TSPoint;
import org.treesitter.TSRange;

public class TSTree {
    private final long ptr;
    private TSLanguage language;

    TSTree(long ptr, TSLanguage language) {
        this.ptr = ptr;
        this.language = language;
        CleanerRunner.register(this, new TSTreeCleanAction(ptr));
    }

    protected void setLanguage(TSLanguage language) {
        this.language = language;
    }

    protected long getPtr() {
        return this.ptr;
    }

    public TSTree copy() {
        return new TSTree(TSParser.ts_tree_copy(this.ptr), this.language);
    }

    public TSNode getRootNode() {
        TSNode node = TSParser.ts_tree_root_node(this.ptr);
        node.setTree(this);
        return node;
    }

    public TSNode getRootNodeWithOffset(int offsetBytes, TSPoint offsetPoint) {
        TSNode node = TSParser.ts_tree_root_node_with_offset(this.ptr, offsetBytes, offsetPoint);
        node.setTree(this);
        return node;
    }

    public TSLanguage getLanguage() {
        return this.language;
    }

    public TSRange[] getIncludedRanges() {
        return TSParser.ts_tree_included_ranges(this.ptr);
    }

    public void edit(TSInputEdit inputEdit) {
        TSParser.ts_tree_edit(this.ptr, inputEdit);
    }

    public static TSRange[] getChangedRanges(TSTree oldTree, TSTree newTree) {
        return TSParser.ts_tree_get_changed_ranges(oldTree.getPtr(), newTree.getPtr());
    }

    public void printDotGraphs(File file) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        TSParser.ts_tree_print_dot_graph(this.ptr, outputStream.getFD());
        outputStream.close();
    }

    private static class TSTreeCleanAction
    implements Runnable {
        private final long ptr;

        public TSTreeCleanAction(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public void run() {
            TSParser.ts_tree_delete(this.ptr);
        }
    }
}

