/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.runtime.ImmutablePairList;
import org.apache.calcite.runtime.PairList;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mappings;

public class RelRoot {
    public final RelNode rel;
    public final RelDataType validatedRowType;
    public final SqlKind kind;
    public final ImmutablePairList<Integer, String> fields;
    public final RelCollation collation;
    public final ImmutableList<RelHint> hints;

    public RelRoot(RelNode rel, RelDataType validatedRowType, SqlKind kind, Iterable<? extends Map.Entry<Integer, String>> fields, RelCollation collation, List<RelHint> hints) {
        this.rel = rel;
        this.validatedRowType = validatedRowType;
        this.kind = kind;
        this.fields = ImmutablePairList.copyOf(fields);
        this.collation = Objects.requireNonNull(collation, "collation");
        this.hints = ImmutableList.copyOf(hints);
    }

    public static RelRoot of(RelNode rel, SqlKind kind) {
        return RelRoot.of(rel, rel.getRowType(), kind);
    }

    public static RelRoot of(RelNode rel, RelDataType rowType, SqlKind kind) {
        PairList<Integer, String> fields = PairList.of();
        Pair.forEach(ImmutableIntList.identity(rowType.getFieldCount()), rowType.getFieldNames(), fields::add);
        return new RelRoot(rel, rowType, kind, fields, RelCollations.EMPTY, (List<RelHint>)ImmutableList.of());
    }

    public String toString() {
        return "Root {kind: " + (Object)((Object)this.kind) + ", rel: " + this.rel + ", rowType: " + this.validatedRowType + ", fields: " + this.fields + ", collation: " + this.collation + "}";
    }

    public RelRoot withRel(RelNode rel) {
        if (rel == this.rel) {
            return this;
        }
        return new RelRoot(rel, this.validatedRowType, this.kind, (Iterable<? extends Map.Entry<Integer, String>>)this.fields, this.collation, (List<RelHint>)this.hints);
    }

    public RelRoot withKind(SqlKind kind) {
        if (kind == this.kind) {
            return this;
        }
        return new RelRoot(this.rel, this.validatedRowType, kind, (Iterable<? extends Map.Entry<Integer, String>>)this.fields, this.collation, (List<RelHint>)this.hints);
    }

    public RelRoot withCollation(RelCollation collation) {
        return new RelRoot(this.rel, this.validatedRowType, this.kind, (Iterable<? extends Map.Entry<Integer, String>>)this.fields, collation, (List<RelHint>)this.hints);
    }

    public RelRoot withHints(List<RelHint> hints) {
        return new RelRoot(this.rel, this.validatedRowType, this.kind, this.fields, this.collation, hints);
    }

    public RelNode project() {
        return this.project(false);
    }

    public RelNode project(boolean force) {
        if (this.isRefTrivial() && (SqlKind.DML.contains((Object)this.kind) || !force || this.rel instanceof LogicalProject && this.isNameTrivial())) {
            return this.rel;
        }
        ArrayList projects = new ArrayList(this.fields.size());
        RexBuilder rexBuilder = this.rel.getCluster().getRexBuilder();
        this.fields.forEach((i, name) -> projects.add(rexBuilder.makeInputRef(this.rel, (int)i)));
        return LogicalProject.create(this.rel, this.hints, projects, this.fields.rightList(), (Set<CorrelationId>)ImmutableSet.of());
    }

    public boolean isNameTrivial() {
        RelDataType inputRowType = this.rel.getRowType();
        return this.fields.rightList().equals(inputRowType.getFieldNames());
    }

    public boolean isRefTrivial() {
        if (SqlKind.DML.contains((Object)this.kind)) {
            return true;
        }
        RelDataType inputRowType = this.rel.getRowType();
        return Mappings.isIdentity(this.fields.leftList(), inputRowType.getFieldCount());
    }

    public boolean isCollationTrivial() {
        List<RelCollation> collations = this.rel.getTraitSet().getTraits(RelCollationTraitDef.INSTANCE);
        return collations != null && collations.size() == 1 && collations.get(0).equals(this.collation);
    }
}

